/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod.fabric;

import com.terraformersmc.modmenu.util.TextureUtil;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.ModContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabricIconHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mod Menu | FabricIconHandler");
    private final Map<Path, BufferedImage> modIconCache = new HashMap<Path, BufferedImage>();

    public BufferedImage createIcon(ModContainer iconSource, String iconPath) {
        BufferedImage bufferedImage;
        block14: {
            Path path = iconSource.getPath(iconPath);
            BufferedImage cachedIcon = this.getCachedModIcon(path);
            if (cachedIcon != null) {
                return cachedIcon;
            }
            cachedIcon = this.getCachedModIcon(path);
            if (cachedIcon != null) {
                return cachedIcon;
            }
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                BufferedImage image = TextureUtil.readImage(inputStream);
                if (image.getWidth() != image.getHeight()) {
                    throw new IllegalStateException("must be a square icon");
                }
                this.cacheModIcon(path, image);
                bufferedImage = image;
                if (inputStream == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().equals("Must be square icon")) {
                        LOGGER.error("Mod icon must be a square for icon source {}: {}", (Object)iconSource.getMetadata().getId(), (Object)iconPath, (Object)e);
                    }
                    return null;
                }
                catch (Throwable t) {
                    if (!iconPath.equals("/assets/" + iconSource.getMetadata().getId() + "/icon.png")) {
                        LOGGER.error("Invalid mod icon for icon source {}: {}", (Object)iconSource.getMetadata().getId(), (Object)iconPath, (Object)t);
                    }
                    return null;
                }
            }
            inputStream.close();
        }
        return bufferedImage;
    }

    BufferedImage getCachedModIcon(Path path) {
        return this.modIconCache.get(path);
    }

    void cacheModIcon(Path path, BufferedImage tex) {
        this.modIconCache.put(path, tex);
    }
}

