/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.enderkitty.ClientFireTick;
import net.enderkitty.SoulFireEntityAccessor;
import net.enderkitty.config.FireHudConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10799;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FireHud
implements ClientModInitializer {
    public static final String MOD_ID = "firehud";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"firehud");
    private static FireHudConfig config;
    private static final class_2960 FIRE_TINT;
    private static final class_2960 FIRE_METER;
    private static final class_2960 THERMOMETER;
    private static final class_2960 THERMOMETER_TEMP;
    private static final class_2960 THERMOMETER_TEMP_SOUL;

    public void onInitializeClient() {
        if (FireHud.isClothConfigLoaded()) {
            ConfigHolder configHolder = AutoConfig.register(FireHudConfig.class, GsonConfigSerializer::new);
            config = (FireHudConfig)configHolder.getConfig();
        }
        HudElementRegistry.attachElementAfter((class_2960)VanillaHudElements.MISC_OVERLAYS, (class_2960)FIRE_TINT, this::fireTint);
        HudElementRegistry.attachElementAfter((class_2960)VanillaHudElements.HOTBAR, (class_2960)FIRE_METER, this::thermometer);
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            class_746 player = client.field_1724;
            if (player != null && client.field_1687 != null) {
                int clientFireTick;
                class_1293 fireRes = player.method_6112(class_1294.field_5918);
                if (FireHud.config.displayFireResTimer && player.method_6059(class_1294.field_5918) && fireRes != null && !fireRes.method_48559()) {
                    String styling = fireRes.method_5584() > 120 && fireRes.method_5584() <= 220 ? "\u00a76" : (fireRes.method_5584() <= 120 ? "\u00a74" : "\u00a7f");
                    class_2561 durationSeconds = class_1292.method_5577((class_1293)fireRes, (float)1.0f, (float)client.field_1687.method_54719().method_54748());
                    class_5250 durationTicks = class_2561.method_43470((String)String.valueOf(player.method_6112(class_1294.field_5918).method_5584()));
                    class_5250 fireResText = class_2561.method_43471((String)"text.firehud.hud.fireResTimer");
                    class_5250 text = class_2561.method_43470((String)(fireResText.getString() + styling + (FireHud.config.fireResTimerAsTicks ? durationTicks : durationSeconds).getString()));
                    if (FireHud.config.renderWithTimeLeft == 0) {
                        player.method_7353((class_2561)text, true);
                    } else if (FireHud.config.renderWithTimeLeft > 0 && fireRes.method_5584() <= FireHud.config.renderWithTimeLeft * 20) {
                        player.method_7353((class_2561)text, true);
                    }
                }
                if (FireHud.config.thermometer && (clientFireTick = ((ClientFireTick)player).fireHud$clientFireTick()) > 0) {
                    if (player.method_56992() || !player.method_5809()) {
                        ((ClientFireTick)player).fireHud$setClientFireTick(0);
                    }
                    if (client.method_1576() == null || !client.method_1576().method_54809()) {
                        if (player.method_5753()) {
                            ((ClientFireTick)player).fireHud$setClientFireTick(clientFireTick - 4);
                        } else {
                            ((ClientFireTick)player).fireHud$setClientFireTick(clientFireTick - 1);
                        }
                    }
                }
            }
        });
    }

    private void thermometer(class_332 context, class_9779 tickCounter) {
        int clientFireTick;
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && (clientFireTick = ((ClientFireTick)client.field_1724).fireHud$clientFireTick()) > 0 && (client.field_1724.method_56992() || !client.field_1724.method_5809())) {
            ((ClientFireTick)client.field_1724).fireHud$setClientFireTick(0);
        }
        if (FireHud.config.thermometer) {
            if (!FireHud.config.onlyShowWhenOnFire) {
                this.renderTherm(context, client);
            } else if (client.field_1724 != null && client.field_1724.method_5809()) {
                this.renderTherm(context, client);
            }
        }
    }

    private void renderTherm(class_332 context, class_310 client) {
        class_746 class_7462;
        if (FireHud.config.thermometer && (class_7462 = client.field_1724) instanceof ClientFireTick) {
            ClientFireTick player = (ClientFireTick)class_7462;
            if (FireHud.config.showFireTicks) {
                context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)String.valueOf(player.fireHud$clientFireTick())), this.thermNumPos(context, player), context.method_51443() / 2 - 22 + 44, -1, true);
            }
            context.method_25290(class_10799.field_56883, THERMOMETER, FireHud.config.onLeftSide ? 6 : context.method_51421() - 16, context.method_51443() / 2 - 22, 0.0f, 0.0f, 10, 44, 10, 44);
            if (client.field_1724.method_5809()) {
                int i = class_3532.method_15386((float)(this.getThermProgress() * 43.0f)) + 1;
                context.method_25290(class_10799.field_56883, this.thermSprite(), FireHud.config.onLeftSide ? 6 : context.method_51421() - 16, context.method_51443() / 2 - 22 + 44 - i, 0.0f, (float)(44 - i), 10, i, 10, 44);
            }
        }
    }

    private class_2960 thermSprite() {
        SoulFireEntityAccessor player = (SoulFireEntityAccessor)class_310.method_1551().field_1724;
        return player != null && player.fireHud$isOnSoulFire() ? THERMOMETER_TEMP_SOUL : THERMOMETER_TEMP;
    }

    private int thermNumPos(class_332 context, ClientFireTick player) {
        int n;
        int length = String.valueOf(player.fireHud$clientFireTick()).length();
        int value = 14;
        for (int i = 1; i < length; ++i) {
            value += 6 * i - 6;
        }
        if (FireHud.config.onLeftSide) {
            n = 9;
        } else {
            int n2 = context.method_51421();
            n = n2 - (switch (length) {
                case 1 -> 14;
                case 2 -> 20;
                case 3 -> 26;
                case 4 -> 32;
                case 5 -> 38;
                default -> value;
            });
        }
        return n;
    }

    public float getThermProgress() {
        class_746 playerEntity = class_310.method_1551().field_1724;
        if (playerEntity instanceof ClientFireTick) {
            ClientFireTick player = (ClientFireTick)playerEntity;
            int max = 300;
            return class_3532.method_15363((float)((float)player.fireHud$clientFireTick() / (float)max), (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }

    private void fireTint(class_332 context, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        int width = context.method_51421();
        int height = context.method_51443();
        if (player != null && player.method_5809() && client.field_1690.method_31044().method_31034() && (FireHud.config.renderFireInLava || !player.method_5771()) && (FireHud.config.renderWithFireResistance || !player.method_6059(class_1294.field_5918))) {
            if (FireHud.config.fireScreenTint && !((SoulFireEntityAccessor)player).fireHud$isOnSoulFire()) {
                context.method_25296(0, 0, width, height, FireHud.config.fireStartColor, FireHud.config.fireEndColor);
            }
            if (FireHud.config.fireScreenTint && FireHud.config.renderSoulFire && ((SoulFireEntityAccessor)player).fireHud$isOnSoulFire()) {
                context.method_25296(0, 0, width, height, FireHud.config.soulFireStartColor, FireHud.config.soulFireEndColor);
            }
        }
    }

    public static FireHudConfig getConfig() {
        return config;
    }

    public static boolean isClothConfigLoaded() {
        return FabricLoader.getInstance().isModLoaded("cloth-config2");
    }

    static {
        FIRE_TINT = class_2960.method_60655((String)MOD_ID, (String)"fire_tint");
        FIRE_METER = class_2960.method_60655((String)MOD_ID, (String)"fire_meter");
        THERMOMETER = class_2960.method_60655((String)MOD_ID, (String)"textures/gui/sprites/hud/thermometer.png");
        THERMOMETER_TEMP = class_2960.method_60655((String)MOD_ID, (String)"textures/gui/sprites/hud/thermometer_temp.png");
        THERMOMETER_TEMP_SOUL = class_2960.method_60655((String)MOD_ID, (String)"textures/gui/sprites/hud/thermometer_temp_soul.png");
    }
}

