/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mixin;

import net.enderkitty.EnchantTags;
import net.enderkitty.FireHud;
import net.enderkitty.SoulFireEntityAccessor;
import net.enderkitty.config.FireHudConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.tag.client.v1.ClientTags;
import net.minecraft.class_10799;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3922;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_329.class})
public abstract class InGameHudMixin {
    @Unique
    private static final class_2960 FIRE_VIGNETTE = class_2960.method_60655((String)"firehud", (String)"textures/fire/fire_vignette.png");
    @Unique
    private static final class_2960 SOUL_FIRE_VIGNETTE = class_2960.method_60655((String)"firehud", (String)"textures/fire/soul_fire_vignette.png");
    @Unique
    private static final class_2960 FIRE_HEART_FULL_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/fire_full");
    @Unique
    private static final class_2960 FIRE_HEART_FULL_BLINKING_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/fire_full_blinking");
    @Unique
    private static final class_2960 FIRE_HEART_HALF_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/fire_half");
    @Unique
    private static final class_2960 FIRE_HEART_HALF_BLINKING_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/fire_half_blinking");
    @Unique
    private static final class_2960 FIRE_HEART_HARDCORE_FULL_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/fire_hardcore_full");
    @Unique
    private static final class_2960 FIRE_HEART_HARDCORE_FULL_BLINKING_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/fire_hardcore_full_blinking");
    @Unique
    private static final class_2960 FIRE_HEART_HARDCORE_HALF_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/fire_hardcore_half");
    @Unique
    private static final class_2960 FIRE_HEART_HARDCORE_HALF_BLINKING_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/fire_hardcore_half_blinking");
    @Unique
    private static final class_2960 SOUL_FIRE_HEART_FULL_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/soul_fire_full");
    @Unique
    private static final class_2960 SOUL_FIRE_HEART_FULL_BLINKING_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/soul_fire_full_blinking");
    @Unique
    private static final class_2960 SOUL_FIRE_HEART_HALF_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/soul_fire_half");
    @Unique
    private static final class_2960 SOUL_FIRE_HEART_HALF_BLINKING_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/soul_fire_half_blinking");
    @Unique
    private static final class_2960 SOUL_FIRE_HEART_HARDCORE_FULL_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/soul_fire_hardcore_full");
    @Unique
    private static final class_2960 SOUL_FIRE_HEART_HARDCORE_FULL_BLINKING_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/soul_fire_hardcore_full_blinking");
    @Unique
    private static final class_2960 SOUL_FIRE_HEART_HARDCORE_HALF_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/soul_fire_hardcore_half");
    @Unique
    private static final class_2960 SOUL_FIRE_HEART_HARDCORE_HALF_BLINKING_TEXTURE = class_2960.method_60655((String)"firehud", (String)"hud/heart/soul_fire_hardcore_half_blinking");
    @Unique
    FireHudConfig config = FireHud.getConfig();

    @Inject(method={"drawHeart"}, at={@At(value="HEAD")}, cancellable=true)
    private void drawHeart(class_332 context, class_329.class_6411 type, int x, int y, boolean hardcore, boolean blinking, boolean half, CallbackInfo ci) {
        class_1297 class_12972 = class_310.method_1551().method_1560();
        if (class_12972 instanceof class_1657) {
            class_1657 playerEntity = (class_1657)class_12972;
            if ((this.config.renderWithFireResistance || !playerEntity.method_6059(class_1294.field_5918)) && this.config.renderFireHearts && type == class_329.class_6411.field_33945) {
                boolean hasFrostWalkerOnBoots = false;
                for (class_6880 enchantment : playerEntity.method_6118(class_1304.field_6166).method_58657().method_57534()) {
                    if (!ClientTags.isInWithLocalFallback(EnchantTags.FROST_WALKER, (class_6880)enchantment)) continue;
                    hasFrostWalkerOnBoots = true;
                }
                boolean isOnSoulFire = ((SoulFireEntityAccessor)playerEntity).fireHud$isOnSoulFire();
                if (playerEntity.method_5809() || !hasFrostWalkerOnBoots && (playerEntity.method_25936().method_26204() == class_2246.field_10092 && !playerEntity.method_21749() || playerEntity.method_25936().method_26204() instanceof class_3922 && ((Boolean)playerEntity.method_25936().method_11654((class_2769)class_2741.field_12548)).booleanValue())) {
                    if (this.config.renderSoulFire && (isOnSoulFire || playerEntity.method_25936().method_26204() == class_2246.field_23860)) {
                        context.method_52706(class_10799.field_56883, this.getSoulFireHeartTexture(hardcore, half, blinking), x, y, 9, 9);
                        ci.cancel();
                    } else {
                        context.method_52706(class_10799.field_56883, this.getFireHeartTexture(hardcore, half, blinking), x, y, 9, 9);
                        ci.cancel();
                    }
                }
            }
        }
    }

    @Unique
    private boolean scaleHelper(int scale) {
        int hudScale = this.config.vignetteScale;
        int guiScale = (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
        return hudScale == scale || hudScale == 0 && guiScale == scale;
    }

    @Inject(method={"renderMiscOverlays"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerEntity;getFrozenTicks()I")})
    private void render(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        int var3;
        int var2;
        int var1;
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        class_2960 texture = player != null && ((SoulFireEntityAccessor)player).fireHud$isOnSoulFire() ? SOUL_FIRE_VIGNETTE : FIRE_VIGNETTE;
        int width = context.method_51421();
        int height = context.method_51443();
        int n = this.scaleHelper(4) ? 1 : (this.scaleHelper(3) ? 2 : (this.scaleHelper(2) ? 3 : (var1 = this.scaleHelper(1) ? 4 : 1)));
        int n2 = this.scaleHelper(4) ? 2 : (this.scaleHelper(3) ? 4 : (this.scaleHelper(2) ? 6 : (var2 = this.scaleHelper(1) ? 8 : 2)));
        int n3 = this.scaleHelper(4) ? 1 : (this.scaleHelper(3) ? 3 : (this.scaleHelper(2) ? 5 : (var3 = this.scaleHelper(1) ? 7 : 3)));
        if (player != null && (this.config.renderFireInLava || !player.method_5771()) && (this.config.renderWithFireResistance || !player.method_6059(class_1294.field_5918)) && player.method_5809() && client.field_1690.method_31044().method_31034()) {
            if (this.config.fireVignette == FireHudConfig.VignetteOptions.FULL) {
                this.renderTopLeftCorner(texture, context, width, height, var1, var2);
                this.renderTopRightCorner(texture, context, width, height, var1, var2, var3);
                this.renderBottomLeftCorner(texture, context, width, height, var1, var2, var3);
                this.renderBottomRightCorner(texture, context, width, height, var1, var2, var3);
            }
            if (this.config.fireVignette == FireHudConfig.VignetteOptions.UPPER) {
                this.renderTopLeftCorner(texture, context, width, height, var1, var2);
                this.renderTopRightCorner(texture, context, width, height, var1, var2, var3);
            }
            if (this.config.fireVignette == FireHudConfig.VignetteOptions.LOWER) {
                this.renderBottomLeftCorner(texture, context, width, height, var1, var2, var3);
                this.renderBottomRightCorner(texture, context, width, height, var1, var2, var3);
            }
        }
    }

    @Unique
    private void renderTopLeftCorner(class_2960 texture, class_332 context, int width, int height, int var1, int var2) {
        this.renderOverlay(context, texture, this.config.vignetteOpacity, 0, 0, 0, 0, width / var2, height / var2, width / var1, height / var1);
    }

    @Unique
    private void renderTopRightCorner(class_2960 texture, class_332 context, int width, int height, int var1, int var2, int var3) {
        this.renderOverlay(context, texture, this.config.vignetteOpacity, width / var2 * var3, 0, width / var2, 0, width, height / var2, width / var1, height / var1);
    }

    @Unique
    private void renderBottomLeftCorner(class_2960 texture, class_332 context, int width, int height, int var1, int var2, int var3) {
        this.renderOverlay(context, texture, this.config.vignetteOpacity, 0, height / var2 * var3, 0, height / var2, width / var2, height, width / var1, height / var1);
    }

    @Unique
    private void renderBottomRightCorner(class_2960 texture, class_332 context, int width, int height, int var1, int var2, int var3) {
        this.renderOverlay(context, texture, this.config.vignetteOpacity, width / var2 * var3, height / var2 * var3, width / var2, height / var2, width, height, width / var1, height / var1);
    }

    @Unique
    private void renderOverlay(class_332 context, class_2960 texture, float opacity, int xPos, int yPos, int uStart, int vStart, int uEnd, int vEnd, int textureWidth, int textureHeight) {
        int i = class_9848.method_61317((float)opacity);
        context.method_25291(class_10799.field_56883, texture, xPos, yPos, (float)uStart, (float)vStart, uEnd, vEnd, textureWidth, textureHeight, i);
    }

    @Unique
    public class_2960 getFireHeartTexture(boolean hardcore, boolean half, boolean blinking) {
        if (!hardcore) {
            if (half) {
                return blinking ? FIRE_HEART_HALF_BLINKING_TEXTURE : FIRE_HEART_HALF_TEXTURE;
            }
            return blinking ? FIRE_HEART_FULL_BLINKING_TEXTURE : FIRE_HEART_FULL_TEXTURE;
        }
        if (half) {
            return blinking ? FIRE_HEART_HARDCORE_HALF_BLINKING_TEXTURE : FIRE_HEART_HARDCORE_HALF_TEXTURE;
        }
        return blinking ? FIRE_HEART_HARDCORE_FULL_BLINKING_TEXTURE : FIRE_HEART_HARDCORE_FULL_TEXTURE;
    }

    @Unique
    public class_2960 getSoulFireHeartTexture(boolean hardcore, boolean half, boolean blinking) {
        if (!hardcore) {
            if (half) {
                return blinking ? SOUL_FIRE_HEART_HALF_BLINKING_TEXTURE : SOUL_FIRE_HEART_HALF_TEXTURE;
            }
            return blinking ? SOUL_FIRE_HEART_FULL_BLINKING_TEXTURE : SOUL_FIRE_HEART_FULL_TEXTURE;
        }
        if (half) {
            return blinking ? SOUL_FIRE_HEART_HARDCORE_HALF_BLINKING_TEXTURE : SOUL_FIRE_HEART_HARDCORE_HALF_TEXTURE;
        }
        return blinking ? SOUL_FIRE_HEART_HARDCORE_FULL_BLINKING_TEXTURE : SOUL_FIRE_HEART_HARDCORE_FULL_TEXTURE;
    }
}

