/*
 * Decompiled with CFR 0.152.
 */
package com.Minor2CCh.fabricsimplegenerator.block.entity;

import com.Minor2CCh.fabricsimplegenerator.block.AbstractGeneratorBlock;
import com.Minor2CCh.fabricsimplegenerator.block.GeneratorTier;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public abstract class AbstractGeneratorBlockEntity
extends class_2624
implements class_1278 {
    public long CAPACITY;
    public long MAX_INSERT;
    public long MAX_EXTRACT;
    public long TICK_GENERATE;
    public SimpleEnergyStorage energyStorage;
    private long readCapacity = 0L;
    public static final int DEC_BURN_TIME = 4;
    private int burnTime = 0;
    private int startBurnTime = 0;
    public static final int PROPERTY_SIZE = 11;
    public static final int BURN_TIME_INDEX = 0;
    public static final int AMOUNT_INDEX = 1;
    public static final int CAPACITY_INDEX = 5;
    public static final int START_BURN_TIME_INDEX = 9;
    protected class_2371<class_1799> inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> AbstractGeneratorBlockEntity.this.burnTime;
                case 1 -> (int)(AbstractGeneratorBlockEntity.this.energyStorage.amount & 0xFFFFL);
                case 2 -> (int)(AbstractGeneratorBlockEntity.this.energyStorage.amount >> 16 & 0xFFFFL);
                case 3 -> (int)(AbstractGeneratorBlockEntity.this.energyStorage.amount >> 32 & 0xFFFFL);
                case 4 -> (int)(AbstractGeneratorBlockEntity.this.energyStorage.amount >> 48 & 0xFFFFL);
                case 5 -> (int)(AbstractGeneratorBlockEntity.this.CAPACITY & 0xFFFFL);
                case 6 -> (int)(AbstractGeneratorBlockEntity.this.CAPACITY >> 16 & 0xFFFFL);
                case 7 -> (int)(AbstractGeneratorBlockEntity.this.CAPACITY >> 32 & 0xFFFFL);
                case 8 -> (int)(AbstractGeneratorBlockEntity.this.CAPACITY >> 48 & 0xFFFFL);
                case 9 -> Math.min(Short.MAX_VALUE, AbstractGeneratorBlockEntity.this.startBurnTime);
                case 10 -> (int)AbstractGeneratorBlockEntity.this.TICK_GENERATE;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractGeneratorBlockEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    AbstractGeneratorBlockEntity.this.energyStorage.amount &= 0xFFFFFFFFFFFF0000L;
                    AbstractGeneratorBlockEntity.this.energyStorage.amount |= (long)(value & 0xFFFF);
                    break;
                }
                case 2: {
                    AbstractGeneratorBlockEntity.this.energyStorage.amount &= 0xFFFFFFFF0000FFFFL;
                    AbstractGeneratorBlockEntity.this.energyStorage.amount |= (long)value << 16 & 0xFFFF0000L;
                    break;
                }
                case 3: {
                    AbstractGeneratorBlockEntity.this.energyStorage.amount &= 0xFFFF0000FFFFFFFFL;
                    AbstractGeneratorBlockEntity.this.energyStorage.amount |= (long)value << 32 & 0xFFFF00000000L;
                    break;
                }
                case 4: {
                    AbstractGeneratorBlockEntity.this.energyStorage.amount &= 0xFFFFFFFFFFFFL;
                    AbstractGeneratorBlockEntity.this.energyStorage.amount |= (long)value << 48 & 0xFFFF000000000000L;
                    break;
                }
                case 9: {
                    AbstractGeneratorBlockEntity.this.startBurnTime = Math.min(Short.MAX_VALUE, value);
                }
            }
        }

        public int method_17389() {
            return 11;
        }
    };

    public AbstractGeneratorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    protected void setGeneratorSetting(GeneratorTier gTier, int gMul) {
        this.CAPACITY = gTier.CAPACITY * (long)gMul;
        this.MAX_INSERT = gTier.MAX_INSERT * (long)gMul;
        this.MAX_EXTRACT = gTier.MAX_EXTRACT * (long)gMul;
        this.TICK_GENERATE = gTier.TICK_GENERATE * (long)gMul;
        this.energyStorage = new SimpleEnergyStorage(this.CAPACITY, 0L, this.MAX_EXTRACT){

            protected void onFinalCommit() {
                AbstractGeneratorBlockEntity.this.method_5431();
            }
        };
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.energyStorage.amount = this.readCapacity = nbt.method_10537("readCapacity");
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        this.burnTime = nbt.method_10550("BurnTime");
        this.startBurnTime = nbt.method_10550("StartBurnTime");
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> inventory) {
        this.inventory = inventory;
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10544("readCapacity", this.readCapacity);
        nbt.method_10569("BurnTime", this.burnTime);
        nbt.method_10569("StartBurnTime", this.startBurnTime);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public void setCapacity(long value) {
        this.readCapacity = value;
        this.method_5431();
    }

    public long getCapacity() {
        return this.readCapacity;
    }

    public void setBurnTime(int value) {
        this.burnTime = value;
        this.method_5431();
    }

    public void setStartBurnTime(int value) {
        this.startBurnTime = value;
        this.method_5431();
    }

    public void decBurnTime(int value) {
        this.burnTime -= value;
        this.method_5431();
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int method_5439() {
        return 1;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return true;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return stack != null && !this.ingredientUsable(stack);
    }

    public int[] method_5494(class_2350 side) {
        return new int[]{0};
    }

    public abstract boolean ingredientUsable(class_1799 var1);

    public abstract int getIngredientTime(class_1799 var1);

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, AbstractGeneratorBlockEntity be) {
        be.tick(world, pos, state);
    }

    public static int decisionGenerateMul(long defaultGen, long capacity, long maxCapacity, int burnTime) {
        for (int i = 1; i <= 4 && i <= burnTime; ++i) {
            long gen = Math.round((double)defaultGen * (double)i / 4.0);
            if (capacity + gen < maxCapacity) continue;
            return i;
        }
        return 4;
    }

    protected void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236 && state.method_26204() instanceof AbstractGeneratorBlock) {
            if (this.getBurnTime() > 0) {
                this.energyStorage.amount = this.getCapacity();
                if (this.energyStorage.getAmount() != this.CAPACITY) {
                    int tickMul = AbstractGeneratorBlockEntity.decisionGenerateMul(this.TICK_GENERATE, this.energyStorage.amount, this.CAPACITY, this.getBurnTime());
                    long gen = Math.round((double)this.TICK_GENERATE * (double)tickMul / 4.0);
                    this.energyStorage.amount = Math.min(this.energyStorage.amount + gen, this.CAPACITY);
                    this.setCapacity(this.energyStorage.getAmount());
                    this.decBurnTime(tickMul);
                }
            }
            if (this.getBurnTime() <= 0) {
                class_1799 item = (class_1799)this.inventory.getFirst();
                int fuelTime = this.getIngredientTime(item);
                if (this.ingredientUsable(item) && fuelTime > 0 && item.method_7947() > 0) {
                    this.setStartBurnTime(fuelTime);
                    this.setBurnTime(fuelTime);
                    world.method_8501(pos, (class_2680)state.method_11657((class_2769)AbstractGeneratorBlock.LIT, (Comparable)Boolean.valueOf(true)));
                    class_1799 usedStack = this.consumeStack(world, pos, item);
                    this.inventory.set(0, (Object)usedStack);
                    this.method_5431();
                }
            }
            if (((Boolean)state.method_11654((class_2769)AbstractGeneratorBlock.LIT)).booleanValue() && this.getBurnTime() <= 0) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)AbstractGeneratorBlock.LIT, (Comparable)Boolean.valueOf(false)));
            }
            this.sendEnergy(world, pos, state);
        }
    }

    protected class_1799 consumeStack(class_1937 world, class_2338 pos, class_1799 stack) {
        if (!stack.getRecipeRemainder().method_7960()) {
            class_1792 remainItem = stack.getRecipeRemainder().method_7909();
            stack.method_7934(1);
            if (stack.method_7947() > 0) {
                if (!world.method_8608()) {
                    world.method_8649((class_1297)new class_1542(world, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, remainItem.method_7854()));
                }
                return stack;
            }
            return remainItem.method_7854();
        }
        stack.method_7934(1);
        return stack;
    }

    protected void sendEnergy(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 outputSide = (class_2350)state.method_11654((class_2769)AbstractGeneratorBlock.FACING);
        SimpleEnergyStorage sendStorage = this.energyStorage;
        if (sendStorage == null || sendStorage.getAmount() <= 0L) {
            return;
        }
        class_2338 neighborPos = pos.method_10093(outputSide);
        EnergyStorage receivedStorage = (EnergyStorage)EnergyStorage.SIDED.find(world, neighborPos, (Object)outputSide.method_10153());
        if (receivedStorage == null || !receivedStorage.supportsInsertion()) {
            return;
        }
        try (Transaction tx = Transaction.openOuter();){
            long extracted;
            long maxTransfer = Math.min(sendStorage.getAmount(), this.MAX_EXTRACT);
            long inserted = receivedStorage.insert(maxTransfer, (TransactionContext)tx);
            if (inserted > 0L && (extracted = sendStorage.extract(inserted, (TransactionContext)tx)) == inserted) {
                tx.commit();
            }
        }
        this.setCapacity(this.energyStorage.getAmount());
        this.method_5431();
    }
}

