/*
 * Decompiled with CFR 0.152.
 */
package com.Minor2CCh.fabricsimplegenerator.block.entity;

import com.Minor2CCh.fabricsimplegenerator.block.GeneratorTier;
import com.Minor2CCh.fabricsimplegenerator.block.SculkGeneratorBlock;
import com.Minor2CCh.fabricsimplegenerator.block.entity.AbstractGeneratorBlockEntity;
import com.Minor2CCh.fabricsimplegenerator.registry.FSGBlockEntityTypes;
import com.Minor2CCh.fabricsimplegenerator.registry.FSGItemTags;
import com.Minor2CCh.fabricsimplegenerator.screen.SculkGeneratorScreenHandler;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SculkGeneratorBlockEntity
extends AbstractGeneratorBlockEntity {
    private static volatile Map<class_1792, Integer> sculkTimes;

    public SculkGeneratorBlockEntity(@Nullable GeneratorTier gTier, int gMul, class_2338 pos, class_2680 state) {
        super(FSGBlockEntityTypes.SCULK_GENERATOR_BLOCK_ENTITY, pos, state);
        if (gTier != null) {
            this.setGeneratorSetting(gTier, gMul);
        }
    }

    public SculkGeneratorBlockEntity(class_2338 pos, class_2680 state) {
        super(FSGBlockEntityTypes.SCULK_GENERATOR_BLOCK_ENTITY, pos, state);
        GeneratorTier tempTier = SculkGeneratorBlock.getTier(state.method_26204());
        int tempMul = SculkGeneratorBlock.getMul(state.method_26204());
        if (tempTier != null) {
            this.setGeneratorSetting(tempTier, tempMul);
        }
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new SculkGeneratorScreenHandler(syncId, playerInventory, (class_1263)this, this.propertyDelegate);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new SculkGeneratorScreenHandler(syncId, inv, (class_1263)this, this.propertyDelegate);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.fsg.generator.sculk");
    }

    public static boolean sculkUsable(class_1799 stack) {
        return SculkGeneratorBlockEntity.sculkUsable(stack.method_7909());
    }

    public static boolean sculkUsable(class_1792 item) {
        Map<class_1792, Integer> sculkTimeMap = SculkGeneratorBlockEntity.createSculkTimeMap();
        return sculkTimeMap.containsKey(item);
    }

    public static int sculkTime(class_1799 stack) {
        return SculkGeneratorBlockEntity.sculkTime(stack.method_7909());
    }

    public static int sculkTime(class_1792 item) {
        Map<class_1792, Integer> sculkTimeMap = SculkGeneratorBlockEntity.createSculkTimeMap();
        return sculkTimeMap.getOrDefault(item, 0);
    }

    public static Map<class_1792, Integer> createSculkTimeMap() {
        Map<class_1792, Integer> map = sculkTimes;
        if (map != null) {
            return map;
        }
        LinkedHashMap map2 = Maps.newLinkedHashMap();
        SculkGeneratorBlockEntity.addSculk((Map<class_1792, Integer>)map2, (class_1935)class_1802.field_37524, 20);
        SculkGeneratorBlockEntity.addSculk((Map<class_1792, Integer>)map2, (class_1935)class_1802.field_37523, 100);
        SculkGeneratorBlockEntity.addSculk((Map<class_1792, Integer>)map2, (class_1935)class_1802.field_28101, 500);
        SculkGeneratorBlockEntity.addSculk((Map<class_1792, Integer>)map2, (class_1935)class_1802.field_37538, 1500);
        SculkGeneratorBlockEntity.addSculk((Map<class_1792, Integer>)map2, (class_1935)class_1802.field_37525, 1500);
        SculkGeneratorBlockEntity.addSculk((Map<class_1792, Integer>)map2, (class_1935)class_1802.field_38746, 12000);
        SculkGeneratorBlockEntity.addSculk((Map<class_1792, Integer>)map2, FSGItemTags.SCULK_INGREDIENT_BIT, 20);
        SculkGeneratorBlockEntity.addSculk((Map<class_1792, Integer>)map2, FSGItemTags.SCULK_INGREDIENT_LOW, 100);
        SculkGeneratorBlockEntity.addSculk((Map<class_1792, Integer>)map2, FSGItemTags.SCULK_INGREDIENT_MIDDLE, 500);
        SculkGeneratorBlockEntity.addSculk((Map<class_1792, Integer>)map2, FSGItemTags.SCULK_INGREDIENT_HIGH, 1500);
        SculkGeneratorBlockEntity.addSculk((Map<class_1792, Integer>)map2, FSGItemTags.SCULK_INGREDIENT_SPECIAL, 5000);
        SculkGeneratorBlockEntity.addSculk((Map<class_1792, Integer>)map2, FSGItemTags.SCULK_INGREDIENT_EXTRA, 12000);
        SculkGeneratorBlockEntity.addSculk((Map<class_1792, Integer>)map2, FSGItemTags.SCULK_INGREDIENT_ULTIMATE, 24000);
        sculkTimes = map2;
        return map2;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, SculkGeneratorBlockEntity be) {
        be.tick(world, pos, state);
    }

    private static void addSculk(Map<class_1792, Integer> sculkTimes, class_1935 item, int sculkTime) {
        class_1792 item2 = item.method_8389();
        sculkTimes.put(item2, sculkTime);
    }

    private static void addSculk(Map<class_1792, Integer> sculkTimes, class_6862<class_1792> tag, int sculkTime) {
        for (class_6880 registryEntry : class_7923.field_41178.method_40286(tag)) {
            sculkTimes.put((class_1792)registryEntry.comp_349(), sculkTime);
        }
    }

    @Override
    public boolean ingredientUsable(class_1799 itemStack) {
        return SculkGeneratorBlockEntity.sculkUsable(itemStack);
    }

    @Override
    public int getIngredientTime(class_1799 itemStack) {
        return SculkGeneratorBlockEntity.sculkTime(itemStack);
    }
}

