/*
 * Decompiled with CFR 0.152.
 */
package com.Minor2CCh.fabricsimplegenerator.client;

import com.Minor2CCh.fabricsimplegenerator.block.AbstractGeneratorBlock;
import com.Minor2CCh.fabricsimplegenerator.block.BiomassGeneratorBlock;
import com.Minor2CCh.fabricsimplegenerator.block.FuelGeneratorBlock;
import com.Minor2CCh.fabricsimplegenerator.block.SculkGeneratorBlock;
import com.Minor2CCh.fabricsimplegenerator.client.registry.FSGHandledScreens;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class FabricSimpleGeneratorClient
implements ClientModInitializer {
    public static final String TOOLTIP_HIDE = "item.fabric_simple_generator.hide_tooltip.desc";
    public static final String MAX_CAPACITY_FORMAT = String.format("item.%s.%s.%s", "fabric_simple_generator", "generator", "capacity");
    public static final String MAX_EXTRACT_FORMAT = String.format("item.%s.%s.%s", "fabric_simple_generator", "generator", "extract");
    public static final String TICK_GENERATE_FORMAT = String.format("item.%s.%s.%s", "fabric_simple_generator", "generator", "tick_generate");
    public static final String INGREDIENT_FORMAT = String.format("item.%s.%s.%s", "fabric_simple_generator", "generator", "ingredient");
    public static final String INGREDIENT_FUEL_FORMAT = String.format("item.%s.%s.%s.%s", "fabric_simple_generator", "generator", "ingredient", "fuel");
    public static final String INGREDIENT_SCULK_FORMAT = String.format("item.%s.%s.%s.%s", "fabric_simple_generator", "generator", "ingredient", "sculk");
    public static final String INGREDIENT_BIO_FORMAT = String.format("item.%s.%s.%s.%s", "fabric_simple_generator", "generator", "ingredient", "bio");
    public static final String INGREDIENT_UNDEFINED_FORMAT = String.format("item.%s.%s.%s.%s", "fabric_simple_generator", "generator", "ingredient", "undefined");
    public static final String AMOUNT_FORMAT = String.format("item.%s.%s.%s", "fabric_simple_generator", "generator", "amount");

    public void onInitializeClient() {
        ItemTooltipCallback.EVENT.register((stack, context, tooltipType, lines) -> {
            class_1747 blockItem;
            class_2248 patt1$temp;
            boolean hasShiftDown = class_437.method_25442();
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof class_1747 && (patt1$temp = (blockItem = (class_1747)patt0$temp).method_7711()) instanceof AbstractGeneratorBlock) {
                AbstractGeneratorBlock generatorBlock = (AbstractGeneratorBlock)patt1$temp;
                if (hasShiftDown) {
                    lines.add(class_2561.method_43469((String)MAX_CAPACITY_FORMAT, (Object[])new Object[]{FabricSimpleGeneratorClient.adjustEnergyUnit(generatorBlock.getCapacity())}).method_27692(class_124.field_1065));
                    lines.add(class_2561.method_43469((String)MAX_EXTRACT_FORMAT, (Object[])new Object[]{FabricSimpleGeneratorClient.adjustEnergyUnit(generatorBlock.getExtract())}).method_27692(class_124.field_1065));
                    lines.add(class_2561.method_43469((String)TICK_GENERATE_FORMAT, (Object[])new Object[]{FabricSimpleGeneratorClient.adjustEnergyUnit(generatorBlock.getTickGenerate()) + "/t"}).method_27692(class_124.field_1065));
                    lines.add(class_2561.method_43469((String)INGREDIENT_FORMAT, (Object[])new Object[]{class_2561.method_43471((String)FabricSimpleGeneratorClient.getIngredientText((class_2248)generatorBlock))}).method_27692(class_124.field_1065));
                } else {
                    lines.add(class_2561.method_43471((String)TOOLTIP_HIDE));
                }
            }
        });
        FSGHandledScreens.init();
    }

    public static String adjustEnergyUnit(long capacity) {
        int i;
        String[] capUnit = new String[]{"E", "kE", "ME", "GE", "TE"};
        long[] capAdjust = new long[capUnit.length + 1];
        for (i = 0; i < capAdjust.length; ++i) {
            capAdjust[i] = (long)Math.pow(10.0, i * 3);
        }
        for (i = 0; i < capUnit.length; ++i) {
            if (capacity >= capAdjust[i + 1]) continue;
            if (i == 0) {
                return capacity / capAdjust[i] + capUnit[i];
            }
            return (double)(capacity / (capAdjust[i] / 10L)) / 10.0 + capUnit[i];
        }
        return capacity + "E";
    }

    private static String getIngredientText(class_2248 block) {
        if (block instanceof FuelGeneratorBlock) {
            return INGREDIENT_FUEL_FORMAT;
        }
        if (block instanceof SculkGeneratorBlock) {
            return INGREDIENT_SCULK_FORMAT;
        }
        if (block instanceof BiomassGeneratorBlock) {
            return INGREDIENT_BIO_FORMAT;
        }
        return INGREDIENT_UNDEFINED_FORMAT;
    }
}

