/*
 * Decompiled with CFR 0.152.
 */
package com.Minor2CCh.fabricsimplegenerator.config;

import com.Minor2CCh.fabricsimplegenerator.config.FSGConfigLoader;
import java.util.LinkedHashMap;

public class FSGConfig {
    public LinkedHashMap<constantTier, Long> capacity = this.mapSet(FSGConfigLoader.defaultCapacity);
    public LinkedHashMap<constantTier, Long> extract = this.mapSet(FSGConfigLoader.defaultExtract);
    public LinkedHashMap<constantTier, Long> generate = this.mapSet(FSGConfigLoader.defaultGenerate);
    public Integer bioTime = 1000;

    public void fillDefaults() {
        if (this.capacity == null) {
            this.capacity = this.mapSet(FSGConfigLoader.defaultCapacity);
        }
        if (this.extract == null) {
            this.extract = this.mapSet(FSGConfigLoader.defaultExtract);
        }
        if (this.generate == null) {
            this.generate = this.mapSet(FSGConfigLoader.defaultGenerate);
        }
        if (this.bioTime == null) {
            this.bioTime = 1000;
        }
        for (constantTier tier : constantTier.values()) {
            this.capacity.computeIfAbsent(tier, t -> FSGConfigLoader.defaultCapacity[t.ordinal()]);
            this.extract.computeIfAbsent(tier, t -> FSGConfigLoader.defaultExtract[t.ordinal()]);
            this.generate.computeIfAbsent(tier, t -> FSGConfigLoader.defaultGenerate[t.ordinal()]);
        }
        this.capacity = this.sortMap(this.capacity, FSGConfigLoader.defaultCapacity);
        this.extract = this.sortMap(this.extract, FSGConfigLoader.defaultExtract);
        this.generate = this.sortMap(this.generate, FSGConfigLoader.defaultGenerate);
    }

    public LinkedHashMap<constantTier, Long> mapSet(Long[] baseArray) {
        LinkedHashMap<constantTier, Long> map = new LinkedHashMap<constantTier, Long>();
        for (constantTier tier : constantTier.values()) {
            map.put(tier, baseArray[tier.ordinal()]);
        }
        return map;
    }

    public LinkedHashMap<constantTier, Long> sortMap(LinkedHashMap<constantTier, Long> baseMap, Long[] baseArray) {
        LinkedHashMap<constantTier, Long> newMap = new LinkedHashMap<constantTier, Long>();
        for (constantTier fixTier : constantTier.values()) {
            newMap.put(fixTier, baseMap.getOrDefault((Object)fixTier, baseArray[fixTier.ordinal()]));
        }
        return newMap;
    }

    public static enum constantTier {
        IRON,
        COPPER,
        GOLD,
        EMERALD,
        DIAMOND,
        NETHERITE,
        SCULK,
        BIOMASS;

    }
}

