/*
 * Decompiled with CFR 0.152.
 */
package com.Minor2CCh.fabricsimplegenerator.config;

import com.Minor2CCh.fabricsimplegenerator.config.FSGConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import org.spongepowered.include.com.google.gson.Gson;
import org.spongepowered.include.com.google.gson.GsonBuilder;

public class FSGConfigLoader {
    private static final File DIR = FabricLoader.getInstance().getConfigDir().toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILENAME = "fabric_simple_generator.json";
    private static final Path CONFIG_PATH = Path.of(new File(DIR, "fabric_simple_generator.json").getPath(), new String[0]);
    public static final Long[] defaultCapacity = new Long[]{100000L, 80000L, 200000L, 400000L, 800000L, 1600000L, 400000L, 200000L};
    public static final Long[] defaultExtract = new Long[]{50L, 25L, 100L, 200L, 400L, 800L, 80L, 50L};
    public static final Long[] defaultGenerate = new Long[]{10L, 5L, 20L, 40L, 80L, 160L, 20L, 10L};
    public static final int defaultBioTime = 1000;
    private static FSGConfig modConfig;

    public static void load() {
        System.out.println(CONFIG_PATH);
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                modConfig = (FSGConfig)GSON.fromJson((Reader)reader, FSGConfig.class);
            }
            catch (Exception e) {
                System.err.println("Failed to load config: " + e.getMessage());
                modConfig = new FSGConfig();
            }
            try {
                modConfig.fillDefaults();
            }
            catch (Exception e) {
                System.err.println("Failed to load config: " + e.getMessage());
                modConfig = new FSGConfig();
            }
        } else {
            modConfig = new FSGConfig();
        }
        FSGConfigLoader.save();
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)modConfig, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    public static FSGConfig getConfig() {
        return modConfig;
    }

    public static long getConfigCapacity(FSGConfig.constantTier tier) {
        return FSGConfigLoader.getConfig().capacity.getOrDefault((Object)tier, defaultCapacity[tier.ordinal()]);
    }

    public static long getConfigExtract(FSGConfig.constantTier tier) {
        return FSGConfigLoader.getConfig().extract.getOrDefault((Object)tier, defaultCapacity[tier.ordinal()]);
    }

    public static long getConfigGenerate(FSGConfig.constantTier tier) {
        return FSGConfigLoader.getConfig().generate.getOrDefault((Object)tier, defaultGenerate[tier.ordinal()]);
    }
}

