/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.manager.init.start;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.command.SenderRequirement;
import ac.grim.grimac.command.commands.GrimAlerts;
import ac.grim.grimac.command.commands.GrimBrands;
import ac.grim.grimac.command.commands.GrimDebug;
import ac.grim.grimac.command.commands.GrimDump;
import ac.grim.grimac.command.commands.GrimHelp;
import ac.grim.grimac.command.commands.GrimHistory;
import ac.grim.grimac.command.commands.GrimList;
import ac.grim.grimac.command.commands.GrimLog;
import ac.grim.grimac.command.commands.GrimPerf;
import ac.grim.grimac.command.commands.GrimProfile;
import ac.grim.grimac.command.commands.GrimReload;
import ac.grim.grimac.command.commands.GrimSendAlert;
import ac.grim.grimac.command.commands.GrimSpectate;
import ac.grim.grimac.command.commands.GrimStopSpectating;
import ac.grim.grimac.command.commands.GrimVerbose;
import ac.grim.grimac.command.commands.GrimVersion;
import ac.grim.grimac.command.handler.GrimCommandFailureHandler;
import ac.grim.grimac.manager.init.start.StartableInitable;
import ac.grim.grimac.platform.api.sender.Sender;
import ac.grim.grimac.shaded.geantyref.TypeToken;
import ac.grim.grimac.shaded.incendo.cloud.CommandManager;
import ac.grim.grimac.shaded.incendo.cloud.exception.InvalidSyntaxException;
import ac.grim.grimac.shaded.incendo.cloud.key.CloudKey;
import ac.grim.grimac.shaded.incendo.cloud.processors.requirements.RequirementApplicable;
import ac.grim.grimac.shaded.incendo.cloud.processors.requirements.RequirementPostprocessor;
import ac.grim.grimac.shaded.incendo.cloud.processors.requirements.Requirements;
import ac.grim.grimac.shaded.kyori.adventure.text.ComponentLike;
import ac.grim.grimac.shaded.kyori.adventure.text.format.NamedTextColor;
import ac.grim.grimac.utils.anticheat.MessageUtil;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;

public class CommandRegister
implements StartableInitable {
    public static final CloudKey<Requirements<Sender, SenderRequirement>> REQUIREMENT_KEY = CloudKey.of("requirements", new TypeToken<Requirements<Sender, SenderRequirement>>(){});
    public static final RequirementApplicable.RequirementApplicableFactory<Sender, SenderRequirement> REQUIREMENT_FACTORY = RequirementApplicable.factory(REQUIREMENT_KEY);
    private static boolean commandsRegistered = false;
    private final Supplier<CommandManager<Sender>> commandManagerSupplier;

    public static void registerCommands(CommandManager<Sender> commandManager) {
        if (commandsRegistered) {
            return;
        }
        new GrimPerf().register(commandManager);
        new GrimDebug().register(commandManager);
        new GrimAlerts().register(commandManager);
        new GrimProfile().register(commandManager);
        new GrimSendAlert().register(commandManager);
        new GrimHelp().register(commandManager);
        new GrimHistory().register(commandManager);
        new GrimReload().register(commandManager);
        new GrimSpectate().register(commandManager);
        new GrimStopSpectating().register(commandManager);
        new GrimLog().register(commandManager);
        new GrimVerbose().register(commandManager);
        new GrimVersion().register(commandManager);
        new GrimDump().register(commandManager);
        new GrimBrands().register(commandManager);
        new GrimList().register(commandManager);
        RequirementPostprocessor<Sender, SenderRequirement> senderRequirementPostprocessor = RequirementPostprocessor.of(REQUIREMENT_KEY, new GrimCommandFailureHandler());
        commandManager.registerCommandPostProcessor(senderRequirementPostprocessor);
        CommandRegister.registerExceptionHandler(commandManager, InvalidSyntaxException.class, e -> MessageUtil.miniMessage(e.correctSyntax()));
        commandsRegistered = true;
    }

    protected static <E extends Exception> void registerExceptionHandler(CommandManager<Sender> commandManager, Class<E> ex, Function<E, ComponentLike> toComponent) {
        commandManager.exceptionController().registerHandler(ex, c -> ((Sender)c.context().sender()).sendMessage(((ComponentLike)toComponent.apply((Exception)c.exception())).asComponent().colorIfAbsent(NamedTextColor.RED)));
    }

    @Override
    public void start() {
        CommandManager<Sender> commandManager = this.commandManagerSupplier.get();
        CommandRegister.registerCommands(commandManager);
        if (GrimAPI.INSTANCE.getConfigManager().getConfig().getBooleanElse("check-for-updates", true)) {
            GrimVersion.checkForUpdatesAsync(GrimAPI.INSTANCE.getPlatformServer().getConsoleSender());
        }
    }

    @Generated
    public CommandRegister(Supplier<CommandManager<Sender>> commandManagerSupplier) {
        this.commandManagerSupplier = commandManagerSupplier;
    }
}

