/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.exploit;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientNameItem;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPluginMessage;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.utils.payload.PayloadItemName;

@CheckData(name="ExploitA", description="Too long item name in anvil")
public class ExploitA
extends Check
implements PacketCheck {
    public ExploitA(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        WrapperPlayClientPluginMessage wrapper;
        if (event.getPacketType() == PacketType.Play.Client.NAME_ITEM) {
            this.check(new WrapperPlayClientNameItem(event).getItemName(), event);
        }
        if (event.getPacketType() == PacketType.Play.Client.PLUGIN_MESSAGE && PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_13) && (wrapper = new WrapperPlayClientPluginMessage(event)).getChannelName().equals("MC|ItemName")) {
            this.check(PayloadItemName.CODEC.read(wrapper.getData()).itemName(), event);
        }
    }

    private void check(@NotNull String name, PacketReceiveEvent event) {
        int limit;
        int n = this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_17) ? 50 : (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_12) ? 35 : (limit = this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_11_1) ? 31 : 30));
        if (name.length() > limit && this.flagAndAlert("name=" + name) && this.shouldModifyPackets()) {
            event.setCancelled(true);
            this.player.onPacketCancel();
        }
    }
}

