/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.bukkit.manager;

import ac.grim.grimac.platform.api.manager.ItemResetHandler;
import ac.grim.grimac.platform.api.player.PlatformPlayer;
import ac.grim.grimac.platform.bukkit.player.BukkitPlatformPlayer;
import ac.grim.grimac.platform.bukkit.utils.reflection.PaperUtils;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.InteractionHand;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;

public class BukkitItemResetHandler
implements ItemResetHandler {
    @NotNull
    private final ItemUsageReset resetItemUsage = this.createItemUsageResetFunction();
    @NotNull
    private final ItemUsageHandGetter itemUsageHandGetter = this.createItemUsageHandGetterFunction();

    @Override
    public void resetItemUsage(@Nullable PlatformPlayer player) {
        if (player != null) {
            this.resetItemUsage.accept(((BukkitPlatformPlayer)player).getNative());
        }
    }

    @Override
    @Nullable
    public InteractionHand getItemUsageHand(@Nullable PlatformPlayer platformPlayer) {
        return platformPlayer == null ? null : this.itemUsageHandGetter.apply(((BukkitPlatformPlayer)platformPlayer).getNative());
    }

    @NotNull
    private ItemUsageReset createItemUsageResetFunction() {
        ServerVersion version = PacketEvents.getAPI().getServerManager().getVersion();
        if (version.isNewerThan(ServerVersion.V_1_17) && PaperUtils.PAPER) {
            Class<?> CraftLivingEntity;
            if (version.isOlderThan(ServerVersion.V_1_19)) {
                return LivingEntity::clearActiveItem;
            }
            boolean obfuscated = false;
            try {
                CraftLivingEntity = Class.forName("org.bukkit.craftbukkit.entity.CraftLivingEntity");
            }
            catch (ClassNotFoundException ignored) {
                String nmsPackage = Bukkit.getServer().getClass().getPackageName().split("\\.")[3];
                CraftLivingEntity = Class.forName("org.bukkit.craftbukkit." + nmsPackage + ".entity.CraftLivingEntity");
                obfuscated = true;
            }
            Method getHandle = CraftLivingEntity.getMethod("getHandle", new Class[0]);
            Method setLivingEntityFlag = getHandle.getReturnType().getDeclaredMethod(obfuscated ? "c" : "setLivingEntityFlag", Integer.TYPE, Boolean.TYPE);
            setLivingEntityFlag.setAccessible(true);
            return player -> {
                setLivingEntityFlag.invoke(getHandle.invoke((Object)player, new Object[0]), 1, false);
                player.clearActiveItem();
            };
        }
        if (version == ServerVersion.V_1_8_8) {
            Method getHandle = Class.forName("org.bukkit.craftbukkit.v1_8_R3.entity.CraftHumanEntity").getMethod("getHandle", new Class[0]);
            Method clearActiveItem = getHandle.getReturnType().getMethod("bV", new Class[0]);
            Method isUsingItem = getHandle.getReturnType().getMethod("bS", new Class[0]);
            return player -> {
                Object handle = getHandle.invoke((Object)player, new Object[0]);
                clearActiveItem.invoke(handle, new Object[0]);
                if (((Boolean)isUsingItem.invoke(handle, new Object[0])).booleanValue()) {
                    player.updateInventory();
                }
            };
        }
        String nmsPackage = Bukkit.getServer().getClass().getPackageName().split("\\.")[3];
        Method getHandle = Class.forName("org.bukkit.craftbukkit." + nmsPackage + ".entity.CraftLivingEntity").getMethod("getHandle", new Class[0]);
        Class<?> clazz = getHandle.getReturnType();
        Method clearActiveItem = clazz.getMethod(switch (nmsPackage) {
            case "v1_9_R1" -> "cz";
            case "v1_9_R2" -> "cA";
            case "v1_10_R1" -> "cE";
            case "v1_11_R1" -> "cF";
            case "v1_12_R1" -> "cN";
            case "v1_13_R1", "v1_13_R2" -> "da";
            case "v1_14_R1" -> "dp";
            case "v1_15_R1" -> "dH";
            case "v1_16_R1", "v1_16_R2", "v1_16_R3", "v1_17_R1" -> "clearActiveItem";
            case "v1_18_R1" -> "eR";
            case "v1_18_R2" -> "eS";
            case "v1_19_R1" -> "eZ";
            case "v1_19_R2" -> "ff";
            case "v1_19_R3" -> "fk";
            case "v1_20_R1" -> "fo";
            case "v1_20_R2" -> "fs";
            case "v1_20_R3" -> "ft";
            case "v1_20_R4" -> "fB";
            case "v1_21_R1" -> "fx";
            case "v1_21_R2", "v1_21_R3", "v1_21_R4" -> "fF";
            default -> throw new IllegalStateException("You are using an unsupported server version! (" + version.getReleaseName() + ")");
        }, new Class[0]);
        if (version.isOlderThan(ServerVersion.V_1_19)) {
            return player -> clearActiveItem.invoke(getHandle.invoke((Object)player, new Object[0]), new Object[0]);
        }
        Object setLivingEntityFlag = getHandle.getReturnType().getDeclaredMethod("c", Integer.TYPE, Boolean.TYPE);
        ((Method)setLivingEntityFlag).setAccessible(true);
        return arg_0 -> BukkitItemResetHandler.lambda$createItemUsageResetFunction$3(getHandle, (Method)setLivingEntityFlag, clearActiveItem, arg_0);
    }

    @NotNull
    private ItemUsageHandGetter createItemUsageHandGetterFunction() {
        ServerVersion version = PacketEvents.getAPI().getServerManager().getVersion();
        if (version.isNewerThanOrEquals(ServerVersion.V_1_16_5) && PaperUtils.PAPER) {
            return player -> player.isHandRaised() ? (player.getHandRaised() == EquipmentSlot.OFF_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND) : null;
        }
        if (version == ServerVersion.V_1_8_8) {
            Method getHandle = Class.forName("org.bukkit.craftbukkit.v1_8_R3.entity.CraftHumanEntity").getMethod("getHandle", new Class[0]);
            Method isUsingItem = getHandle.getReturnType().getMethod("bS", new Class[0]);
            return player -> (Boolean)isUsingItem.invoke(getHandle.invoke((Object)player, new Object[0]), new Object[0]) != false ? InteractionHand.MAIN_HAND : null;
        }
        String nmsPackage = Bukkit.getServer().getClass().getPackageName().split("\\.")[3];
        Method getHandle = Class.forName("org.bukkit.craftbukkit." + nmsPackage + ".entity.CraftLivingEntity").getMethod("getHandle", new Class[0]);
        Class<?> clazz = getHandle.getReturnType();
        Method isUsingItem = clazz.getMethod(switch (nmsPackage) {
            case "v1_9_R1" -> "cs";
            case "v1_9_R2" -> "ct";
            case "v1_10_R1" -> "cx";
            case "v1_11_R1", "v1_12_R1", "v1_13_R1", "v1_13_R2", "v1_14_R1", "v1_15_R1", "v1_16_R1", "v1_16_R2", "v1_16_R3", "v1_17_R1" -> "isHandRaised";
            case "v1_18_R1" -> "eL";
            case "v1_18_R2" -> "eM";
            case "v1_19_R1" -> "eT";
            case "v1_19_R2" -> "eZ";
            case "v1_19_R3" -> "fe";
            case "v1_20_R1" -> "fi";
            case "v1_20_R2" -> "fm";
            case "v1_20_R3" -> "fn";
            case "v1_20_R4" -> "fv";
            case "v1_21_R1" -> "fr";
            case "v1_21_R2", "v1_21_R3", "v1_21_R4" -> "fz";
            default -> throw new IllegalStateException("You are using an unsupported server version! (" + version.getReleaseName() + ")");
        }, new Class[0]);
        Class<?> clazz2 = getHandle.getReturnType();
        Method getUsingItemHand = clazz2.getMethod(switch (nmsPackage) {
            case "v1_9_R1" -> "ct";
            case "v1_9_R2" -> "cu";
            case "v1_10_R1" -> "cy";
            case "v1_11_R1" -> "cz";
            case "v1_12_R1" -> "cH";
            case "v1_13_R1", "v1_13_R2", "v1_14_R1" -> "cU";
            case "v1_15_R1", "v1_16_R1", "v1_16_R2", "v1_16_R3", "v1_17_R1" -> "getRaisedHand";
            case "v1_18_R1" -> "eM";
            case "v1_18_R2" -> "eN";
            case "v1_19_R1" -> "eU";
            case "v1_19_R2" -> "fa";
            case "v1_19_R3" -> "ff";
            case "v1_20_R1" -> "fj";
            case "v1_20_R2" -> "fn";
            case "v1_20_R3" -> "fo";
            case "v1_20_R4" -> "fw";
            case "v1_21_R1" -> "fs";
            case "v1_21_R2", "v1_21_R3", "v1_21_R4" -> "fA";
            default -> throw new IllegalStateException("You are using an unsupported server version! (" + version.getReleaseName() + ")");
        }, new Class[0]);
        return player -> {
            Object handle = getHandle.invoke((Object)player, new Object[0]);
            return ((Boolean)isUsingItem.invoke(handle, new Object[0])).booleanValue() ? (((Enum)getUsingItemHand.invoke(handle, new Object[0])).ordinal() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND) : null;
        };
    }

    private static /* synthetic */ void lambda$createItemUsageResetFunction$3(Method getHandle, Method setLivingEntityFlag, Method clearActiveItem, Player player) throws Throwable {
        Object handle = getHandle.invoke((Object)player, new Object[0]);
        setLivingEntityFlag.invoke(handle, 1, false);
        clearActiveItem.invoke(handle, new Object[0]);
    }

    private static interface ItemUsageReset {
        public void accept(@NotNull Player var1) throws Throwable;
    }

    private static interface ItemUsageHandGetter {
        public InteractionHand apply(@NotNull Player var1) throws Throwable;
    }
}

