/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.predictionengine.predictions.rideable;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.predictionengine.predictions.PredictionEngine;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.utils.collisions.CollisionData;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.VectorData;
import ac.grim.grimac.utils.enums.BoatEntityStatus;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.math.Vector3dm;
import ac.grim.grimac.utils.nmsutil.BlockProperties;
import ac.grim.grimac.utils.nmsutil.Collisions;
import ac.grim.grimac.utils.nmsutil.GetBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class PredictionEngineBoat
extends PredictionEngine {
    public PredictionEngineBoat(GrimPlayer player) {
        player.uncertaintyHandler.collidingEntities.add(0);
        player.vehicleData.midTickY = 0.0;
        player.vehicleData.oldStatus = player.vehicleData.status;
        player.vehicleData.status = PredictionEngineBoat.getStatus(player);
    }

    private static BoatEntityStatus getStatus(GrimPlayer player) {
        BoatEntityStatus status = PredictionEngineBoat.isUnderwater(player);
        if (status != null) {
            player.vehicleData.waterLevel = player.boundingBox.maxY;
            return status;
        }
        if (PredictionEngineBoat.checkInWater(player)) {
            return BoatEntityStatus.IN_WATER;
        }
        float friction = PredictionEngineBoat.getGroundFriction(player);
        if (friction > 0.0f) {
            player.vehicleData.landFriction = friction;
            return BoatEntityStatus.ON_LAND;
        }
        return BoatEntityStatus.IN_AIR;
    }

    @Nullable
    private static BoatEntityStatus isUnderwater(@NotNull GrimPlayer player) {
        SimpleCollisionBox axisalignedbb = player.boundingBox;
        double d0 = axisalignedbb.maxY + 0.001;
        int i = GrimMath.floor(axisalignedbb.minX);
        int j = GrimMath.ceil(axisalignedbb.maxX);
        int k = GrimMath.floor(axisalignedbb.maxY);
        int l = GrimMath.ceil(d0);
        int i1 = GrimMath.floor(axisalignedbb.minZ);
        int j1 = GrimMath.ceil(axisalignedbb.maxZ);
        boolean flag = false;
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    double level = player.compensatedWorld.getWaterFluidLevelAt(k1, l1, i2);
                    if (!(d0 < (double)l1 + level)) continue;
                    if (!player.compensatedWorld.isWaterSourceBlock(k1, l1, i2)) {
                        return BoatEntityStatus.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? BoatEntityStatus.UNDER_WATER : null;
    }

    private static boolean checkInWater(GrimPlayer grimPlayer) {
        SimpleCollisionBox axisalignedbb = grimPlayer.boundingBox;
        int i = GrimMath.floor(axisalignedbb.minX);
        int j = GrimMath.ceil(axisalignedbb.maxX);
        int k = GrimMath.floor(axisalignedbb.minY);
        int l = GrimMath.ceil(axisalignedbb.minY + 0.001);
        int i1 = GrimMath.floor(axisalignedbb.minZ);
        int j1 = GrimMath.ceil(axisalignedbb.maxZ);
        boolean flag = false;
        grimPlayer.vehicleData.waterLevel = -1.7976931348623157E308;
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    double level = grimPlayer.compensatedWorld.getWaterFluidLevelAt(k1, l1, i2);
                    if (!(level > 0.0)) continue;
                    float f = (float)((double)l1 + level);
                    grimPlayer.vehicleData.waterLevel = Math.max((double)f, grimPlayer.vehicleData.waterLevel);
                    flag |= axisalignedbb.minY < (double)f;
                }
            }
        }
        return flag;
    }

    public static float getGroundFriction(GrimPlayer player) {
        SimpleCollisionBox axisalignedbb = player.boundingBox;
        SimpleCollisionBox axisalignedbb1 = new SimpleCollisionBox(axisalignedbb.minX, axisalignedbb.minY - 0.001, axisalignedbb.minZ, axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ, false);
        int i = (int)(Math.floor(axisalignedbb1.minX) - 1.0);
        int j = (int)(Math.ceil(axisalignedbb1.maxX) + 1.0);
        int k = (int)(Math.floor(axisalignedbb1.minY) - 1.0);
        int l = (int)(Math.ceil(axisalignedbb1.maxY) + 1.0);
        int i1 = (int)(Math.floor(axisalignedbb1.minZ) - 1.0);
        int j1 = (int)(Math.ceil(axisalignedbb1.maxZ) + 1.0);
        float f = 0.0f;
        int k1 = 0;
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    WrappedBlockState blockData;
                    StateType blockMaterial;
                    if (j2 > 0 && (k2 == k || k2 == l - 1) || (blockMaterial = (blockData = player.compensatedWorld.getBlock(l1, k2, i2)).getType()) == StateTypes.LILY_PAD || !CollisionData.getData(blockMaterial).getMovementCollisionBox(player, player.getClientVersion(), blockData, l1, k2, i2).isIntersected(axisalignedbb1)) continue;
                    f += BlockProperties.getMaterialFriction(player, blockMaterial);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    @Override
    public List<VectorData> applyInputsToVelocityPossibilities(GrimPlayer player, Set<VectorData> possibleVectors, float speed) {
        ArrayList<VectorData> vectors = new ArrayList<VectorData>();
        for (VectorData data : possibleVectors) {
            data.input = new Vector3dm(player.vehicleData.vehicleForward, 0.0f, player.vehicleData.vehicleHorizontal);
            for (int applyStuckSpeed = 1; !(applyStuckSpeed < 0 || applyStuckSpeed == 0 && player.isForceStuckSpeed()); --applyStuckSpeed) {
                if (player.vehicleData.vehicleForward == 0.0f) {
                    Vector3dm vector = data.vector.clone();
                    this.controlBoat(player, vector, true);
                    if (applyStuckSpeed != 0) {
                        vector.multiply(player.stuckSpeedMultiplier);
                    }
                    vectors.add(data.returnNewModified(vector, VectorData.VectorType.InputResult));
                }
                this.controlBoat(player, data.vector, false);
                if (applyStuckSpeed != 0) {
                    data.vector.multiply(player.stuckSpeedMultiplier);
                }
                vectors.add(data);
            }
        }
        return vectors;
    }

    @Override
    public Set<VectorData> fetchPossibleStartTickVectors(GrimPlayer player) {
        Set<VectorData> vectors = player.getPossibleVelocities();
        this.addFluidPushingToStartingVectors(player, vectors);
        for (VectorData data : vectors) {
            this.floatBoat(player, data.vector);
        }
        return vectors;
    }

    @Override
    public void endOfTick(GrimPlayer player, double d) {
        super.endOfTick(player, d);
        Collisions.handleInsideBlocks(player);
    }

    @Override
    public boolean canSwimHop(GrimPlayer player) {
        return false;
    }

    private void floatBoat(GrimPlayer player, Vector3dm vector) {
        double d1 = player.hasGravity ? (double)-0.04f : 0.0;
        double d2 = 0.0;
        float invFriction = 0.05f;
        if (player.vehicleData.oldStatus == BoatEntityStatus.IN_AIR && player.vehicleData.status != BoatEntityStatus.IN_AIR && player.vehicleData.status != BoatEntityStatus.ON_LAND) {
            player.vehicleData.waterLevel = player.lastY + player.boundingBox.maxY - player.boundingBox.minY;
            player.lastY = (double)(this.getWaterLevelAbove(player) - 0.5625f) + 0.101;
            player.boundingBox = GetBoundingBox.getCollisionBoxForPlayer(player, player.lastX, player.lastY, player.lastZ);
            player.actualMovement = new Vector3dm(player.x - player.lastX, player.y - player.lastY, player.z - player.lastZ);
            vector.setY(0);
            player.vehicleData.lastYd = 0.0;
            player.vehicleData.status = BoatEntityStatus.IN_WATER;
        } else {
            if (player.vehicleData.status == BoatEntityStatus.IN_WATER) {
                d2 = (player.vehicleData.waterLevel - player.lastY) / (player.boundingBox.maxY - player.boundingBox.minY);
                invFriction = 0.9f;
            } else if (player.vehicleData.status == BoatEntityStatus.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                invFriction = 0.9f;
            } else if (player.vehicleData.status == BoatEntityStatus.UNDER_WATER) {
                d2 = 0.01f;
                invFriction = 0.45f;
            } else if (player.vehicleData.status == BoatEntityStatus.IN_AIR) {
                invFriction = 0.9f;
            } else if (player.vehicleData.status == BoatEntityStatus.ON_LAND) {
                invFriction = player.vehicleData.landFriction;
                player.vehicleData.landFriction /= 2.0f;
            }
            vector.setX(vector.getX() * (double)invFriction);
            vector.setY(vector.getY() + d1);
            vector.setZ(vector.getZ() * (double)invFriction);
            if (d2 > 0.0) {
                double yVel = vector.getY();
                vector.setY((yVel + d2 * 0.06153846016296973) * 0.75);
            }
        }
    }

    public float getWaterLevelAbove(GrimPlayer player) {
        SimpleCollisionBox axisalignedbb = player.boundingBox;
        int i = (int)Math.floor(axisalignedbb.minX);
        int j = (int)Math.ceil(axisalignedbb.maxX);
        int k = (int)Math.floor(axisalignedbb.maxY);
        int l = (int)Math.ceil(axisalignedbb.maxY - player.vehicleData.lastYd);
        int i1 = (int)Math.floor(axisalignedbb.minZ);
        int j1 = (int)Math.ceil(axisalignedbb.maxZ);
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    double level = player.compensatedWorld.getWaterFluidLevelAt(l1, k1, i2);
                    if ((f = (float)Math.max((double)f, level)) >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)k1 + f;
        }
        return l + 1;
    }

    private void controlBoat(GrimPlayer player, Vector3dm vector, boolean intermediate) {
        float f = 0.0f;
        if (player.vehicleData.vehicleHorizontal != 0.0f && !intermediate && player.vehicleData.vehicleForward == 0.0f) {
            f += 0.005f;
        }
        if (intermediate || (double)player.vehicleData.vehicleForward > 0.1) {
            f += 0.04f;
        }
        if (intermediate || (double)player.vehicleData.vehicleForward < -0.01) {
            f -= 0.005f;
        }
        vector.add(new Vector3dm((double)(player.trigHandler.sin(-player.xRot * ((float)Math.PI / 180)) * f), 0.0, (double)(player.trigHandler.cos(player.xRot * ((float)Math.PI / 180)) * f)));
    }
}

