/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.math;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.math.Vector3dm;
import lombok.Generated;

public final class VectorUtils {
    public static Vector3dm cutBoxToVector(Vector3dm vectorToCutTo, Vector3dm min, Vector3dm max) {
        SimpleCollisionBox box = new SimpleCollisionBox(min, max).sort();
        return VectorUtils.cutBoxToVector(vectorToCutTo, box);
    }

    public static Vector3dm cutBoxToVector(Vector3dm vectorCutTo, SimpleCollisionBox box) {
        return new Vector3dm(GrimMath.clamp(vectorCutTo.getX(), box.minX, box.maxX), GrimMath.clamp(vectorCutTo.getY(), box.minY, box.maxY), GrimMath.clamp(vectorCutTo.getZ(), box.minZ, box.maxZ));
    }

    public static Vector3dm fromVec3d(Vector3d vector3d) {
        return new Vector3dm(vector3d.getX(), vector3d.getY(), vector3d.getZ());
    }

    public static Vector3d clampVector(Vector3d toClamp) {
        double x = GrimMath.clamp(toClamp.getX(), -3.0E7, 3.0E7);
        double y = GrimMath.clamp(toClamp.getY(), -2.0E7, 2.0E7);
        double z = GrimMath.clamp(toClamp.getZ(), -3.0E7, 3.0E7);
        return new Vector3d(x, y, z);
    }

    @Generated
    private VectorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

