/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.bukkit.initables;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.manager.init.start.AbstractTickEndEvent;
import ac.grim.grimac.platform.api.Platform;
import ac.grim.grimac.platform.bukkit.player.BukkitPlatformPlayer;
import ac.grim.grimac.platform.bukkit.utils.reflection.PaperUtils;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.reflection.Reflection;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import ac.grim.grimac.utils.anticheat.LogUtil;
import ac.grim.grimac.utils.lists.HookedListWrapper;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import sun.misc.Unsafe;

public class BukkitTickEndEvent
extends AbstractTickEndEvent
implements Listener {
    @Override
    public void start() {
        if (!super.shouldInjectEndTick()) {
            return;
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThan(ServerVersion.V_1_11_2) && !Boolean.getBoolean("paper.explicit-flush")) {
            LogUtil.warn("Reach.enable-post-packet=true but paper.explicit-flush=false, add \"-Dpaper.explicit-flush=true\" to your server's startup flags for fully functional extra reach accuracy.");
        }
        if (GrimAPI.INSTANCE.getPlatform() == Platform.FOLIA) {
            PaperUtils.registerTickEndEvent(this, this::tickAllFoliaPlayers);
            return;
        }
        if (!this.injectWithReflection() && !PaperUtils.registerTickEndEvent(this, this::tickAllPlayers)) {
            LogUtil.error("Failed to inject into the end of tick event!");
        }
    }

    private void tickAllPlayers() {
        for (GrimPlayer player : GrimAPI.INSTANCE.getPlayerDataManager().getEntries()) {
            if (player.disableGrim) continue;
            super.onEndOfTick(player);
        }
    }

    private void tickAllFoliaPlayers() {
        for (GrimPlayer player : GrimAPI.INSTANCE.getPlayerDataManager().getEntries()) {
            Player p;
            if (player.disableGrim || player.platformPlayer == null || !Bukkit.isOwnedByCurrentRegion((Entity)(p = ((BukkitPlatformPlayer)player.platformPlayer).getNative()))) continue;
            super.onEndOfTick(player);
        }
    }

    private boolean injectWithReflection() {
        try {
            Object connection = SpigotReflectionUtil.getMinecraftServerConnectionInstance();
            Field connectionsList = Reflection.getField(connection.getClass(), List.class, 1);
            List endOfTickObject = (List)connectionsList.get(connection);
            List<Object> wrapper = Collections.synchronizedList(new HookedListWrapper<Object>(endOfTickObject){

                @Override
                public void onIterator() {
                    BukkitTickEndEvent.this.tickAllPlayers();
                }
            });
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Unsafe unsafe = (Unsafe)unsafeField.get(null);
            unsafe.putObject(connection, unsafe.objectFieldOffset(connectionsList), wrapper);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LogUtil.error("Failed to inject into the end of tick event via reflection", e);
            return false;
        }
        return true;
    }
}

