/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.manager.config;

import ac.grim.grimac.api.config.ConfigManager;
import ac.grim.grimac.utils.anticheat.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class BaseConfigManager {
    private final List<Pattern> ignoredClientPatterns = new ArrayList<Pattern>();
    private ConfigManager config = null;
    private boolean printAlertsToConsole = false;
    private String prefix = "&bGrim &8\u00bb";
    private String disconnectTimeout;
    private String disconnectClosed;
    private String disconnectPacketError;
    private String disconnectBlacklistedForge;
    private boolean blockBlacklistedForgeClients;
    private boolean disablePongCancelling;

    public void load(ConfigManager config) {
        this.config = config;
        int configuredMaxTransactionTime = config.getIntElse("max-transaction-time", 60);
        if (configuredMaxTransactionTime > 180 || configuredMaxTransactionTime < 1) {
            LogUtil.warn("Detected invalid max-transaction-time! This setting is clamped between 1 and 180 to prevent issues. Attempting to disable or set this too high can result in memory usage issues.");
        }
        this.ignoredClientPatterns.clear();
        for (String string : config.getStringList("client-brand.ignored-clients")) {
            try {
                this.ignoredClientPatterns.add(Pattern.compile(string));
            }
            catch (PatternSyntaxException e) {
                throw new RuntimeException("Failed to compile client pattern", e);
            }
        }
        this.printAlertsToConsole = config.getBooleanElse("alerts.print-to-console", true);
        this.prefix = config.getStringElse("prefix", "&bGrim &8\u00bb");
        this.disconnectTimeout = config.getStringElse("disconnect.timeout", "<lang:disconnect.timeout>");
        this.disconnectClosed = config.getStringElse("disconnect.closed", "<lang:disconnect.timeout>");
        this.disconnectPacketError = config.getStringElse("disconnect.error", "<red>An error occurred whilst processing packets. Please contact the administrators.");
        this.blockBlacklistedForgeClients = config.getBooleanElse("client-brand.disconnect-blacklisted-forge-versions", true);
        this.disconnectBlacklistedForge = config.getStringElse("disconnect.blacklisted-forge", "<red>Your forge version is blacklisted due to inbuilt reach hacks.<newline><gold>Versions affected: 1.18.2-1.19.3<newline><newline><red>Please see https://github.com/MinecraftForge/MinecraftForge/issues/9309.");
        this.disablePongCancelling = config.getBooleanElse("disable-pong-cancelling", false);
    }

    public void start() {
    }

    public boolean isIgnoredClient(String brand) {
        for (Pattern pattern : this.ignoredClientPatterns) {
            if (!pattern.matcher(brand).find()) continue;
            return true;
        }
        return false;
    }

    public ConfigManager getConfig() {
        return this.config;
    }

    public boolean isPrintAlertsToConsole() {
        return this.printAlertsToConsole;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getDisconnectTimeout() {
        return this.disconnectTimeout;
    }

    public String getDisconnectClosed() {
        return this.disconnectClosed;
    }

    public String getDisconnectPacketError() {
        return this.disconnectPacketError;
    }

    public String getDisconnectBlacklistedForge() {
        return this.disconnectBlacklistedForge;
    }

    public boolean isBlockBlacklistedForgeClients() {
        return this.blockBlacklistedForgeClients;
    }

    public boolean isDisablePongCancelling() {
        return this.disablePongCancelling;
    }
}

