/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.bukkit.world;

import ac.grim.grimac.platform.api.world.PlatformChunk;
import ac.grim.grimac.platform.api.world.PlatformWorld;
import ac.grim.grimac.platform.bukkit.world.BukkitPlatformChunk;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

public class BukkitPlatformWorld
implements PlatformWorld {
    private static final boolean LEGACY_SERVER_VERSION = PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_12_2);
    private final World bukkitWorld;

    public BukkitPlatformWorld(@NotNull World world) {
        this.bukkitWorld = world;
    }

    @Override
    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        return this.bukkitWorld.isChunkLoaded(chunkX, chunkZ);
    }

    @Override
    public WrappedBlockState getBlockAt(int x, int y, int z) {
        if (LEGACY_SERVER_VERSION) {
            Block block = this.bukkitWorld.getBlockAt(x, y, z);
            int blockId = block.getType().getId() << 4 | block.getData();
            return WrappedBlockState.getByGlobalId((int)blockId);
        }
        return SpigotConversionUtil.fromBukkitBlockData((BlockData)this.bukkitWorld.getBlockAt(x, y, z).getBlockData());
    }

    @Override
    public String getName() {
        return this.bukkitWorld.getName();
    }

    @Override
    @Nullable
    public UUID getUID() {
        return this.bukkitWorld.getUID();
    }

    @Override
    public PlatformChunk getChunkAt(int currChunkX, int currChunkZ) {
        return new BukkitPlatformChunk(this.bukkitWorld.getChunkAt(currChunkX, currChunkZ));
    }

    @Override
    public boolean isLoaded() {
        return Bukkit.getWorld((UUID)this.bukkitWorld.getUID()) != null;
    }

    public World getBukkitWorld() {
        return this.bukkitWorld;
    }
}

