/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.nmsutil;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.data.packetentity.PacketEntityGuardian;
import ac.grim.grimac.utils.data.packetentity.PacketEntityHorse;
import ac.grim.grimac.utils.data.packetentity.PacketEntitySizeable;
import ac.grim.grimac.utils.data.packetentity.PacketEntityTrackXRot;
import ac.grim.grimac.utils.math.GrimMath;
import com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.util.Vector3d;

public final class BoundingBoxSize {
    public static float getWidth(GrimPlayer player, PacketEntity packetEntity) {
        if (packetEntity.type == EntityTypes.TURTLE && packetEntity.isBaby) {
            return 0.36f;
        }
        return BoundingBoxSize.getWidthMinusBaby(player, packetEntity) * (packetEntity.isBaby ? 0.5f : 1.0f);
    }

    private static float getWidthMinusBaby(GrimPlayer player, PacketEntity packetEntity) {
        EntityType type = packetEntity.type;
        if (EntityTypes.AXOLOTL.equals((Object)type)) {
            return 0.75f;
        }
        if (EntityTypes.PANDA.equals((Object)type)) {
            return 1.3f;
        }
        if (EntityTypes.BAT.equals((Object)type) || EntityTypes.PARROT.equals((Object)type) || EntityTypes.COD.equals((Object)type) || EntityTypes.EVOKER_FANGS.equals((Object)type) || EntityTypes.TROPICAL_FISH.equals((Object)type) || EntityTypes.FROG.equals((Object)type)) {
            return 0.5f;
        }
        if (EntityTypes.ARMADILLO.equals((Object)type) || EntityTypes.BEE.equals((Object)type) || EntityTypes.PUFFERFISH.equals((Object)type) || EntityTypes.SALMON.equals((Object)type) || EntityTypes.SNOW_GOLEM.equals((Object)type) || EntityTypes.CAVE_SPIDER.equals((Object)type)) {
            return 0.7f;
        }
        if (EntityTypes.WITHER_SKELETON.equals((Object)type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 0.7f : 0.72f;
        }
        if (EntityTypes.WITHER_SKULL.equals((Object)type) || EntityTypes.SHULKER_BULLET.equals((Object)type)) {
            return 0.3125f;
        }
        if (EntityTypes.HOGLIN.equals((Object)type) || EntityTypes.ZOGLIN.equals((Object)type)) {
            return 1.3964844f;
        }
        if (EntityTypes.SKELETON_HORSE.equals((Object)type) || EntityTypes.ZOMBIE_HORSE.equals((Object)type) || EntityTypes.HORSE.equals((Object)type) || EntityTypes.DONKEY.equals((Object)type) || EntityTypes.MULE.equals((Object)type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 1.3964844f : 1.4f;
        }
        if (EntityTypes.isTypeInstanceOf((EntityType)type, (EntityType)EntityTypes.BOAT)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 1.375f : 1.5f;
        }
        if (EntityTypes.HAPPY_GHAST.equals((Object)type)) {
            return 4.0f;
        }
        if (EntityTypes.CHICKEN.equals((Object)type) || EntityTypes.ENDERMITE.equals((Object)type) || EntityTypes.SILVERFISH.equals((Object)type) || EntityTypes.VEX.equals((Object)type) || EntityTypes.TADPOLE.equals((Object)type)) {
            return 0.4f;
        }
        if (EntityTypes.RABBIT.equals((Object)type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 0.4f : 0.6f;
        }
        if (EntityTypes.CREAKING.equals((Object)type) || EntityTypes.STRIDER.equals((Object)type) || EntityTypes.COW.equals((Object)type) || EntityTypes.SHEEP.equals((Object)type) || EntityTypes.MOOSHROOM.equals((Object)type) || EntityTypes.PIG.equals((Object)type) || EntityTypes.LLAMA.equals((Object)type) || EntityTypes.DOLPHIN.equals((Object)type) || EntityTypes.WITHER.equals((Object)type) || EntityTypes.TRADER_LLAMA.equals((Object)type) || EntityTypes.WARDEN.equals((Object)type) || EntityTypes.GOAT.equals((Object)type)) {
            return 0.9f;
        }
        if (EntityTypes.PHANTOM.equals((Object)type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                PacketEntitySizeable sizeable = (PacketEntitySizeable)packetEntity;
                return 0.9f + (float)sizeable.size * 0.2f;
            }
            return 1.5f;
        }
        if (packetEntity instanceof PacketEntityGuardian) {
            PacketEntityGuardian packetEntityGuardian = (PacketEntityGuardian)packetEntity;
            return packetEntityGuardian.isElder ? 1.9975f : 0.85f;
        }
        if (EntityTypes.END_CRYSTAL.equals((Object)type)) {
            return 2.0f;
        }
        if (EntityTypes.ENDER_DRAGON.equals((Object)type)) {
            return 16.0f;
        }
        if (EntityTypes.FIREBALL.equals((Object)type)) {
            return 1.0f;
        }
        if (EntityTypes.GHAST.equals((Object)type)) {
            return 4.0f;
        }
        if (EntityTypes.GIANT.equals((Object)type)) {
            return 3.6f;
        }
        if (EntityTypes.GUARDIAN.equals((Object)type)) {
            return 0.85f;
        }
        if (EntityTypes.IRON_GOLEM.equals((Object)type)) {
            return 1.4f;
        }
        if (EntityTypes.MAGMA_CUBE.equals((Object)type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                PacketEntitySizeable sizeable = (PacketEntitySizeable)packetEntity;
                float size = sizeable.size;
                return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_20_5) ? 0.52f * size : (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 2.04f * (0.255f * size) : 0.51000005f * size);
            }
            return 0.98f;
        }
        if (EntityTypes.isTypeInstanceOf((EntityType)type, (EntityType)EntityTypes.MINECART_ABSTRACT)) {
            return 0.98f;
        }
        if (EntityTypes.PLAYER.equals((Object)type)) {
            return 0.6f;
        }
        if (EntityTypes.POLAR_BEAR.equals((Object)type)) {
            return 1.4f;
        }
        if (EntityTypes.RAVAGER.equals((Object)type)) {
            return 1.95f;
        }
        if (EntityTypes.SHULKER.equals((Object)type)) {
            return 1.0f;
        }
        if (EntityTypes.SLIME.equals((Object)type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                PacketEntitySizeable sizeable = (PacketEntitySizeable)packetEntity;
                float size = sizeable.size;
                return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_20_5) ? 0.52f * size : (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 2.04f * (0.255f * size) : 0.51000005f * size);
            }
            return 0.3125f;
        }
        if (EntityTypes.SMALL_FIREBALL.equals((Object)type)) {
            return 0.3125f;
        }
        if (EntityTypes.SPIDER.equals((Object)type)) {
            return 1.4f;
        }
        if (EntityTypes.SQUID.equals((Object)type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 0.8f : 0.95f;
        }
        if (EntityTypes.TURTLE.equals((Object)type)) {
            return 1.2f;
        }
        if (EntityTypes.ALLAY.equals((Object)type)) {
            return 0.35f;
        }
        if (EntityTypes.SNIFFER.equals((Object)type)) {
            return 1.9f;
        }
        if (EntityTypes.CAMEL.equals((Object)type)) {
            return 1.7f;
        }
        if (EntityTypes.WIND_CHARGE.equals((Object)type)) {
            return 0.3125f;
        }
        if (EntityTypes.ARMOR_STAND.equals((Object)type)) {
            return 0.5f;
        }
        if (EntityTypes.FALLING_BLOCK.equals((Object)type)) {
            return 0.98f;
        }
        if (EntityTypes.FIREWORK_ROCKET.equals((Object)type)) {
            return 0.25f;
        }
        return 0.6f;
    }

    public static Vector3d getRidingOffsetFromVehicle(PacketEntity entity, GrimPlayer player) {
        SimpleCollisionBox box = entity.getPossibleCollisionBoxes();
        double x = (box.maxX + box.minX) / 2.0;
        double y = box.minY;
        double z = (box.maxZ + box.minZ) / 2.0;
        if (entity instanceof PacketEntityTrackXRot) {
            PacketEntityTrackXRot xRotEntity = (PacketEntityTrackXRot)entity;
            if (EntityTypes.isTypeInstanceOf((EntityType)entity.type, (EntityType)EntityTypes.BOAT)) {
                float f = 0.0f;
                float f1 = (float)(BoundingBoxSize.getPassengerRidingOffset(player, entity) - (double)0.35f);
                if (!entity.passengers.isEmpty()) {
                    int i = entity.passengers.indexOf(player.compensatedEntities.self);
                    if (i == 0) {
                        f = 0.2f;
                    } else if (i == 1) {
                        f = -0.6f;
                    }
                }
                Vector3d vec3 = new Vector3d((double)f, 0.0, 0.0);
                vec3 = BoundingBoxSize.yRot(GrimMath.radians(-xRotEntity.interpYaw) - 1.5707964f, vec3);
                return new Vector3d(x + vec3.x, y + (double)f1, z + vec3.z);
            }
            if (entity.type == EntityTypes.LLAMA) {
                float f = player.trigHandler.cos(GrimMath.radians(xRotEntity.interpYaw));
                float f1 = player.trigHandler.sin(GrimMath.radians(xRotEntity.interpYaw));
                return new Vector3d(x + (double)(0.3f * f1), y + BoundingBoxSize.getPassengerRidingOffset(player, entity) - (double)0.35f, z + (double)(0.3f * f));
            }
            if (entity.type == EntityTypes.CHICKEN) {
                float f = player.trigHandler.sin(GrimMath.radians(xRotEntity.interpYaw));
                float f1 = player.trigHandler.cos(GrimMath.radians(xRotEntity.interpYaw));
                return new Vector3d(x + (double)(0.1f * f), (y += (double)(BoundingBoxSize.getHeight(player, entity) * 0.5f)) - (double)0.35f, z - (double)(0.1f * f1));
            }
        }
        return new Vector3d(x, y + BoundingBoxSize.getPassengerRidingOffset(player, entity) - (double)0.35f, z);
    }

    private static Vector3d yRot(float yaw, Vector3d start) {
        double cos = (float)Math.cos(yaw);
        double sin = (float)Math.sin(yaw);
        return new Vector3d(start.x * cos + start.z * sin, start.y, start.z * cos - start.x * sin);
    }

    public static float getHeight(GrimPlayer player, PacketEntity packetEntity) {
        if (packetEntity.type == EntityTypes.TURTLE && packetEntity.isBaby) {
            return 0.12f;
        }
        return BoundingBoxSize.getHeightMinusBaby(player, packetEntity) * (packetEntity.isBaby ? 0.5f : 1.0f);
    }

    public static double getMyRidingOffset(PacketEntity packetEntity) {
        EntityType type = packetEntity.type;
        if (EntityTypes.PIGLIN.equals((Object)type) || EntityTypes.ZOMBIFIED_PIGLIN.equals((Object)type) || EntityTypes.ZOMBIE.equals((Object)type)) {
            return packetEntity.isBaby ? -0.05 : -0.45;
        }
        if (EntityTypes.SKELETON.equals((Object)type)) {
            return -0.6;
        }
        if (EntityTypes.ENDERMITE.equals((Object)type) || EntityTypes.SILVERFISH.equals((Object)type)) {
            return 0.1;
        }
        if (EntityTypes.EVOKER.equals((Object)type) || EntityTypes.ILLUSIONER.equals((Object)type) || EntityTypes.PILLAGER.equals((Object)type) || EntityTypes.RAVAGER.equals((Object)type) || EntityTypes.VINDICATOR.equals((Object)type) || EntityTypes.WITCH.equals((Object)type)) {
            return -0.45;
        }
        if (EntityTypes.PLAYER.equals((Object)type)) {
            return -0.35;
        }
        if (EntityTypes.isTypeInstanceOf((EntityType)type, (EntityType)EntityTypes.ABSTRACT_ANIMAL)) {
            return 0.14;
        }
        return 0.0;
    }

    public static double getPassengerRidingOffset(GrimPlayer player, PacketEntity packetEntity) {
        if (packetEntity instanceof PacketEntityHorse) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.75 - 0.25;
        }
        EntityType type = packetEntity.type;
        if (EntityTypes.isTypeInstanceOf((EntityType)type, (EntityType)EntityTypes.MINECART_ABSTRACT)) {
            return 0.0;
        }
        if (EntityTypes.isTypeInstanceOf((EntityType)type, (EntityType)EntityTypes.BOAT)) {
            return -0.1;
        }
        if (EntityTypes.HAPPY_GHAST.equals((Object)type)) {
            return 0.5;
        }
        if (EntityTypes.HOGLIN.equals((Object)type) || EntityTypes.ZOGLIN.equals((Object)type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) - (packetEntity.isBaby ? 0.2 : 0.15);
        }
        if (EntityTypes.LLAMA.equals((Object)type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.67;
        }
        if (EntityTypes.PIGLIN.equals((Object)type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.92;
        }
        if (EntityTypes.RAVAGER.equals((Object)type)) {
            return 2.1;
        }
        if (EntityTypes.SKELETON.equals((Object)type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.75 - 0.1875;
        }
        if (EntityTypes.SPIDER.equals((Object)type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.5;
        }
        if (EntityTypes.STRIDER.equals((Object)type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) - 0.19;
        }
        return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.75;
    }

    private static float getHeightMinusBaby(GrimPlayer player, PacketEntity packetEntity) {
        EntityType type = packetEntity.type;
        if (EntityTypes.ARMADILLO.equals((Object)type)) {
            return 0.65f;
        }
        if (EntityTypes.AXOLOTL.equals((Object)type)) {
            return 0.42f;
        }
        if (EntityTypes.BEE.equals((Object)type) || EntityTypes.DOLPHIN.equals((Object)type) || EntityTypes.ALLAY.equals((Object)type)) {
            return 0.6f;
        }
        if (EntityTypes.EVOKER_FANGS.equals((Object)type) || EntityTypes.VEX.equals((Object)type)) {
            return 0.8f;
        }
        if (EntityTypes.SQUID.equals((Object)type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 0.8f : 0.95f;
        }
        if (EntityTypes.PARROT.equals((Object)type) || EntityTypes.BAT.equals((Object)type) || EntityTypes.PIG.equals((Object)type) || EntityTypes.SPIDER.equals((Object)type)) {
            return 0.9f;
        }
        if (EntityTypes.WITHER_SKULL.equals((Object)type) || EntityTypes.SHULKER_BULLET.equals((Object)type)) {
            return 0.3125f;
        }
        if (EntityTypes.BLAZE.equals((Object)type)) {
            return 1.8f;
        }
        if (EntityTypes.isTypeInstanceOf((EntityType)type, (EntityType)EntityTypes.BOAT)) {
            return 0.5625f;
        }
        if (EntityTypes.HAPPY_GHAST.equals((Object)type)) {
            return 4.0f;
        }
        if (EntityTypes.CAT.equals((Object)type)) {
            return 0.7f;
        }
        if (EntityTypes.CAVE_SPIDER.equals((Object)type)) {
            return 0.5f;
        }
        if (EntityTypes.FROG.equals((Object)type)) {
            return 0.55f;
        }
        if (EntityTypes.CHICKEN.equals((Object)type)) {
            return 0.7f;
        }
        if (EntityTypes.HOGLIN.equals((Object)type) || EntityTypes.ZOGLIN.equals((Object)type)) {
            return 1.4f;
        }
        if (EntityTypes.COW.equals((Object)type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 1.4f : 1.3f;
        }
        if (EntityTypes.STRIDER.equals((Object)type)) {
            return 1.7f;
        }
        if (EntityTypes.CREEPER.equals((Object)type)) {
            return 1.7f;
        }
        if (EntityTypes.DONKEY.equals((Object)type)) {
            return 1.5f;
        }
        if (packetEntity instanceof PacketEntityGuardian) {
            PacketEntityGuardian packetEntityGuardian = (PacketEntityGuardian)packetEntity;
            return packetEntityGuardian.isElder ? 1.9975f : 0.85f;
        }
        if (EntityTypes.ENDERMAN.equals((Object)type) || EntityTypes.WARDEN.equals((Object)type)) {
            return 2.9f;
        }
        if (EntityTypes.ENDERMITE.equals((Object)type) || EntityTypes.COD.equals((Object)type)) {
            return 0.3f;
        }
        if (EntityTypes.END_CRYSTAL.equals((Object)type)) {
            return 2.0f;
        }
        if (EntityTypes.ENDER_DRAGON.equals((Object)type)) {
            return 8.0f;
        }
        if (EntityTypes.FIREBALL.equals((Object)type)) {
            return 1.0f;
        }
        if (EntityTypes.FOX.equals((Object)type)) {
            return 0.7f;
        }
        if (EntityTypes.GHAST.equals((Object)type)) {
            return 4.0f;
        }
        if (EntityTypes.GIANT.equals((Object)type)) {
            return 12.0f;
        }
        if (EntityTypes.GUARDIAN.equals((Object)type)) {
            return 0.85f;
        }
        if (EntityTypes.HORSE.equals((Object)type)) {
            return 1.6f;
        }
        if (EntityTypes.IRON_GOLEM.equals((Object)type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 2.7f : 2.9f;
        }
        if (EntityTypes.CREAKING.equals((Object)type)) {
            return 2.7f;
        }
        if (EntityTypes.LLAMA.equals((Object)type) || EntityTypes.TRADER_LLAMA.equals((Object)type)) {
            return 1.87f;
        }
        if (EntityTypes.TROPICAL_FISH.equals((Object)type)) {
            return 0.4f;
        }
        if (EntityTypes.MAGMA_CUBE.equals((Object)type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                PacketEntitySizeable sizeable = (PacketEntitySizeable)packetEntity;
                float size = sizeable.size;
                return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_20_5) ? 0.52f * size : (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 2.04f * (0.255f * size) : 0.51000005f * size);
            }
            return 0.7f;
        }
        if (EntityTypes.isTypeInstanceOf((EntityType)type, (EntityType)EntityTypes.MINECART_ABSTRACT)) {
            return 0.7f;
        }
        if (EntityTypes.MULE.equals((Object)type)) {
            return 1.6f;
        }
        if (EntityTypes.MOOSHROOM.equals((Object)type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 1.4f : 1.3f;
        }
        if (EntityTypes.OCELOT.equals((Object)type)) {
            return 0.7f;
        }
        if (EntityTypes.PANDA.equals((Object)type)) {
            return 1.25f;
        }
        if (EntityTypes.PHANTOM.equals((Object)type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                PacketEntitySizeable sizeable = (PacketEntitySizeable)packetEntity;
                return 0.5f + (float)sizeable.size * 0.1f;
            }
            return 1.8f;
        }
        if (EntityTypes.PLAYER.equals((Object)type)) {
            return 1.8f;
        }
        if (EntityTypes.POLAR_BEAR.equals((Object)type)) {
            return 1.4f;
        }
        if (EntityTypes.PUFFERFISH.equals((Object)type)) {
            return 0.7f;
        }
        if (EntityTypes.RABBIT.equals((Object)type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 0.5f : 0.7f;
        }
        if (EntityTypes.RAVAGER.equals((Object)type)) {
            return 2.2f;
        }
        if (EntityTypes.SALMON.equals((Object)type)) {
            return 0.4f;
        }
        if (EntityTypes.SHEEP.equals((Object)type) || EntityTypes.GOAT.equals((Object)type)) {
            return 1.3f;
        }
        if (EntityTypes.SHULKER.equals((Object)type)) {
            return 2.0f;
        }
        if (EntityTypes.SILVERFISH.equals((Object)type)) {
            return 0.3f;
        }
        if (EntityTypes.SKELETON.equals((Object)type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 1.99f : 1.95f;
        }
        if (EntityTypes.SKELETON_HORSE.equals((Object)type)) {
            return 1.6f;
        }
        if (EntityTypes.SLIME.equals((Object)type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                PacketEntitySizeable sizeable = (PacketEntitySizeable)packetEntity;
                float size = sizeable.size;
                return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_20_5) ? 0.52f * size : (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 2.04f * (0.255f * size) : 0.51000005f * size);
            }
            return 0.3125f;
        }
        if (EntityTypes.SMALL_FIREBALL.equals((Object)type)) {
            return 0.3125f;
        }
        if (EntityTypes.SNOW_GOLEM.equals((Object)type)) {
            return 1.9f;
        }
        if (EntityTypes.STRAY.equals((Object)type)) {
            return 1.99f;
        }
        if (EntityTypes.TURTLE.equals((Object)type)) {
            return 0.4f;
        }
        if (EntityTypes.WITHER.equals((Object)type)) {
            return 3.5f;
        }
        if (EntityTypes.WITHER_SKELETON.equals((Object)type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 2.4f : 2.535f;
        }
        if (EntityTypes.WOLF.equals((Object)type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 0.85f : 0.8f;
        }
        if (EntityTypes.ZOMBIE_HORSE.equals((Object)type)) {
            return 1.6f;
        }
        if (EntityTypes.TADPOLE.equals((Object)type)) {
            return 0.3f;
        }
        if (EntityTypes.SNIFFER.equals((Object)type)) {
            return 1.75f;
        }
        if (EntityTypes.CAMEL.equals((Object)type)) {
            return 2.375f;
        }
        if (EntityTypes.BREEZE.equals((Object)type)) {
            return 1.77f;
        }
        if (EntityTypes.BOGGED.equals((Object)type)) {
            return 1.99f;
        }
        if (EntityTypes.WIND_CHARGE.equals((Object)type)) {
            return 0.3125f;
        }
        if (EntityTypes.ARMOR_STAND.equals((Object)type)) {
            return 1.975f;
        }
        if (EntityTypes.FALLING_BLOCK.equals((Object)type)) {
            return 0.98f;
        }
        if (EntityTypes.VILLAGER.equals((Object)type) && player.getClientVersion().isOlderThan(ClientVersion.V_1_9)) {
            return 1.8f;
        }
        if (EntityTypes.FIREWORK_ROCKET.equals((Object)type)) {
            return 0.25f;
        }
        return 1.95f;
    }

    private BoundingBoxSize() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

