/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.nmsutil;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.math.Vector3dm;
import com.github.retrooper.packetevents.protocol.item.ItemStack;
import com.github.retrooper.packetevents.protocol.item.enchantment.type.EnchantmentTypes;
import com.github.retrooper.packetevents.protocol.item.type.ItemTypes;

public final class Riptide {
    public static Vector3dm getRiptideVelocity(GrimPlayer player) {
        int j;
        ItemStack main = player.getInventory().getHeldItem();
        ItemStack off = player.getInventory().getOffHand();
        if (main.getType() == ItemTypes.TRIDENT) {
            j = main.getEnchantmentLevel(EnchantmentTypes.RIPTIDE);
        } else if (off.getType() == ItemTypes.TRIDENT) {
            j = off.getEnchantmentLevel(EnchantmentTypes.RIPTIDE);
        } else {
            return new Vector3dm();
        }
        float f7 = player.xRot;
        float f = player.yRot;
        float f1 = -player.trigHandler.sin(GrimMath.radians(f7)) * player.trigHandler.cos(GrimMath.radians(f));
        float f2 = -player.trigHandler.sin(GrimMath.radians(f));
        float f3 = player.trigHandler.cos(GrimMath.radians(f7)) * player.trigHandler.cos(GrimMath.radians(f));
        float f4 = (float)Math.sqrt(f1 * f1 + f2 * f2 + f3 * f3);
        float f5 = 3.0f * ((1.0f + (float)j) / 4.0f);
        f1 *= f5 / f4;
        f2 *= f5 / f4;
        f3 *= f5 / f4;
        if (player.verticalCollision) {
            return new Vector3dm(f1, 0.0f, f3);
        }
        return new Vector3dm(f1, f2, f3);
    }

    private Riptide() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

