/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.api.GrimAbstractAPI;
import ac.grim.grimac.api.GrimUser;
import ac.grim.grimac.api.alerts.AlertManager;
import ac.grim.grimac.api.config.ConfigManager;
import ac.grim.grimac.api.events.GrimReloadEvent;
import ac.grim.grimac.manager.config.ConfigManagerFileImpl;
import ac.grim.grimac.manager.init.Initable;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.utils.anticheat.LogUtil;
import ac.grim.grimac.utils.common.ConfigReloadObserver;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.ServicePriority;

public class GrimExternalAPI
implements GrimAbstractAPI,
ConfigReloadObserver,
Initable {
    private final GrimAPI api;
    private final Map<String, Function<GrimUser, String>> variableReplacements = new ConcurrentHashMap<String, Function<GrimUser, String>>();
    private final Map<String, String> staticReplacements = new ConcurrentHashMap<String, String>();
    private final Map<String, Function<Object, Object>> functions = new ConcurrentHashMap<String, Function<Object, Object>>();
    private ConfigManager configManager = null;
    private final ConfigManagerFileImpl configManagerFile = new ConfigManagerFileImpl();
    private boolean started = false;

    public GrimExternalAPI(GrimAPI api) {
        this.api = api;
    }

    @Override
    @Nullable
    public GrimUser getGrimUser(Player player) {
        return this.api.getPlayerDataManager().getPlayer(player);
    }

    @Override
    @Nullable
    public GrimUser getGrimUser(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return null;
        }
        return this.getGrimUser(player);
    }

    public String replaceVariables(GrimUser user, String content) {
        for (Map.Entry<String, String> entry : this.staticReplacements.entrySet()) {
            content = content.replace(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.variableReplacements.entrySet()) {
            content = content.replace(entry.getKey(), (CharSequence)((Function)entry.getValue()).apply(user));
        }
        return content;
    }

    @Override
    public void registerVariable(String string, Function<GrimUser, String> replacement) {
        if (replacement == null) {
            this.variableReplacements.remove(string);
        } else {
            this.variableReplacements.put(string, replacement);
        }
    }

    @Override
    public void registerVariable(String variable, String replacement) {
        if (replacement == null) {
            this.staticReplacements.remove(variable);
        } else {
            this.staticReplacements.put(variable, replacement);
        }
    }

    @Override
    public String getGrimVersion() {
        PluginDescriptionFile description = GrimAPI.INSTANCE.getPlugin().getDescription();
        return description.getVersion();
    }

    @Override
    public void registerFunction(String key, Function<Object, Object> function) {
        if (function == null) {
            this.functions.remove(key);
        } else {
            this.functions.put(key, function);
        }
    }

    @Override
    public Function<Object, Object> getFunction(String key) {
        return this.functions.get(key);
    }

    @Override
    public AlertManager getAlertManager() {
        return GrimAPI.INSTANCE.getAlertManager();
    }

    @Override
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Override
    public boolean hasStarted() {
        return this.started;
    }

    @Override
    public int getCurrentTick() {
        return GrimAPI.INSTANCE.getTickManager().currentTick;
    }

    public void load() {
        this.reload(this.configManagerFile);
        Bukkit.getServicesManager().register(GrimAbstractAPI.class, (Object)this, (Plugin)GrimAPI.INSTANCE.getPlugin(), ServicePriority.Normal);
    }

    @Override
    public void start() {
        this.started = true;
        try {
            GrimAPI.INSTANCE.getConfigManager().start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reload(ConfigManager config) {
        if (config.isLoadedAsync() && this.started) {
            FoliaScheduler.getAsyncScheduler().runNow((Plugin)GrimAPI.INSTANCE.getPlugin(), o -> this.successfulReload(config));
        } else {
            this.successfulReload(config);
        }
    }

    @Override
    public CompletableFuture<Boolean> reloadAsync(ConfigManager config) {
        if (config.isLoadedAsync() && this.started) {
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            FoliaScheduler.getAsyncScheduler().runNow((Plugin)GrimAPI.INSTANCE.getPlugin(), o -> future.complete(this.successfulReload(config)));
            return future;
        }
        return CompletableFuture.completedFuture(this.successfulReload(config));
    }

    private boolean successfulReload(ConfigManager config) {
        try {
            config.reload();
            GrimAPI.INSTANCE.getConfigManager().load(config);
            if (this.started) {
                GrimAPI.INSTANCE.getConfigManager().start();
            }
            this.onReload(config);
            if (this.started) {
                FoliaScheduler.getAsyncScheduler().runNow((Plugin)GrimAPI.INSTANCE.getPlugin(), o -> Bukkit.getPluginManager().callEvent((Event)new GrimReloadEvent(true)));
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.started) {
                FoliaScheduler.getAsyncScheduler().runNow((Plugin)GrimAPI.INSTANCE.getPlugin(), o -> Bukkit.getPluginManager().callEvent((Event)new GrimReloadEvent(false)));
            }
            return false;
        }
    }

    @Override
    public void onReload(ConfigManager newConfig) {
        if (newConfig == null) {
            LogUtil.warn("ConfigManager not set. Using default config file manager.");
            this.configManager = this.configManagerFile;
        } else {
            this.configManager = newConfig;
        }
        this.updateVariables();
        GrimAPI.INSTANCE.getDiscordManager().start();
        GrimAPI.INSTANCE.getSpectateManager().start();
        if (!this.started) {
            return;
        }
        for (GrimPlayer grimPlayer : GrimAPI.INSTANCE.getPlayerDataManager().getEntries()) {
            ChannelHelper.runInEventLoop(grimPlayer.user.getChannel(), () -> {
                grimPlayer.updatePermissions();
                grimPlayer.reload(this.configManager);
            });
        }
    }

    private void updateVariables() {
        this.variableReplacements.putIfAbsent("%player%", GrimUser::getName);
        this.variableReplacements.putIfAbsent("%uuid%", user -> user.getUniqueId().toString());
        this.variableReplacements.putIfAbsent("%ping%", user -> "" + user.getTransactionPing());
        this.variableReplacements.putIfAbsent("%brand%", GrimUser::getBrand);
        this.variableReplacements.putIfAbsent("%h_sensitivity%", user -> "" + (int)Math.round(user.getHorizontalSensitivity() * 200.0));
        this.variableReplacements.putIfAbsent("%v_sensitivity%", user -> "" + (int)Math.round(user.getVerticalSensitivity() * 200.0));
        this.variableReplacements.putIfAbsent("%fast_math%", user -> "" + !user.isVanillaMath());
        this.variableReplacements.putIfAbsent("%tps%", user -> String.format("%.2f", SpigotReflectionUtil.getTPS()));
        this.variableReplacements.putIfAbsent("%version%", GrimUser::getVersionName);
        this.staticReplacements.put("%prefix%", ChatColor.translateAlternateColorCodes((char)'&', (String)GrimAPI.INSTANCE.getConfigManager().getPrefix()));
        this.staticReplacements.putIfAbsent("%grim_version%", this.getGrimVersion());
    }

    public Map<String, Function<GrimUser, String>> getVariableReplacements() {
        return this.variableReplacements;
    }

    public Map<String, String> getStaticReplacements() {
        return this.staticReplacements;
    }
}

