/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.prediction;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.type.PostPredictionCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.utils.anticheat.LogUtil;
import ac.grim.grimac.utils.anticheat.update.PredictionComplete;
import ac.grim.grimac.utils.lists.EvictingQueue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class DebugHandler
extends Check
implements PostPredictionCheck {
    Set<Player> listeners = new CopyOnWriteArraySet<Player>(new HashSet());
    boolean outputToConsole = false;
    boolean enabledFlags = false;
    boolean lastMovementIsFlag = false;
    EvictingQueue<String> predicted = new EvictingQueue(5);
    EvictingQueue<String> actually = new EvictingQueue(5);
    EvictingQueue<String> offset = new EvictingQueue(5);

    public DebugHandler(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPredictionComplete(PredictionComplete predictionComplete) {
        boolean thisFlag;
        if (!predictionComplete.isChecked()) {
            return;
        }
        double offset = predictionComplete.getOffset();
        if (this.listeners.isEmpty() && !this.outputToConsole) {
            return;
        }
        if (this.player.predictedVelocity.vector.lengthSquared() == 0.0 && offset == 0.0) {
            return;
        }
        ChatColor color = this.pickColor(offset, offset);
        Vector predicted = this.player.predictedVelocity.vector;
        Vector actually = this.player.actualMovement;
        ChatColor xColor = this.pickColor(Math.abs(predicted.getX() - actually.getX()), offset);
        ChatColor yColor = this.pickColor(Math.abs(predicted.getY() - actually.getY()), offset);
        ChatColor zColor = this.pickColor(Math.abs(predicted.getZ() - actually.getZ()), offset);
        String p = String.valueOf(color) + "P: " + String.valueOf(xColor) + predicted.getX() + " " + String.valueOf(yColor) + predicted.getY() + " " + String.valueOf(zColor) + predicted.getZ();
        String a = String.valueOf(color) + "A: " + String.valueOf(xColor) + actually.getX() + " " + String.valueOf(yColor) + actually.getY() + " " + String.valueOf(zColor) + actually.getZ();
        String canSkipTick = (this.player.couldSkipTick + " ").substring(0, 1);
        String actualMovementSkip = (this.player.skippedTickInActualMovement + " ").substring(0, 1);
        String o = String.valueOf(ChatColor.GRAY) + canSkipTick + "\u21920.03\u2192" + actualMovementSkip + String.valueOf(color) + " O: " + offset;
        String prefix = this.player.bukkitPlayer == null ? "null" : this.player.bukkitPlayer.getName() + " ";
        boolean bl = thisFlag = color != ChatColor.GRAY && color != ChatColor.GREEN;
        if (this.enabledFlags) {
            if (this.lastMovementIsFlag) {
                this.predicted.clear();
                this.actually.clear();
                this.offset.clear();
            }
            this.predicted.add(p);
            this.actually.add(a);
            this.offset.add(o);
            this.lastMovementIsFlag = thisFlag;
        }
        if (thisFlag) {
            for (int i = 0; i < this.predicted.size(); ++i) {
                this.player.user.sendMessage((String)this.predicted.get(i));
                this.player.user.sendMessage((String)this.actually.get(i));
                this.player.user.sendMessage((String)this.offset.get(i));
            }
        }
        for (Player player2 : this.listeners) {
            player2.sendMessage((player2 == this.getPlayer().bukkitPlayer ? "" : prefix) + p);
            player2.sendMessage((player2 == this.getPlayer().bukkitPlayer ? "" : prefix) + a);
            player2.sendMessage((player2 == this.getPlayer().bukkitPlayer ? "" : prefix) + o);
        }
        this.listeners.removeIf(player -> !player.isOnline());
        if (this.outputToConsole) {
            LogUtil.info(prefix + p);
            LogUtil.info(prefix + a);
            LogUtil.info(prefix + o);
        }
    }

    private ChatColor pickColor(double offset, double totalOffset) {
        if (this.player.getSetbackTeleportUtil().blockOffsets) {
            return ChatColor.GRAY;
        }
        if (offset <= 0.0 || totalOffset <= 0.0) {
            return ChatColor.GRAY;
        }
        if (offset < 1.0E-4) {
            return ChatColor.GREEN;
        }
        if (offset < 0.01) {
            return ChatColor.YELLOW;
        }
        return ChatColor.RED;
    }

    public void toggleListener(Player player) {
        if (!this.listeners.remove(player)) {
            this.listeners.add(player);
        }
    }

    public boolean toggleConsoleOutput() {
        this.outputToConsole = !this.outputToConsole;
        return this.outputToConsole;
    }
}

