/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.commands;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.acf.BaseCommand;
import ac.grim.grimac.shaded.acf.annotation.CommandAlias;
import ac.grim.grimac.shaded.acf.annotation.CommandCompletion;
import ac.grim.grimac.shaded.acf.annotation.CommandPermission;
import ac.grim.grimac.shaded.acf.annotation.Optional;
import ac.grim.grimac.shaded.acf.annotation.Subcommand;
import ac.grim.grimac.shaded.acf.bukkit.contexts.OnlinePlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.User;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="grim|grimac")
public class GrimDebug
extends BaseCommand {
    @Subcommand(value="debug")
    @CommandPermission(value="grim.debug")
    @CommandCompletion(value="@players")
    public void onDebug(CommandSender sender, @Optional OnlinePlayer target) {
        GrimPlayer grimPlayer;
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if ((grimPlayer = this.parseTarget(sender, player, target)) == null) {
            return;
        }
        if (sender instanceof ConsoleCommandSender) {
            grimPlayer.checkManager.getDebugHandler().toggleConsoleOutput();
        } else {
            grimPlayer.checkManager.getDebugHandler().toggleListener(player);
        }
    }

    private GrimPlayer parseTarget(CommandSender sender, Player player, OnlinePlayer target) {
        Player targetPlayer;
        Player player2 = targetPlayer = target == null ? player : target.getPlayer();
        if (player == null && target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You must specify a target as the console!");
            return null;
        }
        GrimPlayer grimPlayer = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(targetPlayer);
        if (grimPlayer == null) {
            User user = PacketEvents.getAPI().getPlayerManager().getUser(targetPlayer);
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This player is exempt from all checks!");
            if (user == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown PacketEvents user");
            } else {
                boolean isExempt = GrimAPI.INSTANCE.getPlayerDataManager().shouldCheck(user);
                if (!isExempt) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "User connection state: " + String.valueOf((Object)user.getConnectionState()));
                }
            }
        }
        return grimPlayer;
    }

    @Subcommand(value="consoledebug")
    @CommandPermission(value="grim.consoledebug")
    @CommandCompletion(value="@players")
    public void onConsoleDebug(CommandSender sender, @Optional OnlinePlayer target) {
        GrimPlayer grimPlayer;
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if ((grimPlayer = this.parseTarget(sender, player, target)) == null) {
            return;
        }
        boolean isOutput = grimPlayer.checkManager.getDebugHandler().toggleConsoleOutput();
        sender.sendMessage("Console output for " + (grimPlayer.bukkitPlayer == null ? grimPlayer.user.getProfile().getName() : grimPlayer.bukkitPlayer.getName()) + " is now " + isOutput);
    }
}

