/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.manager;

import ac.grim.grimac.api.AbstractCheck;
import ac.grim.grimac.checks.impl.aim.AimDuplicateLook;
import ac.grim.grimac.checks.impl.aim.AimModulo360;
import ac.grim.grimac.checks.impl.aim.processor.AimProcessor;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsA;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsC;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsD;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsE;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsF;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsG;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsH;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsI;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsK;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsL;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsM;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsN;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsO;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsP;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsQ;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsR;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsS;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsT;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsU;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsV;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsW;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsX;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsY;
import ac.grim.grimac.checks.impl.breaking.AirLiquidBreak;
import ac.grim.grimac.checks.impl.breaking.FarBreak;
import ac.grim.grimac.checks.impl.breaking.FastBreak;
import ac.grim.grimac.checks.impl.breaking.InvalidBreak;
import ac.grim.grimac.checks.impl.breaking.MultiBreak;
import ac.grim.grimac.checks.impl.breaking.NoSwingBreak;
import ac.grim.grimac.checks.impl.breaking.PositionBreakA;
import ac.grim.grimac.checks.impl.breaking.PositionBreakB;
import ac.grim.grimac.checks.impl.breaking.RotationBreak;
import ac.grim.grimac.checks.impl.breaking.WrongBreak;
import ac.grim.grimac.checks.impl.combat.Hitboxes;
import ac.grim.grimac.checks.impl.combat.MultiInteractA;
import ac.grim.grimac.checks.impl.combat.MultiInteractB;
import ac.grim.grimac.checks.impl.combat.Reach;
import ac.grim.grimac.checks.impl.crash.CrashA;
import ac.grim.grimac.checks.impl.crash.CrashB;
import ac.grim.grimac.checks.impl.crash.CrashC;
import ac.grim.grimac.checks.impl.crash.CrashD;
import ac.grim.grimac.checks.impl.crash.CrashE;
import ac.grim.grimac.checks.impl.crash.CrashF;
import ac.grim.grimac.checks.impl.crash.CrashG;
import ac.grim.grimac.checks.impl.crash.CrashH;
import ac.grim.grimac.checks.impl.elytra.ElytraA;
import ac.grim.grimac.checks.impl.elytra.ElytraB;
import ac.grim.grimac.checks.impl.elytra.ElytraC;
import ac.grim.grimac.checks.impl.elytra.ElytraD;
import ac.grim.grimac.checks.impl.elytra.ElytraE;
import ac.grim.grimac.checks.impl.elytra.ElytraF;
import ac.grim.grimac.checks.impl.elytra.ElytraG;
import ac.grim.grimac.checks.impl.elytra.ElytraH;
import ac.grim.grimac.checks.impl.elytra.ElytraI;
import ac.grim.grimac.checks.impl.exploit.ExploitA;
import ac.grim.grimac.checks.impl.exploit.ExploitB;
import ac.grim.grimac.checks.impl.exploit.ExploitC;
import ac.grim.grimac.checks.impl.groundspoof.NoFall;
import ac.grim.grimac.checks.impl.misc.ClientBrand;
import ac.grim.grimac.checks.impl.misc.GhostBlockMitigation;
import ac.grim.grimac.checks.impl.misc.TransactionOrder;
import ac.grim.grimac.checks.impl.movement.NoSlow;
import ac.grim.grimac.checks.impl.movement.PredictionRunner;
import ac.grim.grimac.checks.impl.movement.SetbackBlocker;
import ac.grim.grimac.checks.impl.movement.VehiclePredictionRunner;
import ac.grim.grimac.checks.impl.multiactions.MultiActionsA;
import ac.grim.grimac.checks.impl.multiactions.MultiActionsB;
import ac.grim.grimac.checks.impl.multiactions.MultiActionsC;
import ac.grim.grimac.checks.impl.multiactions.MultiActionsD;
import ac.grim.grimac.checks.impl.multiactions.MultiActionsE;
import ac.grim.grimac.checks.impl.multiactions.MultiActionsF;
import ac.grim.grimac.checks.impl.post.Post;
import ac.grim.grimac.checks.impl.prediction.DebugHandler;
import ac.grim.grimac.checks.impl.prediction.GroundSpoof;
import ac.grim.grimac.checks.impl.prediction.OffsetHandler;
import ac.grim.grimac.checks.impl.prediction.Phase;
import ac.grim.grimac.checks.impl.scaffolding.AirLiquidPlace;
import ac.grim.grimac.checks.impl.scaffolding.DuplicateRotPlace;
import ac.grim.grimac.checks.impl.scaffolding.FabricatedPlace;
import ac.grim.grimac.checks.impl.scaffolding.FarPlace;
import ac.grim.grimac.checks.impl.scaffolding.InvalidPlaceA;
import ac.grim.grimac.checks.impl.scaffolding.InvalidPlaceB;
import ac.grim.grimac.checks.impl.scaffolding.MultiPlace;
import ac.grim.grimac.checks.impl.scaffolding.PositionPlace;
import ac.grim.grimac.checks.impl.scaffolding.RotationPlace;
import ac.grim.grimac.checks.impl.sprint.SprintA;
import ac.grim.grimac.checks.impl.sprint.SprintB;
import ac.grim.grimac.checks.impl.sprint.SprintC;
import ac.grim.grimac.checks.impl.sprint.SprintD;
import ac.grim.grimac.checks.impl.sprint.SprintE;
import ac.grim.grimac.checks.impl.sprint.SprintF;
import ac.grim.grimac.checks.impl.timer.NegativeTimer;
import ac.grim.grimac.checks.impl.timer.TickTimer;
import ac.grim.grimac.checks.impl.timer.Timer;
import ac.grim.grimac.checks.impl.timer.VehicleTimer;
import ac.grim.grimac.checks.impl.vehicle.VehicleA;
import ac.grim.grimac.checks.impl.vehicle.VehicleB;
import ac.grim.grimac.checks.impl.vehicle.VehicleC;
import ac.grim.grimac.checks.impl.vehicle.VehicleD;
import ac.grim.grimac.checks.impl.velocity.ExplosionHandler;
import ac.grim.grimac.checks.impl.velocity.KnockbackHandler;
import ac.grim.grimac.checks.type.BlockBreakCheck;
import ac.grim.grimac.checks.type.BlockPlaceCheck;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.checks.type.PositionCheck;
import ac.grim.grimac.checks.type.PostPredictionCheck;
import ac.grim.grimac.checks.type.RotationCheck;
import ac.grim.grimac.checks.type.VehicleCheck;
import ac.grim.grimac.events.packets.PacketChangeGameState;
import ac.grim.grimac.events.packets.PacketEntityReplication;
import ac.grim.grimac.events.packets.PacketPlayerAbilities;
import ac.grim.grimac.events.packets.PacketWorldBorder;
import ac.grim.grimac.manager.ActionManager;
import ac.grim.grimac.manager.LastInstanceManager;
import ac.grim.grimac.manager.SetbackTeleportUtil;
import ac.grim.grimac.manager.init.start.SuperDebug;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.predictionengine.GhostBlockDetector;
import ac.grim.grimac.predictionengine.SneakingEstimator;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.utils.anticheat.update.BlockBreak;
import ac.grim.grimac.utils.anticheat.update.BlockPlace;
import ac.grim.grimac.utils.anticheat.update.PositionUpdate;
import ac.grim.grimac.utils.anticheat.update.PredictionComplete;
import ac.grim.grimac.utils.anticheat.update.RotationUpdate;
import ac.grim.grimac.utils.anticheat.update.VehiclePositionUpdate;
import ac.grim.grimac.utils.latency.CompensatedCooldown;
import ac.grim.grimac.utils.latency.CompensatedFireworks;
import ac.grim.grimac.utils.latency.CompensatedInventory;
import ac.grim.grimac.utils.team.TeamHandler;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class CheckManager {
    private static boolean inited;
    private static final AtomicBoolean initedAtomic;
    ClassToInstanceMap<PacketCheck> packetChecks;
    ClassToInstanceMap<PositionCheck> positionCheck;
    ClassToInstanceMap<RotationCheck> rotationCheck;
    ClassToInstanceMap<VehicleCheck> vehicleCheck;
    ClassToInstanceMap<PacketCheck> prePredictionChecks;
    ClassToInstanceMap<BlockBreakCheck> blockBreakChecks;
    ClassToInstanceMap<BlockPlaceCheck> blockPlaceCheck;
    ClassToInstanceMap<PostPredictionCheck> postPredictionCheck;
    public ClassToInstanceMap<AbstractCheck> allChecks;
    private PacketEntityReplication packetEntityReplication = null;
    private CompensatedInventory inventory = null;

    public CheckManager(GrimPlayer player) {
        this.packetChecks = new ImmutableClassToInstanceMap.Builder().put(Hitboxes.class, (Object)new Hitboxes(player)).put(Reach.class, (Object)new Reach(player)).put(PacketEntityReplication.class, (Object)new PacketEntityReplication(player)).put(PacketChangeGameState.class, (Object)new PacketChangeGameState(player)).put(CompensatedInventory.class, (Object)new CompensatedInventory(player)).put(PacketPlayerAbilities.class, (Object)new PacketPlayerAbilities(player)).put(PacketWorldBorder.class, (Object)new PacketWorldBorder(player)).put(ActionManager.class, (Object)player.actionManager).put(TeamHandler.class, (Object)new TeamHandler(player)).put(ClientBrand.class, (Object)new ClientBrand(player)).put(NoFall.class, (Object)new NoFall(player)).put(BadPacketsO.class, (Object)new BadPacketsO(player)).put(BadPacketsA.class, (Object)new BadPacketsA(player)).put(BadPacketsC.class, (Object)new BadPacketsC(player)).put(BadPacketsD.class, (Object)new BadPacketsD(player)).put(BadPacketsE.class, (Object)new BadPacketsE(player)).put(BadPacketsF.class, (Object)new BadPacketsF(player)).put(BadPacketsG.class, (Object)new BadPacketsG(player)).put(BadPacketsH.class, (Object)new BadPacketsH(player)).put(BadPacketsI.class, (Object)new BadPacketsI(player)).put(BadPacketsK.class, (Object)new BadPacketsK(player)).put(BadPacketsL.class, (Object)new BadPacketsL(player)).put(BadPacketsM.class, (Object)new BadPacketsM(player)).put(BadPacketsN.class, (Object)new BadPacketsN(player)).put(BadPacketsP.class, (Object)new BadPacketsP(player)).put(BadPacketsQ.class, (Object)new BadPacketsQ(player)).put(BadPacketsR.class, (Object)new BadPacketsR(player)).put(BadPacketsS.class, (Object)new BadPacketsS(player)).put(BadPacketsT.class, (Object)new BadPacketsT(player)).put(BadPacketsU.class, (Object)new BadPacketsU(player)).put(BadPacketsV.class, (Object)new BadPacketsV(player)).put(BadPacketsW.class, (Object)new BadPacketsW(player)).put(BadPacketsY.class, (Object)new BadPacketsY(player)).put(MultiActionsA.class, (Object)new MultiActionsA(player)).put(MultiActionsB.class, (Object)new MultiActionsB(player)).put(MultiActionsC.class, (Object)new MultiActionsC(player)).put(MultiActionsD.class, (Object)new MultiActionsD(player)).put(MultiActionsE.class, (Object)new MultiActionsE(player)).put(TransactionOrder.class, (Object)new TransactionOrder(player)).put(SprintA.class, (Object)new SprintA(player)).put(VehicleA.class, (Object)new VehicleA(player)).put(VehicleB.class, (Object)new VehicleB(player)).put(VehicleC.class, (Object)new VehicleC(player)).put(VehicleD.class, (Object)new VehicleD(player)).put(SetbackBlocker.class, (Object)new SetbackBlocker(player)).build();
        this.positionCheck = new ImmutableClassToInstanceMap.Builder().put(PredictionRunner.class, (Object)new PredictionRunner(player)).put(CompensatedCooldown.class, (Object)new CompensatedCooldown(player)).build();
        this.rotationCheck = new ImmutableClassToInstanceMap.Builder().put(AimProcessor.class, (Object)new AimProcessor(player)).put(AimModulo360.class, (Object)new AimModulo360(player)).put(AimDuplicateLook.class, (Object)new AimDuplicateLook(player)).build();
        this.vehicleCheck = new ImmutableClassToInstanceMap.Builder().put(VehiclePredictionRunner.class, (Object)new VehiclePredictionRunner(player)).build();
        this.postPredictionCheck = new ImmutableClassToInstanceMap.Builder().put(NegativeTimer.class, (Object)new NegativeTimer(player)).put(ExplosionHandler.class, (Object)new ExplosionHandler(player)).put(KnockbackHandler.class, (Object)new KnockbackHandler(player)).put(GhostBlockDetector.class, (Object)new GhostBlockDetector(player)).put(Phase.class, (Object)new Phase(player)).put(Post.class, (Object)new Post(player)).put(GroundSpoof.class, (Object)new GroundSpoof(player)).put(OffsetHandler.class, (Object)new OffsetHandler(player)).put(SuperDebug.class, (Object)new SuperDebug(player)).put(DebugHandler.class, (Object)new DebugHandler(player)).put(BadPacketsX.class, (Object)new BadPacketsX(player)).put(NoSlow.class, (Object)new NoSlow(player)).put(SprintB.class, (Object)new SprintB(player)).put(SprintC.class, (Object)new SprintC(player)).put(SprintD.class, (Object)new SprintD(player)).put(SprintE.class, (Object)new SprintE(player)).put(SprintF.class, (Object)new SprintF(player)).put(MultiInteractA.class, (Object)new MultiInteractA(player)).put(MultiInteractB.class, (Object)new MultiInteractB(player)).put(ElytraA.class, (Object)new ElytraA(player)).put(ElytraB.class, (Object)new ElytraB(player)).put(ElytraC.class, (Object)new ElytraC(player)).put(ElytraD.class, (Object)new ElytraD(player)).put(ElytraE.class, (Object)new ElytraE(player)).put(ElytraF.class, (Object)new ElytraF(player)).put(ElytraG.class, (Object)new ElytraG(player)).put(ElytraH.class, (Object)new ElytraH(player)).put(ElytraI.class, (Object)new ElytraI(player)).put(SetbackTeleportUtil.class, (Object)new SetbackTeleportUtil(player)).put(CompensatedFireworks.class, (Object)player.fireworks).put(SneakingEstimator.class, (Object)new SneakingEstimator(player)).put(LastInstanceManager.class, (Object)player.lastInstanceManager).build();
        this.blockPlaceCheck = new ImmutableClassToInstanceMap.Builder().put(InvalidPlaceA.class, (Object)new InvalidPlaceA(player)).put(InvalidPlaceB.class, (Object)new InvalidPlaceB(player)).put(AirLiquidPlace.class, (Object)new AirLiquidPlace(player)).put(MultiPlace.class, (Object)new MultiPlace(player)).put(MultiActionsF.class, (Object)new MultiActionsF(player)).put(FarPlace.class, (Object)new FarPlace(player)).put(FabricatedPlace.class, (Object)new FabricatedPlace(player)).put(PositionPlace.class, (Object)new PositionPlace(player)).put(RotationPlace.class, (Object)new RotationPlace(player)).put(DuplicateRotPlace.class, (Object)new DuplicateRotPlace(player)).put(GhostBlockMitigation.class, (Object)new GhostBlockMitigation(player)).build();
        this.prePredictionChecks = new ImmutableClassToInstanceMap.Builder().put(Timer.class, (Object)new Timer(player)).put(TickTimer.class, (Object)new TickTimer(player)).put(CrashA.class, (Object)new CrashA(player)).put(CrashB.class, (Object)new CrashB(player)).put(CrashC.class, (Object)new CrashC(player)).put(CrashD.class, (Object)new CrashD(player)).put(CrashE.class, (Object)new CrashE(player)).put(CrashF.class, (Object)new CrashF(player)).put(CrashG.class, (Object)new CrashG(player)).put(CrashH.class, (Object)new CrashH(player)).put(ExploitA.class, (Object)new ExploitA(player)).put(ExploitB.class, (Object)new ExploitB(player)).put(ExploitC.class, (Object)new ExploitC(player)).put(VehicleTimer.class, (Object)new VehicleTimer(player)).build();
        this.blockBreakChecks = new ImmutableClassToInstanceMap.Builder().put(AirLiquidBreak.class, (Object)new AirLiquidBreak(player)).put(WrongBreak.class, (Object)new WrongBreak(player)).put(RotationBreak.class, (Object)new RotationBreak(player)).put(FastBreak.class, (Object)new FastBreak(player)).put(MultiBreak.class, (Object)new MultiBreak(player)).put(NoSwingBreak.class, (Object)new NoSwingBreak(player)).put(FarBreak.class, (Object)new FarBreak(player)).put(InvalidBreak.class, (Object)new InvalidBreak(player)).put(PositionBreakA.class, (Object)new PositionBreakA(player)).put(PositionBreakB.class, (Object)new PositionBreakB(player)).build();
        this.allChecks = new ImmutableClassToInstanceMap.Builder().putAll(this.packetChecks).putAll(this.positionCheck).putAll(this.rotationCheck).putAll(this.vehicleCheck).putAll(this.postPredictionCheck).putAll(this.blockPlaceCheck).putAll(this.prePredictionChecks).putAll(this.blockBreakChecks).build();
        this.init();
    }

    public <T extends PositionCheck> T getPositionCheck(Class<T> check) {
        return (T)((PositionCheck)this.positionCheck.get(check));
    }

    public <T extends RotationCheck> T getRotationCheck(Class<T> check) {
        return (T)((RotationCheck)this.rotationCheck.get(check));
    }

    public <T extends VehicleCheck> T getVehicleCheck(Class<T> check) {
        return (T)((VehicleCheck)this.vehicleCheck.get(check));
    }

    public void onPrePredictionReceivePacket(PacketReceiveEvent packet) {
        for (PacketCheck check : this.prePredictionChecks.values()) {
            check.onPacketReceive(packet);
        }
    }

    public void onPacketReceive(PacketReceiveEvent packet) {
        for (PacketCheck check : this.packetChecks.values()) {
            check.onPacketReceive(packet);
        }
        for (PacketCheck check : this.postPredictionCheck.values()) {
            check.onPacketReceive(packet);
        }
        for (PacketCheck check : this.blockPlaceCheck.values()) {
            check.onPacketReceive(packet);
        }
        for (PacketCheck check : this.blockBreakChecks.values()) {
            check.onPacketReceive(packet);
        }
    }

    public void onPacketSend(PacketSendEvent packet) {
        for (PacketCheck check : this.prePredictionChecks.values()) {
            check.onPacketSend(packet);
        }
        for (PacketCheck check : this.packetChecks.values()) {
            check.onPacketSend(packet);
        }
        for (PacketCheck check : this.postPredictionCheck.values()) {
            check.onPacketSend(packet);
        }
        for (PacketCheck check : this.blockPlaceCheck.values()) {
            check.onPacketSend(packet);
        }
        for (PacketCheck check : this.blockBreakChecks.values()) {
            check.onPacketSend(packet);
        }
    }

    public void onPositionUpdate(PositionUpdate position) {
        for (PositionCheck check : this.positionCheck.values()) {
            check.onPositionUpdate(position);
        }
    }

    public void onRotationUpdate(RotationUpdate rotation) {
        for (RotationCheck check : this.rotationCheck.values()) {
            check.process(rotation);
        }
        for (RotationCheck check : this.blockPlaceCheck.values()) {
            check.process(rotation);
        }
    }

    public void onVehiclePositionUpdate(VehiclePositionUpdate update) {
        for (VehicleCheck check : this.vehicleCheck.values()) {
            check.process(update);
        }
    }

    public void onPredictionFinish(PredictionComplete complete) {
        for (PostPredictionCheck check : this.postPredictionCheck.values()) {
            check.onPredictionComplete(complete);
        }
        for (PostPredictionCheck check : this.blockPlaceCheck.values()) {
            check.onPredictionComplete(complete);
        }
        for (PostPredictionCheck check : this.blockBreakChecks.values()) {
            check.onPredictionComplete(complete);
        }
    }

    public void onBlockPlace(BlockPlace place) {
        for (BlockPlaceCheck check : this.blockPlaceCheck.values()) {
            check.onBlockPlace(place);
        }
    }

    public void onPostFlyingBlockPlace(BlockPlace place) {
        for (BlockPlaceCheck check : this.blockPlaceCheck.values()) {
            check.onPostFlyingBlockPlace(place);
        }
    }

    public void onBlockBreak(BlockBreak blockBreak) {
        for (BlockBreakCheck check : this.blockBreakChecks.values()) {
            check.onBlockBreak(blockBreak);
        }
    }

    public void onPostFlyingBlockBreak(BlockBreak blockBreak) {
        for (BlockBreakCheck check : this.blockBreakChecks.values()) {
            check.onPostFlyingBlockBreak(blockBreak);
        }
    }

    public ExplosionHandler getExplosionHandler() {
        return this.getPostPredictionCheck(ExplosionHandler.class);
    }

    public <T extends PacketCheck> T getPacketCheck(Class<T> check) {
        return (T)((PacketCheck)this.packetChecks.get(check));
    }

    public <T extends PacketCheck> T getPrePredictionCheck(Class<T> check) {
        return (T)((PacketCheck)this.prePredictionChecks.get(check));
    }

    public PacketEntityReplication getEntityReplication() {
        if (this.packetEntityReplication == null) {
            this.packetEntityReplication = this.getPacketCheck(PacketEntityReplication.class);
        }
        return this.packetEntityReplication;
    }

    public NoFall getNoFall() {
        return this.getPacketCheck(NoFall.class);
    }

    public CompensatedInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = this.getPacketCheck(CompensatedInventory.class);
        }
        return this.inventory;
    }

    public KnockbackHandler getKnockbackHandler() {
        return this.getPostPredictionCheck(KnockbackHandler.class);
    }

    public CompensatedCooldown getCompensatedCooldown() {
        return this.getPositionCheck(CompensatedCooldown.class);
    }

    public NoSlow getNoSlow() {
        return this.getPostPredictionCheck(NoSlow.class);
    }

    public SetbackTeleportUtil getSetbackUtil() {
        return this.getPostPredictionCheck(SetbackTeleportUtil.class);
    }

    public DebugHandler getDebugHandler() {
        return this.getPostPredictionCheck(DebugHandler.class);
    }

    public OffsetHandler getOffsetHandler() {
        return this.getPostPredictionCheck(OffsetHandler.class);
    }

    public <T extends PostPredictionCheck> T getPostPredictionCheck(Class<T> check) {
        return (T)((PostPredictionCheck)this.postPredictionCheck.get(check));
    }

    private void init() {
        if (inited || initedAtomic.getAndSet(true)) {
            return;
        }
        inited = true;
        String[] permissions = new String[]{"grim.exempt.", "grim.nosetback.", "grim.nomodifypacket."};
        for (AbstractCheck check : this.allChecks.values()) {
            if (check.getCheckName() == null) continue;
            String id = check.getCheckName().toLowerCase();
            for (String string : permissions) {
                String string2 = string + id;
                Permission permission = Bukkit.getPluginManager().getPermission(string2);
                if (permission == null) {
                    Bukkit.getPluginManager().addPermission(new Permission(string2, PermissionDefault.FALSE));
                    continue;
                }
                permission.setDefault(PermissionDefault.FALSE);
            }
        }
    }

    static {
        initedAtomic = new AtomicBoolean(false);
    }
}

