/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.manager;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.manager.init.Initable;
import ac.grim.grimac.manager.init.load.PacketEventsInit;
import ac.grim.grimac.manager.init.start.BStats;
import ac.grim.grimac.manager.init.start.CommandRegister;
import ac.grim.grimac.manager.init.start.EventManager;
import ac.grim.grimac.manager.init.start.ExemptOnlinePlayers;
import ac.grim.grimac.manager.init.start.JavaVersion;
import ac.grim.grimac.manager.init.start.PacketLimiter;
import ac.grim.grimac.manager.init.start.PacketManager;
import ac.grim.grimac.manager.init.start.PlaceholderAPIExpansion;
import ac.grim.grimac.manager.init.start.TAB;
import ac.grim.grimac.manager.init.start.TickEndEvent;
import ac.grim.grimac.manager.init.start.TickRunner;
import ac.grim.grimac.manager.init.start.ViaBackwardsManager;
import ac.grim.grimac.manager.init.start.ViaVersion;
import ac.grim.grimac.manager.init.stop.TerminatePacketEvents;
import ac.grim.grimac.utils.anticheat.MessageUtil;
import com.google.common.collect.ImmutableList;

public class InitManager {
    private final ImmutableList<Initable> initializersOnLoad = ImmutableList.builder().add((Object)new PacketEventsInit()).add(() -> GrimAPI.INSTANCE.getExternalAPI().load()).build();
    private final ImmutableList<Initable> initializersOnStart = ImmutableList.builder().add((Object)GrimAPI.INSTANCE.getExternalAPI()).add((Object)new ExemptOnlinePlayers()).add((Object)new EventManager()).add((Object)new PacketManager()).add((Object)new ViaBackwardsManager()).add((Object)new TickRunner()).add((Object)new TickEndEvent()).add((Object)new CommandRegister()).add((Object)new BStats()).add((Object)new PacketLimiter()).add((Object)GrimAPI.INSTANCE.getDiscordManager()).add((Object)GrimAPI.INSTANCE.getSpectateManager()).add((Object)new JavaVersion()).add((Object)new ViaVersion()).add((Object)new TAB()).add(() -> {
        if (MessageUtil.hasPlaceholderAPI) {
            new PlaceholderAPIExpansion().register();
        }
    }).build();
    private final ImmutableList<Initable> initializersOnStop = ImmutableList.builder().add((Object)new TerminatePacketEvents()).build();
    private boolean loaded = false;
    private boolean started = false;
    private boolean stopped = false;

    public void load() {
        for (Initable initable : this.initializersOnLoad) {
            this.handle(initable);
        }
        this.loaded = true;
    }

    public void start() {
        for (Initable initable : this.initializersOnStart) {
            this.handle(initable);
        }
        this.started = true;
    }

    public void stop() {
        for (Initable initable : this.initializersOnStop) {
            this.handle(initable);
        }
        this.stopped = true;
    }

    private void handle(Initable initable) {
        try {
            initable.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

