/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.player;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.api.AbstractCheck;
import ac.grim.grimac.api.GrimUser;
import ac.grim.grimac.api.config.ConfigManager;
import ac.grim.grimac.api.feature.FeatureManager;
import ac.grim.grimac.api.handler.ResyncHandler;
import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.impl.aim.processor.AimProcessor;
import ac.grim.grimac.checks.impl.misc.ClientBrand;
import ac.grim.grimac.checks.impl.misc.TransactionOrder;
import ac.grim.grimac.events.packets.CheckManagerListener;
import ac.grim.grimac.manager.ActionManager;
import ac.grim.grimac.manager.CheckManager;
import ac.grim.grimac.manager.LastInstanceManager;
import ac.grim.grimac.manager.PunishmentManager;
import ac.grim.grimac.manager.SetbackTeleportUtil;
import ac.grim.grimac.manager.player.features.FeatureManagerImpl;
import ac.grim.grimac.manager.player.handlers.BukkitResyncHandler;
import ac.grim.grimac.predictionengine.MovementCheckRunner;
import ac.grim.grimac.predictionengine.PointThreeEstimator;
import ac.grim.grimac.predictionengine.UncertaintyHandler;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.ConnectionState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.attribute.Attributes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.component.ComponentTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.component.builtin.item.ItemEquippable;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.EquipmentSlot;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.GameMode;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.User;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.dimension.DimensionType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDisconnect;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityVelocity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPing;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWindowConfirmation;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.legacy.LegacyComponentSerializer;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.viaversion.ViaVersionUtil;
import ac.grim.grimac.shaded.jetbrains.annotations.Contract;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.shaded.kyori.adventure.text.Component;
import ac.grim.grimac.shaded.kyori.adventure.text.TranslatableComponent;
import ac.grim.grimac.utils.anticheat.LogUtil;
import ac.grim.grimac.utils.anticheat.MessageUtil;
import ac.grim.grimac.utils.anticheat.update.BlockBreak;
import ac.grim.grimac.utils.change.PlayerBlockHistory;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.BlockPlaceSnapshot;
import ac.grim.grimac.utils.data.MainSupportingBlockData;
import ac.grim.grimac.utils.data.PacketStateData;
import ac.grim.grimac.utils.data.Pair;
import ac.grim.grimac.utils.data.TrackerData;
import ac.grim.grimac.utils.data.VectorData;
import ac.grim.grimac.utils.data.VehicleData;
import ac.grim.grimac.utils.data.VelocityData;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.data.packetentity.PacketEntitySelf;
import ac.grim.grimac.utils.data.tags.SyncedTags;
import ac.grim.grimac.utils.enums.FluidTag;
import ac.grim.grimac.utils.enums.Pose;
import ac.grim.grimac.utils.latency.CompensatedEntities;
import ac.grim.grimac.utils.latency.CompensatedFireworks;
import ac.grim.grimac.utils.latency.CompensatedInventory;
import ac.grim.grimac.utils.latency.CompensatedWorld;
import ac.grim.grimac.utils.latency.LatencyUtils;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.math.TrigHandler;
import ac.grim.grimac.utils.nmsutil.BlockProperties;
import ac.grim.grimac.utils.nmsutil.GetBoundingBox;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketTracker;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GrimPlayer
implements GrimUser {
    public UUID uuid;
    public final User user;
    public int entityID;
    @Nullable
    public Player bukkitPlayer;
    public final Queue<Pair<Short, Long>> transactionsSent = new ConcurrentLinkedQueue<Pair<Short, Long>>();
    public final Set<Short> didWeSendThatTrans = ConcurrentHashMap.newKeySet();
    private final AtomicInteger transactionIDCounter = new AtomicInteger(0);
    public AtomicInteger lastTransactionSent = new AtomicInteger(0);
    public AtomicInteger lastTransactionReceived = new AtomicInteger(0);
    public CheckManager checkManager;
    public ActionManager actionManager;
    public PunishmentManager punishmentManager;
    public MovementCheckRunner movementCheckRunner;
    public SyncedTags tagManager;
    public Vector clientVelocity = new Vector();
    PacketTracker packetTracker;
    private long transactionPing = 0L;
    public long lastTransSent = 0L;
    public long lastTransReceived = 0L;
    private long playerClockAtLeast = System.nanoTime();
    public double lastWasClimbing = 0.0;
    public boolean canSwimHop = false;
    public int riptideSpinAttackTicks = 0;
    public int powderSnowFrozenTicks = 0;
    public boolean hasGravity = true;
    public final long joinTime = System.currentTimeMillis();
    public boolean playerEntityHasGravity = true;
    public VectorData predictedVelocity = new VectorData(new Vector(), VectorData.VectorType.Normal);
    public Vector actualMovement = new Vector();
    public Vector stuckSpeedMultiplier = new Vector(1, 1, 1);
    public UncertaintyHandler uncertaintyHandler;
    public double gravity;
    public float friction;
    public double speed;
    public Vector3d filterMojangStupidityOnMojangStupidity = new Vector3d();
    public double x;
    public double y;
    public double z;
    public double lastX;
    public double lastY;
    public double lastZ;
    public float xRot;
    public float yRot;
    public float lastXRot;
    public float lastYRot;
    public boolean onGround;
    public boolean lastOnGround;
    public boolean isSneaking;
    public boolean wasSneaking;
    public boolean isSprinting;
    public boolean lastSprinting;
    public boolean lastSprintingForSpeed;
    public boolean isFlying;
    public boolean canFly;
    public boolean wasFlying;
    public boolean isSwimming;
    public boolean wasSwimming;
    public boolean isClimbing;
    public boolean isGliding;
    public boolean wasGliding;
    public boolean isRiptidePose = false;
    public double fallDistance;
    public SimpleCollisionBox boundingBox;
    public Pose pose = Pose.STANDING;
    public Pose lastPose = Pose.STANDING;
    public boolean isSlowMovement = false;
    public boolean isInBed = false;
    public boolean lastInBed = false;
    public int food = 20;
    public float depthStriderLevel;
    public float sneakingSpeedMultiplier = 0.3f;
    public float flySpeed;
    public VehicleData vehicleData = new VehicleData();
    public boolean clientClaimsLastOnGround;
    public boolean wasTouchingWater = false;
    public boolean wasTouchingLava = false;
    public boolean slightlyTouchingLava = false;
    public boolean slightlyTouchingWater = false;
    public boolean wasEyeInWater = false;
    public FluidTag fluidOnEyes;
    public boolean horizontalCollision;
    public boolean verticalCollision;
    public boolean clientControlledVerticalCollision;
    public boolean couldSkipTick = false;
    public boolean skippedTickInActualMovement = false;
    public LastInstanceManager lastInstanceManager;
    public final CompensatedFireworks fireworks;
    public final CompensatedWorld compensatedWorld;
    public final CompensatedEntities compensatedEntities;
    public LatencyUtils latencyUtils;
    public PointThreeEstimator pointThreeEstimator;
    public TrigHandler trigHandler;
    public PacketStateData packetStateData;
    public Vector baseTickAddition = new Vector();
    public Vector baseTickWaterPushing = new Vector();
    public Vector startTickClientVel = new Vector();
    public int movementPackets = 0;
    public VelocityData firstBreadKB = null;
    public VelocityData likelyKB = null;
    public VelocityData firstBreadExplosion = null;
    public VelocityData likelyExplosions = null;
    public int minAttackSlow = 0;
    public int maxAttackSlow = 0;
    public GameMode gamemode;
    public DimensionType dimensionType;
    public Vector3d bedPosition;
    public long lastBlockPlaceUseItem = 0L;
    public long lastBlockBreak = 0L;
    public AtomicInteger cancelledPackets = new AtomicInteger(0);
    public MainSupportingBlockData mainSupportingBlockData = new MainSupportingBlockData(null, false);
    public double[][] possibleEyeHeights = new double[3][];
    public int totalFlyingPacketsSent;
    public Queue<BlockPlaceSnapshot> placeUseItemPackets = new LinkedBlockingQueue<BlockPlaceSnapshot>();
    public Queue<BlockBreak> queuedBreaks = new LinkedBlockingQueue<BlockBreak>();
    public PlayerBlockHistory blockHistory = new PlayerBlockHistory();
    public boolean disableGrim = false;
    public boolean noModifyPacketPermission = false;
    public boolean noSetbackPermission = false;
    private boolean debugPacketCancel = false;
    private int spamThreshold = 100;
    private int maxTransactionTime = 60;
    private boolean ignoreDuplicatePacketRotation = false;
    private boolean experimentalChecks = false;
    private boolean cancelDuplicatePacket = true;
    private boolean exemptElytra = false;
    private boolean resetItemUsageOnAttack;
    private boolean resetItemUsageOnItemUpdate;
    private boolean resetItemUsageOnSlotChange;
    private final FeatureManagerImpl featureManager = new FeatureManagerImpl(this);
    private ResyncHandler resyncHandler = new BukkitResyncHandler(this);

    public GrimPlayer(User user) {
        this.user = user;
        this.uuid = user.getUUID();
        this.boundingBox = GetBoundingBox.getBoundingBoxFromPosAndSizeRaw(this.x, this.y, this.z, 0.6f, 1.8f);
        this.fireworks = new CompensatedFireworks(this);
        this.lastInstanceManager = new LastInstanceManager(this);
        this.actionManager = new ActionManager(this);
        this.checkManager = new CheckManager(this);
        this.punishmentManager = new PunishmentManager(this);
        this.tagManager = new SyncedTags(this);
        this.movementCheckRunner = new MovementCheckRunner(this);
        this.compensatedWorld = new CompensatedWorld(this);
        this.compensatedEntities = new CompensatedEntities(this);
        this.latencyUtils = new LatencyUtils(this);
        this.trigHandler = new TrigHandler(this);
        this.uncertaintyHandler = new UncertaintyHandler(this);
        this.pointThreeEstimator = new PointThreeEstimator(this);
        this.packetStateData = new PacketStateData();
        this.uncertaintyHandler.riptideEntities.add(0);
        this.uncertaintyHandler.collidingEntities.add(0);
        if (this.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14)) {
            float scale = (float)this.compensatedEntities.self.getAttributeValue(Attributes.SCALE);
            this.possibleEyeHeights[2] = new double[]{0.4 * (double)scale, 1.62 * (double)scale, 1.27 * (double)scale};
            this.possibleEyeHeights[1] = new double[]{1.27 * (double)scale, 1.62 * (double)scale, 0.4 * (double)scale};
            this.possibleEyeHeights[0] = new double[]{1.62 * (double)scale, 1.27 * (double)scale, 0.4 * (double)scale};
        } else if (this.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9)) {
            this.possibleEyeHeights[2] = new double[]{0.4, 1.62, 1.54};
            this.possibleEyeHeights[1] = new double[]{1.54, 1.62, 0.4};
            this.possibleEyeHeights[0] = new double[]{1.62, 1.54, 0.4};
        } else {
            this.possibleEyeHeights[1] = new double[]{1.54f, 1.62f};
            this.possibleEyeHeights[0] = new double[]{1.62f, 1.54f};
        }
        this.reload();
    }

    public void onPacketCancel() {
        if (this.spamThreshold != -1 && this.cancelledPackets.incrementAndGet() > this.spamThreshold) {
            LogUtil.info("Disconnecting " + this.getName() + " for spamming invalid packets, packets cancelled within a second " + String.valueOf(this.cancelledPackets));
            this.disconnect(MessageUtil.miniMessage(MessageUtil.replacePlaceholders(this, GrimAPI.INSTANCE.getConfigManager().getDisconnectClosed())));
            this.cancelledPackets.set(0);
            if (this.debugPacketCancel) {
                LogUtil.error("Stacktrace for onPacketCancel (debug-packet-cancel=true)", new Exception());
            }
        }
    }

    public Set<VectorData> getPossibleVelocities() {
        HashSet<VectorData> set = new HashSet<VectorData>();
        if (this.firstBreadKB != null) {
            set.add(new VectorData(this.firstBreadKB.vector.clone(), VectorData.VectorType.Knockback).returnNewModified(VectorData.VectorType.FirstBreadKnockback));
        }
        if (this.likelyKB != null) {
            set.add(new VectorData(this.likelyKB.vector.clone(), VectorData.VectorType.Knockback));
        }
        set.addAll(this.getPossibleVelocitiesMinusKnockback());
        return set;
    }

    public Set<VectorData> getPossibleVelocitiesMinusKnockback() {
        HashSet<VectorData> possibleMovements = new HashSet<VectorData>();
        possibleMovements.add(new VectorData(this.clientVelocity, VectorData.VectorType.Normal));
        if (this.canSwimHop && !this.onGround) {
            possibleMovements.add(new VectorData(this.clientVelocity.clone().setY(0.3f), VectorData.VectorType.Swimhop));
        }
        if (this.riptideSpinAttackTicks >= 0 && Collections.max(this.uncertaintyHandler.riptideEntities) > 0) {
            possibleMovements.add(new VectorData(this.clientVelocity.clone().multiply(-0.2), VectorData.VectorType.Trident));
        }
        if (this.lastWasClimbing != 0.0) {
            possibleMovements.add(new VectorData(this.clientVelocity.clone().setY(this.lastWasClimbing + this.baseTickAddition.getY()), VectorData.VectorType.Climbable));
        }
        for (VectorData data : new HashSet(possibleMovements)) {
            for (BlockFace direction : this.uncertaintyHandler.slimePistonBounces) {
                if (direction.getModX() != 0) {
                    possibleMovements.add(data.returnNewModified(data.vector.clone().setX(direction.getModX()), VectorData.VectorType.SlimePistonBounce));
                    continue;
                }
                if (direction.getModY() != 0) {
                    possibleMovements.add(data.returnNewModified(data.vector.clone().setY(direction.getModY()), VectorData.VectorType.SlimePistonBounce));
                    continue;
                }
                if (direction.getModZ() == 0) continue;
                possibleMovements.add(data.returnNewModified(data.vector.clone().setZ(direction.getModZ()), VectorData.VectorType.SlimePistonBounce));
            }
        }
        return possibleMovements;
    }

    public boolean addTransactionResponse(short id) {
        Pair<Short, Long> data = null;
        boolean hasID = false;
        int skipped = 0;
        for (Pair pair : this.transactionsSent) {
            if ((Short)pair.first() == id) {
                hasID = true;
                break;
            }
            ++skipped;
        }
        if (hasID) {
            if (this.packetTracker != null) {
                this.packetTracker.setIntervalPackets(this.packetTracker.getIntervalPackets() - 1L);
            }
            if (skipped > 0 && System.currentTimeMillis() - this.joinTime > 5000L) {
                this.checkManager.getPacketCheck(TransactionOrder.class).flagAndAlert("skipped: " + skipped);
            }
            while ((data = this.transactionsSent.poll()) != null) {
                this.lastTransactionReceived.incrementAndGet();
                this.lastTransReceived = System.currentTimeMillis();
                this.transactionPing = System.nanoTime() - data.second();
                this.playerClockAtLeast = data.second();
                if (data.first() != id) continue;
            }
            CheckManagerListener.handleQueuedPlaces(this, false, 0.0f, 0.0f, System.currentTimeMillis());
            CheckManagerListener.handleQueuedBreaks(this, false, 0.0f, 0.0f, System.currentTimeMillis());
            this.latencyUtils.handleNettySyncTransaction(this.lastTransactionReceived.get());
        }
        return data != null;
    }

    public void baseTickAddWaterPushing(Vector vector) {
        this.baseTickWaterPushing.add(vector);
    }

    public void baseTickAddVector(Vector vector) {
        this.clientVelocity.add(vector);
    }

    public void trackBaseTickAddition(Vector vector) {
        this.baseTickAddition.add(vector);
    }

    public float getMaxUpStep() {
        PacketEntitySelf self = this.compensatedEntities.self;
        PacketEntity riding = self.getRiding();
        if (riding == null) {
            return (float)self.getAttributeValue(Attributes.STEP_HEIGHT);
        }
        if (riding.isBoat()) {
            return 0.0f;
        }
        return (float)riding.getAttributeValue(Attributes.STEP_HEIGHT);
    }

    public void sendTransaction() {
        this.sendTransaction(false);
    }

    public void sendTransaction(boolean async) {
        if (this.user.getEncoderState() != ConnectionState.PLAY) {
            return;
        }
        if (this.disableGrim && (double)(System.nanoTime() - this.getPlayerClockAtLeast()) > 1.5E10) {
            return;
        }
        this.lastTransSent = System.currentTimeMillis();
        short transactionID = (short)(-1 * (this.transactionIDCounter.getAndIncrement() & Short.MAX_VALUE));
        try {
            PacketWrapper packet = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_17) ? new WrapperPlayServerPing(transactionID) : new WrapperPlayServerWindowConfirmation(0, transactionID, false);
            if (async) {
                ChannelHelper.runInEventLoop(this.user.getChannel(), () -> {
                    this.addTransactionSend(transactionID);
                    this.user.writePacket(packet);
                });
            } else {
                this.addTransactionSend(transactionID);
                this.user.writePacket(packet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addTransactionSend(short id) {
        this.didWeSendThatTrans.add(id);
    }

    public boolean isEyeInFluid(FluidTag tag) {
        return this.fluidOnEyes == tag;
    }

    public double getEyeHeight() {
        return this.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? (double)this.pose.eyeHeight : (this.isSneaking ? (double)1.54f : (double)1.62f);
    }

    public void timedOut() {
        this.disconnect(MessageUtil.miniMessage(MessageUtil.replacePlaceholders(this, GrimAPI.INSTANCE.getConfigManager().getDisconnectTimeout())));
    }

    public void disconnect(Component reason) {
        String textReason;
        if (reason instanceof TranslatableComponent) {
            TranslatableComponent translatableComponent = (TranslatableComponent)reason;
            textReason = translatableComponent.key();
        } else {
            textReason = LegacyComponentSerializer.legacySection().serialize(reason);
        }
        LogUtil.info("Disconnecting " + this.user.getProfile().getName() + " for " + ChatColor.stripColor((String)textReason));
        try {
            this.user.sendPacket(new WrapperPlayServerDisconnect(reason));
        }
        catch (Exception ignored) {
            LogUtil.warn("Failed to send disconnect packet to disconnect " + this.user.getProfile().getName() + "! Disconnecting anyways.");
        }
        this.user.closeConnection();
        if (this.bukkitPlayer != null) {
            FoliaScheduler.getEntityScheduler().execute((Entity)this.bukkitPlayer, (Plugin)GrimAPI.INSTANCE.getPlugin(), () -> this.bukkitPlayer.kickPlayer(textReason), null, 1L);
        }
    }

    public void pollData() {
        if (this.lastTransSent != 0L && this.lastTransSent + 80L < System.currentTimeMillis()) {
            this.sendTransaction(true);
        }
        if ((double)(System.nanoTime() - this.getPlayerClockAtLeast()) > (double)this.maxTransactionTime * 1.0E9) {
            this.timedOut();
        }
        if (!GrimAPI.INSTANCE.getPlayerDataManager().shouldCheck(this.user)) {
            GrimAPI.INSTANCE.getPlayerDataManager().remove(this.user);
        }
        if (this.packetTracker == null && ViaVersionUtil.isAvailable() && this.uuid != null) {
            UserConnection connection = Via.getManager().getConnectionManager().getConnectedClient(this.uuid);
            PacketTracker packetTracker = this.packetTracker = connection != null ? connection.getPacketTracker() : null;
        }
        if (this.uuid != null && this.bukkitPlayer == null) {
            this.bukkitPlayer = Bukkit.getPlayer((UUID)this.uuid);
            this.updatePermissions();
        }
    }

    public void updateVelocityMovementSkipping() {
        if (!this.couldSkipTick) {
            this.couldSkipTick = this.pointThreeEstimator.determineCanSkipTick(BlockProperties.getFrictionInfluencedSpeed((float)(this.speed * (this.isSprinting ? 1.3 : 1.0)), this), this.getPossibleVelocitiesMinusKnockback());
        }
        HashSet<VectorData> knockback = new HashSet<VectorData>();
        if (this.firstBreadKB != null) {
            knockback.add(new VectorData(this.firstBreadKB.vector, VectorData.VectorType.Knockback));
        }
        if (this.likelyKB != null) {
            knockback.add(new VectorData(this.likelyKB.vector, VectorData.VectorType.Knockback));
        }
        boolean kbPointThree = this.pointThreeEstimator.determineCanSkipTick(BlockProperties.getFrictionInfluencedSpeed((float)(this.speed * (this.isSprinting ? 1.3 : 1.0)), this), knockback);
        this.checkManager.getKnockbackHandler().setPointThree(kbPointThree);
        HashSet<VectorData> explosion = new HashSet<VectorData>();
        if (this.firstBreadExplosion != null) {
            explosion.add(new VectorData(this.firstBreadExplosion.vector, VectorData.VectorType.Explosion));
        }
        if (this.likelyExplosions != null) {
            explosion.add(new VectorData(this.likelyExplosions.vector, VectorData.VectorType.Explosion));
        }
        boolean explosionPointThree = this.pointThreeEstimator.determineCanSkipTick(BlockProperties.getFrictionInfluencedSpeed((float)(this.speed * (this.isSprinting ? 1.3 : 1.0)), this), explosion);
        this.checkManager.getExplosionHandler().setPointThree(explosionPointThree);
        if (kbPointThree || explosionPointThree) {
            this.uncertaintyHandler.lastPointThree.reset();
        }
    }

    @Override
    public void updatePermissions() {
        if (this.bukkitPlayer == null) {
            return;
        }
        this.noModifyPacketPermission = this.bukkitPlayer.hasPermission("grim.nomodifypacket");
        this.noSetbackPermission = this.bukkitPlayer.hasPermission("grim.nosetback");
        FoliaScheduler.getAsyncScheduler().runNow((Plugin)GrimAPI.INSTANCE.getPlugin(), t -> {
            for (AbstractCheck check : this.checkManager.allChecks.values()) {
                if (!(check instanceof Check)) continue;
                ((Check)check).updatePermissions();
            }
        });
    }

    public boolean isPointThree() {
        return this.getClientVersion().isOlderThan(ClientVersion.V_1_18_2);
    }

    public double getMovementThreshold() {
        return this.isPointThree() ? 0.03 : 2.0E-4;
    }

    public ClientVersion getClientVersion() {
        ClientVersion ver = this.user.getClientVersion();
        return Objects.requireNonNullElseGet(ver, () -> ClientVersion.getById(PacketEvents.getAPI().getServerManager().getVersion().getProtocolVersion()));
    }

    public boolean isTickingReliablyFor(int ticks) {
        return !this.canSkipTicks() || (this.inVehicle() || !this.uncertaintyHandler.lastPointThree.hasOccurredSince(ticks)) && !this.uncertaintyHandler.lastVehicleSwitch.hasOccurredSince(1);
    }

    public boolean inVehicle() {
        return this.compensatedEntities.self.inVehicle();
    }

    public CompensatedInventory getInventory() {
        return this.checkManager.getInventory();
    }

    public double[] getPossibleEyeHeights() {
        if (this.getClientVersion().isOlderThan(ClientVersion.V_1_9)) {
            return this.isSneaking ? this.possibleEyeHeights[1] : this.possibleEyeHeights[0];
        }
        return switch (this.pose) {
            case Pose.FALL_FLYING, Pose.SPIN_ATTACK, Pose.SWIMMING -> this.possibleEyeHeights[2];
            case Pose.NINE_CROUCHING, Pose.CROUCHING -> this.possibleEyeHeights[1];
            default -> this.possibleEyeHeights[0];
        };
    }

    @Override
    public int getTransactionPing() {
        return GrimMath.floor((double)this.transactionPing / 1000000.0);
    }

    @Override
    public int getKeepAlivePing() {
        if (this.bukkitPlayer == null) {
            return -1;
        }
        return PacketEvents.getAPI().getPlayerManager().getPing(this.bukkitPlayer);
    }

    public SetbackTeleportUtil getSetbackTeleportUtil() {
        return this.checkManager.getSetbackUtil();
    }

    public boolean wouldCollisionResultFlagGroundSpoof(double inputY, double collisionY) {
        boolean calculatedOnGround;
        boolean verticalCollision = inputY != collisionY;
        boolean bl = calculatedOnGround = verticalCollision && inputY < 0.0;
        if (this.exemptOnGround()) {
            return false;
        }
        if (inputY == -1.0E-7 && collisionY > -1.0E-7 && collisionY <= 0.0) {
            return false;
        }
        return calculatedOnGround != this.onGround;
    }

    public boolean exemptOnGround() {
        return this.inVehicle() || Collections.max(this.uncertaintyHandler.pistonX) != 0.0 || Collections.max(this.uncertaintyHandler.pistonY) != 0.0 || Collections.max(this.uncertaintyHandler.pistonZ) != 0.0 || this.uncertaintyHandler.isStepMovement || this.isFlying || this.compensatedEntities.self.isDead || this.isInBed || this.lastInBed || this.uncertaintyHandler.lastFlyingStatusChange.hasOccurredSince(30) || this.uncertaintyHandler.lastHardCollidingLerpingEntity.hasOccurredSince(3) || this.uncertaintyHandler.isOrWasNearGlitchyBlock;
    }

    public void handleMountVehicle(int vehicleID) {
        this.compensatedEntities.serverPlayerVehicle = vehicleID;
        TrackerData data = this.compensatedEntities.getTrackedEntity(vehicleID);
        if (data != null && PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9) && this.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) && (EntityTypes.isTypeInstanceOf(data.getEntityType(), EntityTypes.BOAT) || EntityTypes.isTypeInstanceOf(data.getEntityType(), EntityTypes.ABSTRACT_HORSE) || data.getEntityType() == EntityTypes.PIG || data.getEntityType() == EntityTypes.STRIDER)) {
            this.user.writePacket(new WrapperPlayServerEntityVelocity(vehicleID, new Vector3d()));
        }
        this.sendTransaction();
        this.latencyUtils.addRealTimeTask(this.lastTransactionSent.get(), () -> {
            this.vehicleData.wasVehicleSwitch = true;
        });
    }

    public int getRidingVehicleId() {
        return this.compensatedEntities.getPacketEntityID(this.compensatedEntities.self.getRiding());
    }

    public void handleDismountVehicle(PacketSendEvent event) {
        this.sendTransaction();
        this.compensatedEntities.serverPlayerVehicle = null;
        event.getTasksAfterSend().add(() -> {
            int ridingId;
            TrackerData data;
            if (this.inVehicle() && (data = this.compensatedEntities.serverPositionsMap.get(ridingId = this.getRidingVehicleId())) != null) {
                this.user.writePacket(new WrapperPlayServerEntityTeleport(ridingId, new Vector3d(data.getX(), data.getY(), data.getZ()), data.getXRot(), data.getYRot(), false));
            }
        });
        this.latencyUtils.addRealTimeTask(this.lastTransactionSent.get(), () -> {
            this.vehicleData.wasVehicleSwitch = true;
            if (this.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_14)) {
                this.compensatedEntities.hasSprintingAttributeEnabled = false;
            }
        });
    }

    public boolean canGlide() {
        if (this.getClientVersion().isOlderThan(ClientVersion.V_1_21_2) || PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_21_2)) {
            ItemStack chestPlate = this.getInventory().getChestplate();
            return chestPlate.getType() == ItemTypes.ELYTRA && chestPlate.getDamageValue() < chestPlate.getMaxDamage();
        }
        CompensatedInventory inventory = this.getInventory();
        return GrimPlayer.isGlider(inventory.getHelmet(), EquipmentSlot.CHEST_PLATE) || GrimPlayer.isGlider(inventory.getChestplate(), EquipmentSlot.LEGGINGS) || GrimPlayer.isGlider(inventory.getLeggings(), EquipmentSlot.BOOTS) || GrimPlayer.isGlider(inventory.getBoots(), EquipmentSlot.OFF_HAND);
    }

    private static boolean isGlider(ItemStack stack, EquipmentSlot slot) {
        if (!stack.hasComponent(ComponentTypes.GLIDER) || stack.getDamageValue() >= stack.getMaxDamage()) {
            return false;
        }
        Optional<ItemEquippable> equippable = stack.getComponent(ComponentTypes.EQUIPPABLE);
        return equippable.isPresent() && equippable.get().getSlot() == slot;
    }

    public void resyncPose() {
        if (this.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14) && this.bukkitPlayer != null) {
            this.bukkitPlayer.setSneaking(!this.bukkitPlayer.isSneaking());
        }
    }

    public boolean canUseGameMasterBlocks() {
        return this.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_10) || this.gamemode == GameMode.CREATIVE && this.compensatedEntities.self.getOpLevel() >= 2;
    }

    @Contract(pure=true)
    public boolean supportsEndTick() {
        return this.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_21_2) && PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2);
    }

    @Contract(pure=true)
    public boolean canSkipTicks() {
        return this.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) && !this.supportsEndTick();
    }

    @Override
    public void runSafely(Runnable runnable) {
        ChannelHelper.runInEventLoop(this.user.getChannel(), runnable);
    }

    @Override
    public int getLastTransactionReceived() {
        return this.lastTransactionReceived.get();
    }

    @Override
    public int getLastTransactionSent() {
        return this.lastTransactionSent.get();
    }

    @Override
    public void addRealTimeTask(int transaction, Runnable runnable) {
        this.latencyUtils.addRealTimeTask(transaction, runnable);
    }

    @Override
    public String getName() {
        return this.user.getName();
    }

    @Override
    public UUID getUniqueId() {
        return this.user.getProfile().getUUID();
    }

    @Override
    public String getBrand() {
        return this.checkManager.getPacketCheck(ClientBrand.class).getBrand();
    }

    @Override
    @Nullable
    public String getWorldName() {
        return this.bukkitPlayer != null ? this.bukkitPlayer.getWorld().getName() : null;
    }

    @Override
    @Nullable
    public UUID getWorldUID() {
        return this.bukkitPlayer != null ? this.bukkitPlayer.getWorld().getUID() : null;
    }

    @Override
    public String getVersionName() {
        return this.getClientVersion().getReleaseName();
    }

    @Override
    public double getHorizontalSensitivity() {
        return this.checkManager.getRotationCheck(AimProcessor.class).sensitivityX;
    }

    @Override
    public double getVerticalSensitivity() {
        return this.checkManager.getRotationCheck(AimProcessor.class).sensitivityY;
    }

    @Override
    public boolean isVanillaMath() {
        return this.trigHandler.isVanillaMath();
    }

    @Override
    public Collection<? extends AbstractCheck> getChecks() {
        return this.checkManager.allChecks.values();
    }

    public void runNettyTaskInMs(Runnable runnable, int ms) {
        Channel channel = (Channel)this.user.getChannel();
        channel.eventLoop().schedule(runnable, (long)ms, TimeUnit.MILLISECONDS);
    }

    @Override
    public void reload(ConfigManager config) {
        this.featureManager.onReload(config);
        this.debugPacketCancel = config.getBooleanElse("debug-packet-cancel", false);
        this.spamThreshold = config.getIntElse("packet-spam-threshold", 100);
        this.maxTransactionTime = GrimMath.clamp(config.getIntElse("max-transaction-time", 60), 1, 180);
        this.ignoreDuplicatePacketRotation = config.getBooleanElse("ignore-duplicate-packet-rotation", false);
        this.cancelDuplicatePacket = config.getBooleanElse("cancel-duplicate-packet", true);
        this.resetItemUsageOnAttack = config.getBooleanElse("reset-item-usage-on-attack", true);
        this.resetItemUsageOnItemUpdate = config.getBooleanElse("reset-item-usage-on-item-update", true);
        this.resetItemUsageOnSlotChange = config.getBooleanElse("reset-item-usage-on-slot-change", true);
        for (AbstractCheck value : this.checkManager.allChecks.values()) {
            value.reload();
        }
        this.punishmentManager.reload(config);
    }

    @Override
    public void reload() {
        this.reload(GrimAPI.INSTANCE.getConfigManager().getConfig());
    }

    @Override
    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    @Override
    public void sendMessage(String message) {
        if (this.bukkitPlayer != null) {
            this.bukkitPlayer.sendMessage(message);
        }
    }

    @Override
    public ResyncHandler getResyncHandler() {
        return this.resyncHandler;
    }

    @Override
    public void setResyncHandler(ResyncHandler resyncHandler) {
        this.resyncHandler = resyncHandler;
    }

    public long getPlayerClockAtLeast() {
        return this.playerClockAtLeast;
    }

    public boolean isIgnoreDuplicatePacketRotation() {
        return this.ignoreDuplicatePacketRotation;
    }

    public boolean isExperimentalChecks() {
        return this.experimentalChecks;
    }

    public void setExperimentalChecks(boolean experimentalChecks) {
        this.experimentalChecks = experimentalChecks;
    }

    public boolean isCancelDuplicatePacket() {
        return this.cancelDuplicatePacket;
    }

    public boolean isExemptElytra() {
        return this.exemptElytra;
    }

    public void setExemptElytra(boolean exemptElytra) {
        this.exemptElytra = exemptElytra;
    }

    public boolean isResetItemUsageOnAttack() {
        return this.resetItemUsageOnAttack;
    }

    public boolean isResetItemUsageOnItemUpdate() {
        return this.resetItemUsageOnItemUpdate;
    }

    public boolean isResetItemUsageOnSlotChange() {
        return this.resetItemUsageOnSlotChange;
    }
}

