/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.predictionengine.predictions.rideable;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.predictionengine.predictions.PredictionEngine;
import ac.grim.grimac.predictionengine.predictions.PredictionEngineNormal;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.attribute.Attributes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.potion.PotionTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.utils.data.VectorData;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.data.packetentity.PacketEntityCamel;
import ac.grim.grimac.utils.data.packetentity.PacketEntityHorse;
import ac.grim.grimac.utils.nmsutil.BlockProperties;
import ac.grim.grimac.utils.nmsutil.JumpPower;
import ac.grim.grimac.utils.nmsutil.ReachUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import org.bukkit.util.Vector;

public final class PredictionEngineRideableUtils {
    public static Set<VectorData> handleJumps(GrimPlayer player, Set<VectorData> possibleVectors) {
        PacketEntity packetEntity = player.compensatedEntities.self.getRiding();
        if (!(packetEntity instanceof PacketEntityHorse)) {
            return possibleVectors;
        }
        PacketEntityHorse horse = (PacketEntityHorse)packetEntity;
        if (horse instanceof PacketEntityCamel) {
            PacketEntityCamel camel = (PacketEntityCamel)horse;
            PredictionEngineRideableUtils.handleCamelDash(player, possibleVectors, camel);
        } else {
            PredictionEngineRideableUtils.handleHorseJumping(player, possibleVectors, horse);
        }
        if (player.lastOnGround) {
            player.vehicleData.horseJump = 0.0f;
            player.vehicleData.horseJumping = false;
        }
        return possibleVectors;
    }

    private static void handleCamelDash(GrimPlayer player, Set<VectorData> possibleVectors, PacketEntityCamel camel) {
        boolean wantsToJump;
        boolean bl = wantsToJump = player.vehicleData.horseJump > 0.0f && !player.vehicleData.horseJumping && player.lastOnGround;
        if (!wantsToJump) {
            return;
        }
        double jumpFactor = camel.getAttributeValue(Attributes.JUMP_STRENGTH) * (double)JumpPower.getPlayerJumpFactor(player);
        OptionalInt jumpBoost = player.compensatedEntities.getPotionLevelForPlayer(PotionTypes.JUMP_BOOST);
        double jumpYVelocity = jumpBoost.isPresent() ? jumpFactor + (double)((float)(jumpBoost.getAsInt() + 1) * 0.1f) : jumpFactor;
        double multiplier = (double)(22.2222f * player.vehicleData.horseJump) * camel.getAttributeValue(Attributes.MOVEMENT_SPEED) * (double)BlockProperties.getBlockSpeedFactor(player, player.mainSupportingBlockData, new Vector3d(player.lastX, player.lastY, player.lastZ));
        Vector jumpVelocity = ReachUtils.getLook(player, player.xRot, player.yRot).multiply(new Vector(1.0, 0.0, 1.0)).normalize().multiply(multiplier).add(new Vector(0.0, (double)(1.4285f * player.vehicleData.horseJump) * jumpYVelocity, 0.0));
        for (VectorData vectorData : possibleVectors) {
            vectorData.vector.add(jumpVelocity);
        }
        player.vehicleData.horseJumping = true;
        player.vehicleData.camelDashCooldown = 55;
    }

    private static void handleHorseJumping(GrimPlayer player, Set<VectorData> possibleVectors, PacketEntityHorse horse) {
        boolean wantsToJump;
        boolean bl = wantsToJump = player.vehicleData.horseJump > 0.0f && !player.vehicleData.horseJumping && player.lastOnGround;
        if (!wantsToJump) {
            return;
        }
        float forwardInput = player.vehicleData.vehicleForward;
        if (forwardInput <= 0.0f) {
            forwardInput *= 0.25f;
        }
        double jumpFactor = horse.getAttributeValue(Attributes.JUMP_STRENGTH) * (double)player.vehicleData.horseJump * (double)JumpPower.getPlayerJumpFactor(player);
        OptionalInt jumpBoost = player.compensatedEntities.getPotionLevelForPlayer(PotionTypes.JUMP_BOOST);
        double jumpVelocity = jumpBoost.isPresent() ? jumpFactor + (double)((float)(jumpBoost.getAsInt() + 1) * 0.1f) : jumpFactor;
        player.vehicleData.horseJumping = true;
        float f2 = player.trigHandler.sin(player.xRot * ((float)Math.PI / 180));
        float f3 = player.trigHandler.cos(player.xRot * ((float)Math.PI / 180));
        for (VectorData vectorData : possibleVectors) {
            vectorData.vector.setY(jumpVelocity);
            if (!(forwardInput > 0.0f)) continue;
            vectorData.vector.add(new Vector((double)(-0.4f * f2 * player.vehicleData.horseJump), 0.0, (double)(0.4f * f3 * player.vehicleData.horseJump)));
        }
        player.vehicleData.horseJump = 0.0f;
    }

    public static List<VectorData> applyInputsToVelocityPossibilities(Vector movementVector, GrimPlayer player, Set<VectorData> possibleVectors, float speed) {
        ArrayList<VectorData> returnVectors = new ArrayList<VectorData>();
        for (VectorData possibleLastTickOutput : possibleVectors) {
            VectorData result = new VectorData(possibleLastTickOutput.vector.clone().add(new PredictionEngine().getMovementResultFromInput(player, movementVector, speed, player.xRot)), possibleLastTickOutput, VectorData.VectorType.InputResult);
            result = result.returnNewModified(result.vector.clone().multiply(player.stuckSpeedMultiplier), VectorData.VectorType.StuckMultiplier);
            result = result.returnNewModified(new PredictionEngineNormal().handleOnClimbable(result.vector.clone(), player), VectorData.VectorType.Climbable);
            returnVectors.add(result);
            result = new VectorData(possibleLastTickOutput.vector.clone(), possibleLastTickOutput, VectorData.VectorType.InputResult);
            result = result.returnNewModified(result.vector.clone().multiply(player.stuckSpeedMultiplier), VectorData.VectorType.StuckMultiplier);
            result = result.returnNewModified(new PredictionEngineNormal().handleOnClimbable(result.vector.clone(), player), VectorData.VectorType.Climbable);
            returnVectors.add(result);
        }
        return returnVectors;
    }
}

