/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.ConnectionState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.PacketSide;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.ClientBoundPacket;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketTypeConstant;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.ServerBoundPacket;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_12;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_12_1;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_13;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_14;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_14_4;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_15;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_15_2;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_16;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_16_2;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_17;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_18;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_19;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_19_1;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_19_3;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_19_4;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_20_2;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_20_3;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_20_5;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_21;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_21_2;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_21_5;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_7_10;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_8;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_9;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.clientbound.ClientboundPacketType_1_9_3;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.config.clientbound.ClientboundConfigPacketType_1_20_2;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.config.clientbound.ClientboundConfigPacketType_1_20_3;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.config.clientbound.ClientboundConfigPacketType_1_20_5;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.config.clientbound.ClientboundConfigPacketType_1_21;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.config.serverbound.ServerboundConfigPacketType_1_20_2;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.config.serverbound.ServerboundConfigPacketType_1_20_5;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_12;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_12_1;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_13;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_14;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_15_2;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_16;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_16_2;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_17;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_19;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_19_1;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_19_3;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_19_4;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_20_2;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_20_3;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_20_5;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_21_2;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_21_4;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_21_5;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_7_10;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_8;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.serverbound.ServerboundPacketType_1_9;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.VersionMapper;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class PacketType {
    private static boolean PREPARED = false;
    private static final VersionMapper CLIENTBOUND_PLAY_VERSION_MAPPER = new VersionMapper(ClientVersion.V_1_7_10, ClientVersion.V_1_8, ClientVersion.V_1_9, ClientVersion.V_1_10, ClientVersion.V_1_12, ClientVersion.V_1_12_1, ClientVersion.V_1_13, ClientVersion.V_1_14, ClientVersion.V_1_14_4, ClientVersion.V_1_15, ClientVersion.V_1_15_2, ClientVersion.V_1_16, ClientVersion.V_1_16_2, ClientVersion.V_1_17, ClientVersion.V_1_18, ClientVersion.V_1_19, ClientVersion.V_1_19_1, ClientVersion.V_1_19_3, ClientVersion.V_1_19_4, ClientVersion.V_1_20_2, ClientVersion.V_1_20_3, ClientVersion.V_1_20_5, ClientVersion.V_1_21, ClientVersion.V_1_21_2, ClientVersion.V_1_21_5);
    private static final VersionMapper SERVERBOUND_PLAY_VERSION_MAPPER = new VersionMapper(ClientVersion.V_1_7_10, ClientVersion.V_1_8, ClientVersion.V_1_9, ClientVersion.V_1_12, ClientVersion.V_1_12_1, ClientVersion.V_1_13, ClientVersion.V_1_14, ClientVersion.V_1_15_2, ClientVersion.V_1_16, ClientVersion.V_1_16_2, ClientVersion.V_1_17, ClientVersion.V_1_19, ClientVersion.V_1_19_1, ClientVersion.V_1_19_3, ClientVersion.V_1_19_4, ClientVersion.V_1_20_2, ClientVersion.V_1_20_3, ClientVersion.V_1_20_5, ClientVersion.V_1_21_2, ClientVersion.V_1_21_4, ClientVersion.V_1_21_5);
    private static final VersionMapper CLIENTBOUND_CONFIG_VERSION_MAPPER = new VersionMapper(ClientVersion.V_1_20_2, ClientVersion.V_1_20_3, ClientVersion.V_1_20_5, ClientVersion.V_1_21);
    private static final VersionMapper SERVERBOUND_CONFIG_VERSION_MAPPER = new VersionMapper(ClientVersion.V_1_20_2, ClientVersion.V_1_20_5);

    public static void prepare() {
        Play.Client.load();
        Play.Server.load();
        Configuration.Client.load();
        Configuration.Server.load();
        PREPARED = true;
    }

    public static boolean isPrepared() {
        return PREPARED;
    }

    public static PacketTypeCommon getById(PacketSide side, ConnectionState state, ClientVersion version, int packetID) {
        switch (state) {
            case HANDSHAKING: {
                if (side == PacketSide.CLIENT) {
                    return Handshaking.Client.getById(packetID);
                }
                return Handshaking.Server.getById(packetID);
            }
            case STATUS: {
                if (side == PacketSide.CLIENT) {
                    return Status.Client.getById(packetID);
                }
                return Status.Server.getById(packetID);
            }
            case LOGIN: {
                if (side == PacketSide.CLIENT) {
                    return Login.Client.getById(packetID);
                }
                return Login.Server.getById(packetID);
            }
            case PLAY: {
                if (side == PacketSide.CLIENT) {
                    return Play.Client.getById(version, packetID);
                }
                return Play.Server.getById(version, packetID);
            }
            case CONFIGURATION: {
                if (side == PacketSide.CLIENT) {
                    return Configuration.Client.getById(version, packetID);
                }
                return Configuration.Server.getById(version, packetID);
            }
        }
        return null;
    }

    public static class Play {

        public static enum Server implements PacketTypeCommon,
        ClientBoundPacket
        {
            SET_COMPRESSION,
            MAP_CHUNK_BULK,
            UPDATE_ENTITY_NBT,
            UPDATE_SIGN,
            USE_BED,
            SPAWN_WEATHER_ENTITY,
            TITLE,
            WORLD_BORDER,
            COMBAT_EVENT,
            ENTITY_MOVEMENT,
            SPAWN_LIVING_ENTITY,
            SPAWN_PAINTING,
            SCULK_VIBRATION_SIGNAL,
            ACKNOWLEDGE_PLAYER_DIGGING,
            CHAT_PREVIEW_PACKET,
            NAMED_SOUND_EFFECT,
            PLAYER_CHAT_HEADER,
            PLAYER_INFO,
            DISPLAY_CHAT_PREVIEW,
            UPDATE_ENABLED_FEATURES,
            SPAWN_PLAYER,
            WINDOW_CONFIRMATION,
            SPAWN_ENTITY,
            SPAWN_EXPERIENCE_ORB,
            ENTITY_ANIMATION,
            STATISTICS,
            BLOCK_BREAK_ANIMATION,
            BLOCK_ENTITY_DATA,
            BLOCK_ACTION,
            BLOCK_CHANGE,
            BOSS_BAR,
            SERVER_DIFFICULTY,
            CLEAR_TITLES,
            TAB_COMPLETE,
            MULTI_BLOCK_CHANGE,
            DECLARE_COMMANDS,
            CLOSE_WINDOW,
            WINDOW_ITEMS,
            WINDOW_PROPERTY,
            SET_SLOT,
            SET_COOLDOWN,
            PLUGIN_MESSAGE,
            DISCONNECT,
            ENTITY_STATUS,
            EXPLOSION,
            UNLOAD_CHUNK,
            CHANGE_GAME_STATE,
            OPEN_HORSE_WINDOW,
            INITIALIZE_WORLD_BORDER,
            KEEP_ALIVE,
            CHUNK_DATA,
            EFFECT,
            PARTICLE,
            UPDATE_LIGHT,
            JOIN_GAME,
            MAP_DATA,
            MERCHANT_OFFERS,
            ENTITY_RELATIVE_MOVE,
            ENTITY_RELATIVE_MOVE_AND_ROTATION,
            ENTITY_ROTATION,
            VEHICLE_MOVE,
            OPEN_BOOK,
            OPEN_WINDOW,
            OPEN_SIGN_EDITOR,
            PING,
            CRAFT_RECIPE_RESPONSE,
            PLAYER_ABILITIES,
            END_COMBAT_EVENT,
            ENTER_COMBAT_EVENT,
            DEATH_COMBAT_EVENT,
            FACE_PLAYER,
            PLAYER_POSITION_AND_LOOK,
            UNLOCK_RECIPES,
            DESTROY_ENTITIES,
            REMOVE_ENTITY_EFFECT,
            RESOURCE_PACK_SEND,
            RESPAWN,
            ENTITY_HEAD_LOOK,
            SELECT_ADVANCEMENTS_TAB,
            ACTION_BAR,
            WORLD_BORDER_CENTER,
            WORLD_BORDER_LERP_SIZE,
            WORLD_BORDER_SIZE,
            WORLD_BORDER_WARNING_DELAY,
            WORLD_BORDER_WARNING_REACH,
            CAMERA,
            HELD_ITEM_CHANGE,
            UPDATE_VIEW_POSITION,
            UPDATE_VIEW_DISTANCE,
            SPAWN_POSITION,
            DISPLAY_SCOREBOARD,
            ENTITY_METADATA,
            ATTACH_ENTITY,
            ENTITY_VELOCITY,
            ENTITY_EQUIPMENT,
            SET_EXPERIENCE,
            UPDATE_HEALTH,
            SCOREBOARD_OBJECTIVE,
            SET_PASSENGERS,
            TEAMS,
            UPDATE_SCORE,
            UPDATE_SIMULATION_DISTANCE,
            SET_TITLE_SUBTITLE,
            TIME_UPDATE,
            SET_TITLE_TEXT,
            SET_TITLE_TIMES,
            ENTITY_SOUND_EFFECT,
            SOUND_EFFECT,
            STOP_SOUND,
            PLAYER_LIST_HEADER_AND_FOOTER,
            NBT_QUERY_RESPONSE,
            COLLECT_ITEM,
            ENTITY_TELEPORT,
            UPDATE_ADVANCEMENTS,
            UPDATE_ATTRIBUTES,
            ENTITY_EFFECT,
            DECLARE_RECIPES,
            TAGS,
            CHAT_MESSAGE,
            ACKNOWLEDGE_BLOCK_CHANGES,
            SERVER_DATA,
            SYSTEM_CHAT_MESSAGE,
            DELETE_CHAT,
            CUSTOM_CHAT_COMPLETIONS,
            DISGUISED_CHAT,
            PLAYER_INFO_REMOVE,
            PLAYER_INFO_UPDATE,
            DAMAGE_EVENT,
            HURT_ANIMATION,
            BUNDLE,
            CHUNK_BIOMES,
            CHUNK_BATCH_END,
            CHUNK_BATCH_BEGIN,
            DEBUG_PONG,
            CONFIGURATION_START,
            RESET_SCORE,
            RESOURCE_PACK_REMOVE,
            TICKING_STATE,
            TICKING_STEP,
            COOKIE_REQUEST,
            DEBUG_SAMPLE,
            STORE_COOKIE,
            TRANSFER,
            PROJECTILE_POWER,
            CUSTOM_REPORT_DETAILS,
            SERVER_LINKS,
            MOVE_MINECART,
            SET_CURSOR_ITEM,
            SET_PLAYER_INVENTORY,
            ENTITY_POSITION_SYNC,
            PLAYER_ROTATION,
            RECIPE_BOOK_ADD,
            RECIPE_BOOK_REMOVE,
            RECIPE_BOOK_SETTINGS,
            TEST_INSTANCE_BLOCK_STATUS;

            private static int INDEX;
            private static final Map<Byte, Map<Integer, PacketTypeCommon>> PACKET_TYPE_ID_MAP;
            private final int[] ids = new int[PacketType.access$400().getVersions().length];

            private Server() {
                Arrays.fill(this.ids, -1);
            }

            @Override
            public int getId(ClientVersion version) {
                if (!PREPARED) {
                    PacketType.prepare();
                }
                int index = CLIENTBOUND_PLAY_VERSION_MAPPER.getIndex(version);
                return this.ids[index];
            }

            @Nullable
            public static PacketTypeCommon getById(ClientVersion version, int packetId) {
                if (!PREPARED) {
                    PacketType.prepare();
                }
                int index = CLIENTBOUND_PLAY_VERSION_MAPPER.getIndex(version);
                Map<Integer, PacketTypeCommon> map = PACKET_TYPE_ID_MAP.get((byte)index);
                return map.get(packetId);
            }

            @Override
            public PacketSide getSide() {
                return PacketSide.SERVER;
            }

            private static void loadPacketIds(Enum<?>[] enumConstants) {
                int index = INDEX;
                for (Enum<?> constant : enumConstants) {
                    int id = constant.ordinal();
                    Server value = Server.valueOf(constant.name());
                    value.ids[index] = id;
                    Map packetIdMap = PACKET_TYPE_ID_MAP.computeIfAbsent((byte)index, k -> new HashMap());
                    packetIdMap.put(id, value);
                }
                ++INDEX;
            }

            public static void load() {
                INDEX = 0;
                Server.loadPacketIds(ClientboundPacketType_1_7_10.values());
                Server.loadPacketIds(ClientboundPacketType_1_8.values());
                Server.loadPacketIds(ClientboundPacketType_1_9.values());
                Server.loadPacketIds(ClientboundPacketType_1_9_3.values());
                Server.loadPacketIds(ClientboundPacketType_1_12.values());
                Server.loadPacketIds(ClientboundPacketType_1_12_1.values());
                Server.loadPacketIds(ClientboundPacketType_1_13.values());
                Server.loadPacketIds(ClientboundPacketType_1_14.values());
                Server.loadPacketIds(ClientboundPacketType_1_14_4.values());
                Server.loadPacketIds(ClientboundPacketType_1_15.values());
                Server.loadPacketIds(ClientboundPacketType_1_15_2.values());
                Server.loadPacketIds(ClientboundPacketType_1_16.values());
                Server.loadPacketIds(ClientboundPacketType_1_16_2.values());
                Server.loadPacketIds(ClientboundPacketType_1_17.values());
                Server.loadPacketIds(ClientboundPacketType_1_18.values());
                Server.loadPacketIds(ClientboundPacketType_1_19.values());
                Server.loadPacketIds(ClientboundPacketType_1_19_1.values());
                Server.loadPacketIds(ClientboundPacketType_1_19_3.values());
                Server.loadPacketIds(ClientboundPacketType_1_19_4.values());
                Server.loadPacketIds(ClientboundPacketType_1_20_2.values());
                Server.loadPacketIds(ClientboundPacketType_1_20_3.values());
                Server.loadPacketIds(ClientboundPacketType_1_20_5.values());
                Server.loadPacketIds(ClientboundPacketType_1_21.values());
                Server.loadPacketIds(ClientboundPacketType_1_21_2.values());
                Server.loadPacketIds(ClientboundPacketType_1_21_5.values());
            }

            static {
                INDEX = 0;
                PACKET_TYPE_ID_MAP = new HashMap<Byte, Map<Integer, PacketTypeCommon>>();
            }
        }

        public static enum Client implements PacketTypeCommon,
        ServerBoundPacket
        {
            CHAT_PREVIEW,
            TELEPORT_CONFIRM,
            QUERY_BLOCK_NBT,
            SET_DIFFICULTY,
            CHAT_MESSAGE,
            CLIENT_STATUS,
            CLIENT_SETTINGS,
            TAB_COMPLETE,
            WINDOW_CONFIRMATION,
            CLICK_WINDOW_BUTTON,
            CLICK_WINDOW,
            CLOSE_WINDOW,
            PLUGIN_MESSAGE,
            EDIT_BOOK,
            QUERY_ENTITY_NBT,
            INTERACT_ENTITY,
            GENERATE_STRUCTURE,
            KEEP_ALIVE,
            LOCK_DIFFICULTY,
            PLAYER_POSITION,
            PLAYER_POSITION_AND_ROTATION,
            PLAYER_ROTATION,
            PLAYER_FLYING,
            VEHICLE_MOVE,
            STEER_BOAT,
            PICK_ITEM,
            CRAFT_RECIPE_REQUEST,
            PLAYER_ABILITIES,
            PLAYER_DIGGING,
            ENTITY_ACTION,
            STEER_VEHICLE,
            PONG,
            RECIPE_BOOK_DATA,
            SET_DISPLAYED_RECIPE,
            SET_RECIPE_BOOK_STATE,
            NAME_ITEM,
            RESOURCE_PACK_STATUS,
            ADVANCEMENT_TAB,
            SELECT_TRADE,
            SET_BEACON_EFFECT,
            HELD_ITEM_CHANGE,
            UPDATE_COMMAND_BLOCK,
            UPDATE_COMMAND_BLOCK_MINECART,
            CREATIVE_INVENTORY_ACTION,
            UPDATE_JIGSAW_BLOCK,
            UPDATE_STRUCTURE_BLOCK,
            UPDATE_SIGN,
            ANIMATION,
            SPECTATE,
            PLAYER_BLOCK_PLACEMENT,
            USE_ITEM,
            CHAT_COMMAND,
            CHAT_ACK,
            CHAT_SESSION_UPDATE,
            CHUNK_BATCH_ACK,
            CONFIGURATION_ACK,
            DEBUG_PING,
            SLOT_STATE_CHANGE,
            CHAT_COMMAND_UNSIGNED,
            COOKIE_RESPONSE,
            DEBUG_SAMPLE_SUBSCRIPTION,
            CLIENT_TICK_END,
            SELECT_BUNDLE_ITEM,
            PLAYER_INPUT,
            PICK_ITEM_FROM_BLOCK,
            PICK_ITEM_FROM_ENTITY,
            PLAYER_LOADED,
            SET_TEST_BLOCK,
            TEST_INSTANCE_BLOCK_ACTION;

            private static int INDEX;
            private static final Map<Byte, Map<Integer, PacketTypeCommon>> PACKET_TYPE_ID_MAP;
            private final int[] ids = new int[PacketType.access$300().getVersions().length];

            private Client() {
                Arrays.fill(this.ids, -1);
            }

            @Nullable
            public static PacketTypeCommon getById(ClientVersion version, int packetId) {
                if (!PREPARED) {
                    PacketType.prepare();
                }
                int index = SERVERBOUND_PLAY_VERSION_MAPPER.getIndex(version);
                Map packetIdMap = PACKET_TYPE_ID_MAP.computeIfAbsent((byte)index, k -> new HashMap());
                return (PacketTypeCommon)packetIdMap.get(packetId);
            }

            private static void loadPacketIds(Enum<?>[] enumConstants) {
                int index = INDEX;
                for (Enum<?> constant : enumConstants) {
                    int id = constant.ordinal();
                    Client value = Client.valueOf(constant.name());
                    value.ids[index] = id;
                    Map packetIdMap = PACKET_TYPE_ID_MAP.computeIfAbsent((byte)index, k -> new HashMap());
                    packetIdMap.put(id, value);
                }
                ++INDEX;
            }

            public static void load() {
                INDEX = 0;
                Client.loadPacketIds(ServerboundPacketType_1_7_10.values());
                Client.loadPacketIds(ServerboundPacketType_1_8.values());
                Client.loadPacketIds(ServerboundPacketType_1_9.values());
                Client.loadPacketIds(ServerboundPacketType_1_12.values());
                Client.loadPacketIds(ServerboundPacketType_1_12_1.values());
                Client.loadPacketIds(ServerboundPacketType_1_13.values());
                Client.loadPacketIds(ServerboundPacketType_1_14.values());
                Client.loadPacketIds(ServerboundPacketType_1_15_2.values());
                Client.loadPacketIds(ServerboundPacketType_1_16.values());
                Client.loadPacketIds(ServerboundPacketType_1_16_2.values());
                Client.loadPacketIds(ServerboundPacketType_1_17.values());
                Client.loadPacketIds(ServerboundPacketType_1_19.values());
                Client.loadPacketIds(ServerboundPacketType_1_19_1.values());
                Client.loadPacketIds(ServerboundPacketType_1_19_3.values());
                Client.loadPacketIds(ServerboundPacketType_1_19_4.values());
                Client.loadPacketIds(ServerboundPacketType_1_20_2.values());
                Client.loadPacketIds(ServerboundPacketType_1_20_3.values());
                Client.loadPacketIds(ServerboundPacketType_1_20_5.values());
                Client.loadPacketIds(ServerboundPacketType_1_21_2.values());
                Client.loadPacketIds(ServerboundPacketType_1_21_4.values());
                Client.loadPacketIds(ServerboundPacketType_1_21_5.values());
            }

            @Override
            public int getId(ClientVersion version) {
                if (!PREPARED) {
                    PacketType.prepare();
                }
                int index = SERVERBOUND_PLAY_VERSION_MAPPER.getIndex(version);
                return this.ids[index];
            }

            @Override
            public PacketSide getSide() {
                return PacketSide.CLIENT;
            }

            static {
                INDEX = 0;
                PACKET_TYPE_ID_MAP = new HashMap<Byte, Map<Integer, PacketTypeCommon>>();
            }
        }
    }

    public static class Configuration {

        public static enum Server implements PacketTypeCommon,
        ClientBoundPacket
        {
            PLUGIN_MESSAGE,
            DISCONNECT,
            CONFIGURATION_END,
            KEEP_ALIVE,
            PING,
            REGISTRY_DATA,
            RESOURCE_PACK_SEND,
            UPDATE_ENABLED_FEATURES,
            UPDATE_TAGS,
            RESOURCE_PACK_REMOVE,
            COOKIE_REQUEST,
            RESET_CHAT,
            STORE_COOKIE,
            TRANSFER,
            SELECT_KNOWN_PACKS,
            CUSTOM_REPORT_DETAILS,
            SERVER_LINKS;

            private static int INDEX;
            private static final Map<Byte, Map<Integer, PacketTypeCommon>> PACKET_TYPE_ID_MAP;
            private final int[] ids = new int[PacketType.access$200().getVersions().length];

            private Server() {
                Arrays.fill(this.ids, -1);
            }

            public static void load() {
                INDEX = 0;
                Server.loadPacketIds(ClientboundConfigPacketType_1_20_2.values());
                Server.loadPacketIds(ClientboundConfigPacketType_1_20_3.values());
                Server.loadPacketIds(ClientboundConfigPacketType_1_20_5.values());
                Server.loadPacketIds(ClientboundConfigPacketType_1_21.values());
            }

            private static void loadPacketIds(Enum<?>[] enumConstants) {
                int index = INDEX;
                for (Enum<?> constant : enumConstants) {
                    int id = constant.ordinal();
                    Server value = Server.valueOf(constant.name());
                    value.ids[index] = id;
                    Map packetIdMap = PACKET_TYPE_ID_MAP.computeIfAbsent((byte)index, k -> new HashMap());
                    packetIdMap.put(id, value);
                }
                ++INDEX;
            }

            @Nullable
            public static PacketTypeCommon getById(int packetId) {
                return Server.getById(ClientVersion.getLatest(), packetId);
            }

            @Nullable
            public static PacketTypeCommon getById(ClientVersion version, int packetId) {
                if (!PREPARED) {
                    PacketType.prepare();
                }
                int index = CLIENTBOUND_CONFIG_VERSION_MAPPER.getIndex(version);
                Map<Integer, PacketTypeCommon> map = PACKET_TYPE_ID_MAP.get((byte)index);
                return map.get(packetId);
            }

            @Deprecated
            public int getId() {
                return this.getId(ClientVersion.getLatest());
            }

            @Override
            public int getId(ClientVersion version) {
                if (!PREPARED) {
                    PacketType.prepare();
                }
                int index = CLIENTBOUND_CONFIG_VERSION_MAPPER.getIndex(version);
                return this.ids[index];
            }

            @Override
            public PacketSide getSide() {
                return PacketSide.SERVER;
            }

            static {
                INDEX = 0;
                PACKET_TYPE_ID_MAP = new HashMap<Byte, Map<Integer, PacketTypeCommon>>();
            }
        }

        public static enum Client implements PacketTypeCommon,
        ServerBoundPacket
        {
            CLIENT_SETTINGS,
            PLUGIN_MESSAGE,
            CONFIGURATION_END_ACK,
            KEEP_ALIVE,
            PONG,
            RESOURCE_PACK_STATUS,
            COOKIE_RESPONSE,
            SELECT_KNOWN_PACKS;

            private static int INDEX;
            private static final Map<Byte, Map<Integer, PacketTypeCommon>> PACKET_TYPE_ID_MAP;
            private final int[] ids = new int[PacketType.access$000().getVersions().length];

            private Client() {
                Arrays.fill(this.ids, -1);
            }

            public static void load() {
                INDEX = 0;
                Client.loadPacketIds(ServerboundConfigPacketType_1_20_2.values());
                Client.loadPacketIds(ServerboundConfigPacketType_1_20_5.values());
            }

            private static void loadPacketIds(Enum<?>[] enumConstants) {
                int index = INDEX;
                for (Enum<?> constant : enumConstants) {
                    int id = constant.ordinal();
                    Client value = Client.valueOf(constant.name());
                    value.ids[index] = id;
                    Map packetIdMap = PACKET_TYPE_ID_MAP.computeIfAbsent((byte)index, k -> new HashMap());
                    packetIdMap.put(id, value);
                }
                ++INDEX;
            }

            @Nullable
            public static PacketTypeCommon getById(int packetId) {
                return Client.getById(ClientVersion.getLatest(), packetId);
            }

            @Nullable
            public static PacketTypeCommon getById(ClientVersion version, int packetId) {
                if (!PREPARED) {
                    PacketType.prepare();
                }
                int index = SERVERBOUND_CONFIG_VERSION_MAPPER.getIndex(version);
                Map<Integer, PacketTypeCommon> map = PACKET_TYPE_ID_MAP.get((byte)index);
                return map.get(packetId);
            }

            @Deprecated
            public int getId() {
                return this.getId(ClientVersion.getLatest());
            }

            @Override
            public int getId(ClientVersion version) {
                if (!PREPARED) {
                    PacketType.prepare();
                }
                int index = SERVERBOUND_CONFIG_VERSION_MAPPER.getIndex(version);
                return this.ids[index];
            }

            @Override
            public PacketSide getSide() {
                return PacketSide.CLIENT;
            }

            static {
                INDEX = 0;
                PACKET_TYPE_ID_MAP = new HashMap<Byte, Map<Integer, PacketTypeCommon>>();
            }
        }
    }

    public static class Handshaking {

        public static enum Server implements PacketTypeConstant,
        ClientBoundPacket
        {
            LEGACY_SERVER_LIST_RESPONSE(254);

            private final int id;

            private Server(int id) {
                this.id = id;
            }

            @Nullable
            public static PacketTypeCommon getById(int packetID) {
                return packetID == 254 ? LEGACY_SERVER_LIST_RESPONSE : null;
            }

            @Override
            public int getId() {
                return this.id;
            }

            @Override
            public PacketSide getSide() {
                return PacketSide.SERVER;
            }
        }

        public static enum Client implements PacketTypeConstant,
        ServerBoundPacket
        {
            HANDSHAKE(0),
            LEGACY_SERVER_LIST_PING(254);

            private final int id;

            private Client(int id) {
                this.id = id;
            }

            @Nullable
            public static PacketTypeCommon getById(int packetID) {
                if (packetID == 0) {
                    return HANDSHAKE;
                }
                if (packetID == 254) {
                    return LEGACY_SERVER_LIST_PING;
                }
                return null;
            }

            @Override
            public int getId() {
                return this.id;
            }

            @Override
            public PacketSide getSide() {
                return PacketSide.CLIENT;
            }
        }
    }

    public static class Status {

        public static enum Server implements PacketTypeConstant,
        ClientBoundPacket
        {
            RESPONSE(0),
            PONG(1);

            private final int id;

            private Server(int id) {
                this.id = id;
            }

            @Nullable
            public static PacketTypeCommon getById(int packetID) {
                if (packetID == 0) {
                    return RESPONSE;
                }
                if (packetID == 1) {
                    return PONG;
                }
                return null;
            }

            @Override
            public int getId() {
                return this.id;
            }

            @Override
            public PacketSide getSide() {
                return PacketSide.SERVER;
            }
        }

        public static enum Client implements PacketTypeConstant,
        ServerBoundPacket
        {
            REQUEST(0),
            PING(1);

            private final int id;

            private Client(int id) {
                this.id = id;
            }

            @Nullable
            public static PacketTypeCommon getById(int packetId) {
                if (packetId == 0) {
                    return REQUEST;
                }
                if (packetId == 1) {
                    return PING;
                }
                return null;
            }

            @Override
            public int getId() {
                return this.id;
            }

            @Override
            public PacketSide getSide() {
                return PacketSide.CLIENT;
            }
        }
    }

    public static class Login {

        public static enum Server implements PacketTypeConstant,
        ClientBoundPacket
        {
            DISCONNECT(0),
            ENCRYPTION_REQUEST(1),
            LOGIN_SUCCESS(2),
            SET_COMPRESSION(3),
            LOGIN_PLUGIN_REQUEST(4),
            COOKIE_REQUEST(5);

            private final int id;

            private Server(int id) {
                this.id = id;
            }

            @Nullable
            public static PacketTypeCommon getById(int packetID) {
                switch (packetID) {
                    case 0: {
                        return DISCONNECT;
                    }
                    case 1: {
                        return ENCRYPTION_REQUEST;
                    }
                    case 2: {
                        return LOGIN_SUCCESS;
                    }
                    case 3: {
                        return SET_COMPRESSION;
                    }
                    case 4: {
                        return LOGIN_PLUGIN_REQUEST;
                    }
                    case 5: {
                        return COOKIE_REQUEST;
                    }
                }
                return null;
            }

            @Override
            public int getId() {
                return this.id;
            }

            @Override
            public PacketSide getSide() {
                return PacketSide.SERVER;
            }
        }

        public static enum Client implements PacketTypeConstant,
        ServerBoundPacket
        {
            LOGIN_START(0),
            ENCRYPTION_RESPONSE(1),
            LOGIN_PLUGIN_RESPONSE(2),
            LOGIN_SUCCESS_ACK(3),
            COOKIE_RESPONSE(4);

            private final int id;

            private Client(int id) {
                this.id = id;
            }

            @Nullable
            public static PacketTypeCommon getById(int packetID) {
                switch (packetID) {
                    case 0: {
                        return LOGIN_START;
                    }
                    case 1: {
                        return ENCRYPTION_RESPONSE;
                    }
                    case 2: {
                        return LOGIN_PLUGIN_RESPONSE;
                    }
                    case 3: {
                        return LOGIN_SUCCESS_ACK;
                    }
                    case 4: {
                        return COOKIE_RESPONSE;
                    }
                }
                return null;
            }

            @Override
            public int getId() {
                return this.id;
            }

            @Override
            public PacketSide getSide() {
                return PacketSide.CLIENT;
            }
        }
    }
}

