/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.resources.ResourceLocation;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings.IRegistry;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings.MappingHelper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings.TypesBuilder;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import ac.grim.grimac.shaded.jetbrains.annotations.ApiStatus;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.shaded.jetbrains.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public final class VersionedRegistry<T extends MappedEntity>
implements IRegistry<T> {
    private final ResourceLocation registryKey;
    private final TypesBuilder typesBuilder;
    private final Map<String, T> typeMap = new HashMap<String, T>();
    private final Map<Byte, Map<Integer, T>> typeIdMap = new HashMap<Byte, Map<Integer, T>>();

    public VersionedRegistry(String registry) {
        this(registry, "registries/" + registry);
    }

    public VersionedRegistry(String registry, String mappingsPath) {
        this(new ResourceLocation(registry), mappingsPath);
    }

    public VersionedRegistry(ResourceLocation registryKey, String mappingsPath) {
        this.registryKey = registryKey;
        this.typesBuilder = new TypesBuilder(mappingsPath);
        this.typesBuilder.registry = this;
    }

    @ApiStatus.Internal
    public <Z extends T> Z define(String name, Function<TypesBuilderData, Z> builder) {
        TypesBuilderData typeData = this.typesBuilder.define(name);
        MappedEntity instance = (MappedEntity)builder.apply(typeData);
        MappingHelper.registerMapping(this.typesBuilder, this.typeMap, this.typeIdMap, typeData, instance);
        return (Z)instance;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public TypesBuilder getTypesBuilder() {
        return this.typesBuilder;
    }

    @ApiStatus.Internal
    public void unloadMappings() {
        this.typesBuilder.unloadFileMappings();
    }

    @Override
    @Nullable
    public T getByName(ResourceLocation name) {
        return (T)((MappedEntity)this.typeMap.get(name.toString()));
    }

    @Override
    @Nullable
    public T getByName(String name) {
        return (T)((MappedEntity)this.typeMap.get(ResourceLocation.normString(name)));
    }

    @Override
    @Nullable
    public T getById(ClientVersion version, int id) {
        int index = this.typesBuilder.getDataIndex(version);
        Map<Integer, T> idMap = this.typeIdMap.get((byte)index);
        return (T)((MappedEntity)idMap.get(id));
    }

    @Override
    public int getId(MappedEntity entity, ClientVersion version) {
        return entity.getId(version);
    }

    @Override
    public Collection<T> getEntries() {
        return Collections.unmodifiableCollection(this.typeMap.values());
    }

    @Override
    public int size() {
        return this.typeMap.size();
    }

    @Override
    public ResourceLocation getRegistryKey() {
        return this.registryKey;
    }

    public String toString() {
        return "VersionedRegistry[" + this.registryKey + ']';
    }
}

