/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.configuralize;

import ac.grim.grimac.shaded.configuralize.DynamicConfig;
import ac.grim.grimac.shaded.configuralize.ParseException;
import ac.grim.grimac.shaded.configuralize.Source;
import ac.grim.grimac.shaded.maps.weak.Dynamic;
import ac.grim.grimac.shaded.snakeyaml.parser.ParserException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Objects;

public class Provider {
    private final DynamicConfig config;
    private final Source source;
    private Dynamic defaults;
    private Dynamic values;

    private static Dynamic load(DynamicConfig config, Source source, String raw) throws ParseException {
        Map parsed;
        block5: {
            if (raw == null) {
                throw new IllegalArgumentException("Can't load null config");
            }
            String extension = source.getFile().getName().substring(source.getFile().getName().lastIndexOf(".") + 1);
            try {
                if (extension.equalsIgnoreCase("yml")) {
                    parsed = config.getYamlParser().loadAs(raw, Map.class);
                    break block5;
                }
                if (extension.equalsIgnoreCase("json")) {
                    parsed = (Map)config.getJsonParser().parse(raw);
                    break block5;
                }
                throw new IllegalArgumentException("Config source extension " + extension + " is not supported");
            }
            catch (ac.grim.grimac.shaded.json.simple.parser.ParseException | ParserException e) {
                throw new ParseException(source, (Throwable)e);
            }
        }
        return Dynamic.from(parsed);
    }

    public Provider(DynamicConfig config, Source source) {
        this.config = config;
        this.source = source;
    }

    public void load() throws IOException, ParseException {
        this.defaults = this.loadResource();
        this.values = this.loadValues();
    }

    public Dynamic loadValues() throws ParseException, IOException {
        return Provider.load(this.config, this.source, new String(Files.readAllBytes(this.source.getFile().toPath())));
    }

    /*
     * Exception decompiling
     */
    public Dynamic loadResource() throws ParseException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void saveDefaults() throws IOException {
        this.saveDefaults(false);
    }

    public void saveDefaults(boolean overwrite) throws IOException {
        if (this.source.getFile().exists() && !overwrite) {
            return;
        }
        if (!this.source.getFile().getParentFile().exists() && !this.source.getFile().getParentFile().mkdirs()) {
            throw new IOException("Failed to create directory " + this.source.getFile().getParentFile().getAbsolutePath());
        }
        String resource = this.source.getResourcePath(this.config.getLanguage());
        try (InputStream stream = this.source.getResource().openStream();){
            Objects.requireNonNull(stream, "Unknown resource " + this.source.getResourcePath(this.config.getLanguage()));
            Files.copy(stream, this.source.getFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public DynamicConfig getConfig() {
        return this.config;
    }

    public Source getSource() {
        return this.source;
    }

    public Dynamic getDefaults() {
        return this.defaults;
    }

    public Dynamic getValues() {
        return this.values;
    }
}

