/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.io.github.retrooper.packetevents.bukkit;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.User;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.FakeChannelUtil;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.injector.SpigotChannelInjector;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public class InternalBukkitListener
implements Listener {
    private final Plugin plugin;

    public InternalBukkitListener(Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSpawnInGame(PlayerSpawnLocationEvent e) {
        Player player = e.getPlayer();
        SpigotChannelInjector injector = (SpigotChannelInjector)PacketEvents.getAPI().getInjector();
        User user = PacketEvents.getAPI().getPlayerManager().getUser(player);
        if (user == null) {
            Object channel = PacketEvents.getAPI().getPlayerManager().getChannel(player);
            if (channel == null) {
                return;
            }
            if (!(FakeChannelUtil.isFakeChannel(channel) || PacketEvents.getAPI().isTerminated() && !PacketEvents.getAPI().getSettings().isKickIfTerminated())) {
                FoliaScheduler.getEntityScheduler().runDelayed((Entity)player, this.plugin, o -> player.kickPlayer("PacketEvents 2.0 failed to inject"), null, 0L);
            }
            return;
        }
        injector.updatePlayer(user, player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        Object channel = PacketEvents.getAPI().getPlayerManager().getChannel(player);
        SpigotChannelInjector injector = (SpigotChannelInjector)PacketEvents.getAPI().getInjector();
        User user = PacketEvents.getAPI().getPlayerManager().getUser(player);
        if (user == null) {
            if (channel == null || !FakeChannelUtil.isFakeChannel(channel) && (!PacketEvents.getAPI().isTerminated() || PacketEvents.getAPI().getSettings().isKickIfTerminated())) {
                FoliaScheduler.getEntityScheduler().runDelayed((Entity)player, this.plugin, o -> player.kickPlayer("PacketEvents 2.0 failed to inject"), null, 0L);
            }
            return;
        }
        if (!injector.isPlayerSet(channel)) {
            injector.updatePlayer(user, player);
        }
    }
}

