/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.anticheat;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.shaded.kyori.adventure.text.Component;
import ac.grim.grimac.utils.anticheat.MessageUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public final class LogUtil {
    public static void info(String info) {
        LogUtil.getLogger().info(info);
    }

    public static void warn(String warn) {
        LogUtil.getLogger().warning(warn);
    }

    public static void error(String error) {
        LogUtil.getLogger().severe(error);
    }

    public static void error(String description, Throwable throwable) {
        LogUtil.getLogger().severe(description);
        throwable.printStackTrace();
    }

    public static Logger getLogger() {
        return GrimAPI.INSTANCE.getPlugin().getLogger();
    }

    public static void console(String info) {
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)info));
    }

    public static void console(Component info) {
        MessageUtil.sendMessage((CommandSender)Bukkit.getConsoleSender(), info);
    }

    public static void exception(String description, Throwable throwable) {
        LogUtil.getLogger().severe(description + ": " + LogUtil.getStackTrace(throwable));
    }

    private static String getStackTrace(Throwable throwable) {
        String message = throwable.getMessage();
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            throwable.printStackTrace(pw);
            message = sw.toString();
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        return message;
    }

    private LogUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

