/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.anticheat;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3f;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.reflection.Reflection;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.shaded.kyori.adventure.platform.bukkit.BukkitAudiences;
import ac.grim.grimac.shaded.kyori.adventure.text.Component;
import ac.grim.grimac.shaded.kyori.adventure.text.TextReplacementConfig;
import ac.grim.grimac.shaded.kyori.adventure.text.minimessage.MiniMessage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public final class MessageUtil {
    private static final Pattern HEX_PATTERN = Pattern.compile("([&\u00a7]#[A-Fa-f0-9]{6})|([&\u00a7]x([&\u00a7][A-Fa-f0-9]){6})");
    private static final BukkitAudiences adventure = BukkitAudiences.create((Plugin)GrimAPI.INSTANCE.getPlugin());
    public static final boolean hasPlaceholderAPI = Reflection.getClassByNameWithoutException("me.clip.placeholderapi.PlaceholderAPI") != null;

    @NotNull
    public static String toUnlabledString(@Nullable Vector3i vec) {
        return vec == null ? "null" : vec.x + ", " + vec.y + ", " + vec.z;
    }

    @NotNull
    public static String toUnlabledString(@Nullable Vector3f vec) {
        return vec == null ? "null" : vec.x + ", " + vec.y + ", " + vec.z;
    }

    @NotNull
    public static String replacePlaceholders(@NotNull GrimPlayer player, @NotNull String string) {
        return MessageUtil.replacePlaceholders(player.bukkitPlayer, GrimAPI.INSTANCE.getExternalAPI().replaceVariables(player, string));
    }

    @NotNull
    public static String replacePlaceholders(@Nullable Object object, @NotNull String string) {
        OfflinePlayer player;
        if (!hasPlaceholderAPI) {
            return string;
        }
        return PlaceholderAPI.setPlaceholders(object instanceof OfflinePlayer ? (player = (OfflinePlayer)object) : null, (String)string);
    }

    @NotNull
    public static Component replacePlaceholders(@NotNull GrimPlayer player, @NotNull Component component) {
        TextReplacementConfig safeReplacement = (TextReplacementConfig)TextReplacementConfig.builder().match("%[a-zA-Z0-9_]+%").replacement(placeholder -> Component.text(MessageUtil.replacePlaceholders(player, placeholder.content()))).build();
        return component.replaceText(safeReplacement);
    }

    @NotNull
    public static Component miniMessage(@NotNull String string) {
        string = string.replace("%prefix%", GrimAPI.INSTANCE.getConfigManager().getConfig().getStringElse("prefix", "&bGrim &8\u00bb"));
        Matcher matcher = HEX_PATTERN.matcher(string);
        StringBuilder sb = new StringBuilder(string.length());
        while (matcher.find()) {
            matcher.appendReplacement(sb, "<#" + matcher.group(0).replaceAll("[&\u00a7#x]", "") + ">");
        }
        string = matcher.appendTail(sb).toString();
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string).replace("\u00a70", "<!b><!i><!u><!st><!obf><black>").replace("\u00a71", "<!b><!i><!u><!st><!obf><dark_blue>").replace("\u00a72", "<!b><!i><!u><!st><!obf><dark_green>").replace("\u00a73", "<!b><!i><!u><!st><!obf><dark_aqua>").replace("\u00a74", "<!b><!i><!u><!st><!obf><dark_red>").replace("\u00a75", "<!b><!i><!u><!st><!obf><dark_purple>").replace("\u00a76", "<!b><!i><!u><!st><!obf><gold>").replace("\u00a77", "<!b><!i><!u><!st><!obf><gray>").replace("\u00a78", "<!b><!i><!u><!st><!obf><dark_gray>").replace("\u00a79", "<!b><!i><!u><!st><!obf><blue>").replace("\u00a7a", "<!b><!i><!u><!st><!obf><green>").replace("\u00a7b", "<!b><!i><!u><!st><!obf><aqua>").replace("\u00a7c", "<!b><!i><!u><!st><!obf><red>").replace("\u00a7d", "<!b><!i><!u><!st><!obf><light_purple>").replace("\u00a7e", "<!b><!i><!u><!st><!obf><yellow>").replace("\u00a7f", "<!b><!i><!u><!st><!obf><white>").replace("\u00a7r", "<reset>").replace("\u00a7k", "<obfuscated>").replace("\u00a7l", "<bold>").replace("\u00a7m", "<strikethrough>").replace("\u00a7n", "<underlined>").replace("\u00a7o", "<italic>");
        return MiniMessage.miniMessage().deserialize(string).compact();
    }

    public static void sendMessage(@NotNull CommandSender commandSender, @NotNull Component component) {
        adventure.sender(commandSender).sendMessage(component);
    }

    private MessageUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

