/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.blockstate.helper;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import org.bukkit.util.Vector;

public class BlockFaceHelper {
    public static boolean isFaceVertical(BlockFace face) {
        return face == BlockFace.UP || face == BlockFace.DOWN;
    }

    public static boolean isFaceHorizontal(BlockFace face) {
        return face == BlockFace.NORTH || face == BlockFace.EAST || face == BlockFace.SOUTH || face == BlockFace.WEST;
    }

    @Deprecated
    public static BlockFace fromBukkitFace(org.bukkit.block.BlockFace face) {
        return switch (face) {
            case org.bukkit.block.BlockFace.NORTH -> BlockFace.NORTH;
            case org.bukkit.block.BlockFace.SOUTH -> BlockFace.SOUTH;
            case org.bukkit.block.BlockFace.WEST -> BlockFace.WEST;
            case org.bukkit.block.BlockFace.EAST -> BlockFace.EAST;
            case org.bukkit.block.BlockFace.UP -> BlockFace.UP;
            case org.bukkit.block.BlockFace.DOWN -> BlockFace.DOWN;
            default -> BlockFace.OTHER;
        };
    }

    public static BlockFace getClockWise(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> BlockFace.EAST;
            case BlockFace.SOUTH -> BlockFace.WEST;
            case BlockFace.WEST -> BlockFace.NORTH;
            default -> BlockFace.SOUTH;
        };
    }

    public static BlockFace getPEClockWise(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> BlockFace.EAST;
            case BlockFace.SOUTH -> BlockFace.WEST;
            case BlockFace.WEST -> BlockFace.NORTH;
            default -> BlockFace.SOUTH;
        };
    }

    public static BlockFace getCounterClockwise(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> BlockFace.WEST;
            case BlockFace.SOUTH -> BlockFace.EAST;
            case BlockFace.WEST -> BlockFace.SOUTH;
            default -> BlockFace.NORTH;
        };
    }

    public Vector offset(Vector toOffset, BlockFace face) {
        toOffset.setX(toOffset.getX() + (double)face.getModX());
        toOffset.setY(toOffset.getY() + (double)face.getModY());
        toOffset.setZ(toOffset.getZ() + (double)face.getModZ());
        return toOffset;
    }
}

