/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.collisions;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.utils.collisions.AxisSelect;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;

public enum AxisUtil {
    EAST(box -> {
        box.maxX = 1.0;
        return box;
    }),
    WEST(box -> {
        box.minX = 0.0;
        return box;
    }),
    NORTH(box -> {
        box.minZ = 0.0;
        return box;
    }),
    SOUTH(box -> {
        box.maxZ = 1.0;
        return box;
    }),
    UP(box -> {
        box.minY = 0.0;
        return box;
    }),
    DOWN(box -> {
        box.maxY = 1.0;
        return box;
    });

    AxisSelect select;

    private AxisUtil(AxisSelect select) {
        this.select = select;
    }

    public static SimpleCollisionBox combine(SimpleCollisionBox base, SimpleCollisionBox toMerge) {
        boolean insideZ;
        boolean insideX = toMerge.minX <= base.minX && toMerge.maxX >= base.maxX;
        boolean insideY = toMerge.minY <= base.minY && toMerge.maxY >= base.maxY;
        boolean bl = insideZ = toMerge.minZ <= base.minZ && toMerge.maxZ >= base.maxZ;
        if (insideX && insideY && !insideZ) {
            return new SimpleCollisionBox(base.minX, base.maxY, Math.min(base.minZ, toMerge.minZ), base.minX, base.maxY, Math.max(base.maxZ, toMerge.maxZ));
        }
        if (insideX && !insideY && insideZ) {
            return new SimpleCollisionBox(base.minX, Math.min(base.minY, toMerge.minY), base.minZ, base.maxX, Math.max(base.maxY, toMerge.maxY), base.maxZ);
        }
        if (!insideX && insideY && insideZ) {
            return new SimpleCollisionBox(Math.min(base.minX, toMerge.maxX), base.minY, base.maxZ, Math.max(base.minX, toMerge.minX), base.minY, base.maxZ);
        }
        return base;
    }

    public static AxisSelect getAxis(BlockFace face) {
        return switch (face) {
            case BlockFace.EAST -> AxisUtil.EAST.select;
            case BlockFace.WEST -> AxisUtil.WEST.select;
            case BlockFace.NORTH -> AxisUtil.NORTH.select;
            case BlockFace.SOUTH -> AxisUtil.SOUTH.select;
            case BlockFace.UP -> AxisUtil.UP.select;
            default -> AxisUtil.DOWN.select;
        };
    }

    public static boolean isSameAxis(BlockFace one, BlockFace two) {
        return switch (one) {
            case BlockFace.EAST, BlockFace.WEST -> {
                if (two == BlockFace.WEST || two == BlockFace.EAST) {
                    yield true;
                }
                yield false;
            }
            case BlockFace.NORTH, BlockFace.SOUTH -> {
                if (two == BlockFace.NORTH || two == BlockFace.SOUTH) {
                    yield true;
                }
                yield false;
            }
            case BlockFace.UP, BlockFace.DOWN -> {
                if (two == BlockFace.UP || two == BlockFace.DOWN) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

