/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.collisions.datatypes;

import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import org.bukkit.util.Vector;

public class BoundingBox {
    public float minX;
    public float minY;
    public float minZ;
    public float maxX;
    public float maxY;
    public float maxZ;

    public BoundingBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public BoundingBox(Vector min, Vector max) {
        this.minX = (float)Math.min(min.getX(), max.getX());
        this.minY = (float)Math.min(min.getY(), max.getY());
        this.minZ = (float)Math.min(min.getZ(), max.getZ());
        this.maxX = (float)Math.max(min.getX(), max.getX());
        this.maxY = (float)Math.max(min.getY(), max.getY());
        this.maxZ = (float)Math.max(min.getZ(), max.getZ());
    }

    public BoundingBox(BoundingBox one, BoundingBox two) {
        this.minX = Math.min(one.minX, two.minX);
        this.minY = Math.min(one.minY, two.minY);
        this.minZ = Math.min(one.minZ, two.minZ);
        this.maxX = Math.max(one.maxX, two.maxX);
        this.maxY = Math.max(one.maxY, two.maxY);
        this.maxZ = Math.max(one.maxZ, two.maxZ);
    }

    public BoundingBox add(float x, float y, float z) {
        float newMinX = this.minX + x;
        float newMaxX = this.maxX + x;
        float newMinY = this.minY + y;
        float newMaxY = this.maxY + y;
        float newMinZ = this.minZ + z;
        float newMaxZ = this.maxZ + z;
        return new BoundingBox(newMinX, newMinY, newMinZ, newMaxX, newMaxY, newMaxZ);
    }

    public BoundingBox add(Vector vector) {
        float x = (float)vector.getX();
        float y = (float)vector.getY();
        float z = (float)vector.getZ();
        float newMinX = this.minX + x;
        float newMaxX = this.maxX + x;
        float newMinY = this.minY + y;
        float newMaxY = this.maxY + y;
        float newMinZ = this.minZ + z;
        float newMaxZ = this.maxZ + z;
        return new BoundingBox(newMinX, newMinY, newMinZ, newMaxX, newMaxY, newMaxZ);
    }

    public BoundingBox grow(float x, float y, float z) {
        float newMinX = this.minX - x;
        float newMaxX = this.maxX + x;
        float newMinY = this.minY - y;
        float newMaxY = this.maxY + y;
        float newMinZ = this.minZ - z;
        float newMaxZ = this.maxZ + z;
        return new BoundingBox(newMinX, newMinY, newMinZ, newMaxX, newMaxY, newMaxZ);
    }

    public BoundingBox shrink(float x, float y, float z) {
        float newMinX = this.minX + x;
        float newMaxX = this.maxX - x;
        float newMinY = this.minY + y;
        float newMaxY = this.maxY - y;
        float newMinZ = this.minZ + z;
        float newMaxZ = this.maxZ - z;
        return new BoundingBox(newMinX, newMinY, newMinZ, newMaxX, newMaxY, newMaxZ);
    }

    public BoundingBox add(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return new BoundingBox(this.minX + minX, this.minY + minY, this.minZ + minZ, this.maxX + maxX, this.maxY + maxY, this.maxZ + maxZ);
    }

    public BoundingBox subtract(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return new BoundingBox(this.minX - minX, this.minY - minY, this.minZ - minZ, this.maxX - maxX, this.maxY - maxY, this.maxZ - maxZ);
    }

    public boolean intersectsWithBox(Vector vector) {
        return vector.getX() > (double)this.minX && vector.getX() < (double)this.maxX && vector.getY() > (double)this.minY && vector.getY() < (double)this.maxY && vector.getZ() > (double)this.minZ && vector.getZ() < (double)this.maxZ;
    }

    public Vector getMinimum() {
        return new Vector(this.minX, this.minY, this.minZ);
    }

    public Vector getMaximum() {
        return new Vector(this.maxX, this.maxY, this.maxZ);
    }

    public boolean collides(Vector vector) {
        return vector.getX() >= (double)this.minX && vector.getX() <= (double)this.maxX && vector.getY() >= (double)this.minY && vector.getY() <= (double)this.maxY && vector.getZ() >= (double)this.minZ && vector.getZ() <= (double)this.maxZ;
    }

    public boolean collidesHorizontally(Vector vector) {
        return vector.getX() >= (double)this.minX && vector.getX() <= (double)this.maxX && vector.getY() > (double)this.minY && vector.getY() < (double)this.maxY && vector.getZ() >= (double)this.minZ && vector.getZ() <= (double)this.maxZ;
    }

    public boolean collidesVertically(Vector vector) {
        return vector.getX() > (double)this.minX && vector.getX() < (double)this.maxX && vector.getY() >= (double)this.minY && vector.getY() <= (double)this.maxY && vector.getZ() > (double)this.minZ && vector.getZ() < (double)this.maxZ;
    }

    public double calculateXOffset(BoundingBox other, double offsetX) {
        if (other.maxY > this.minY && other.minY < this.maxY && other.maxZ > this.minZ && other.minZ < this.maxZ) {
            double d0;
            if (offsetX > 0.0 && other.maxX <= this.minX) {
                double d1 = this.minX - other.maxX;
                if (d1 < offsetX) {
                    offsetX = d1;
                }
            } else if (offsetX < 0.0 && other.minX >= this.maxX && (d0 = (double)(this.maxX - other.minX)) > offsetX) {
                offsetX = d0;
            }
            return offsetX;
        }
        return offsetX;
    }

    public double calculateYOffset(BoundingBox other, double offsetY) {
        if (other.maxX > this.minX && other.minX < this.maxX && other.maxZ > this.minZ && other.minZ < this.maxZ) {
            double d0;
            if (offsetY > 0.0 && other.maxY <= this.minY) {
                double d1 = this.minY - other.maxY;
                if (d1 < offsetY) {
                    offsetY = d1;
                }
            } else if (offsetY < 0.0 && other.minY >= this.maxY && (d0 = (double)(this.maxY - other.minY)) > offsetY) {
                offsetY = d0;
            }
            return offsetY;
        }
        return offsetY;
    }

    public double calculateZOffset(BoundingBox other, double offsetZ) {
        if (other.maxX > this.minX && other.minX < this.maxX && other.maxY > this.minY && other.minY < this.maxY) {
            double d0;
            if (offsetZ > 0.0 && other.maxZ <= this.minZ) {
                double d1 = this.minZ - other.maxZ;
                if (d1 < offsetZ) {
                    offsetZ = d1;
                }
            } else if (offsetZ < 0.0 && other.minZ >= this.maxZ && (d0 = (double)(this.maxZ - other.minZ)) > offsetZ) {
                offsetZ = d0;
            }
            return offsetZ;
        }
        return offsetZ;
    }

    public BoundingBox addCoord(float x, float y, float z) {
        float d0 = this.minX;
        float d1 = this.minY;
        float d2 = this.minZ;
        float d3 = this.maxX;
        float d4 = this.maxY;
        float d5 = this.maxZ;
        if ((double)x < 0.0) {
            d0 += x;
        } else if ((double)x > 0.0) {
            d3 += x;
        }
        if ((double)y < 0.0) {
            d1 += y;
        } else if ((double)y > 0.0) {
            d4 += y;
        }
        if ((double)z < 0.0) {
            d2 += z;
        } else if ((double)z > 0.0) {
            d5 += z;
        }
        return new BoundingBox(d0, d1, d2, d3, d4, d5);
    }

    public SimpleCollisionBox toCollisionBox() {
        return new SimpleCollisionBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public String toString() {
        return "[" + this.minX + ", " + this.minY + ", " + this.minZ + ", " + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }
}

