/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.data.packetentity;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;

public abstract class TypedPacketEntity {
    private final EntityType type;
    private final boolean isLiving;
    private final boolean isMinecart;
    private final boolean isHorse;
    private final boolean isAgeable;
    private final boolean isAnimal;
    private final boolean isBoat;

    public TypedPacketEntity(EntityType type) {
        this.type = type;
        this.isLiving = EntityTypes.isTypeInstanceOf(type, EntityTypes.LIVINGENTITY);
        this.isMinecart = EntityTypes.isTypeInstanceOf(type, EntityTypes.MINECART_ABSTRACT);
        this.isHorse = EntityTypes.isTypeInstanceOf(type, EntityTypes.ABSTRACT_HORSE);
        this.isAgeable = EntityTypes.isTypeInstanceOf(type, EntityTypes.ABSTRACT_AGEABLE);
        this.isAnimal = EntityTypes.isTypeInstanceOf(type, EntityTypes.ABSTRACT_ANIMAL);
        this.isBoat = EntityTypes.isTypeInstanceOf(type, EntityTypes.BOAT);
    }

    public boolean isLivingEntity() {
        return this.isLiving;
    }

    public boolean isMinecart() {
        return this.isMinecart;
    }

    public boolean isHorse() {
        return this.isHorse;
    }

    public boolean isAgeable() {
        return this.isAgeable;
    }

    public boolean isAnimal() {
        return this.isAnimal;
    }

    public boolean isBoat() {
        return this.isBoat;
    }

    public boolean isPushable() {
        if (this.type == EntityTypes.ARMOR_STAND || this.type == EntityTypes.BAT || this.type == EntityTypes.PARROT) {
            return false;
        }
        return this.isLiving || this.isBoat || this.isMinecart;
    }

    public EntityType getType() {
        return this.type;
    }
}

