/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.nmsutil;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public final class BukkitNMS {
    @NotNull
    private static final ItemUsageReset resetItemUsage = BukkitNMS.createItemUsageResetFunction();

    public static void resetItemUsage(@Nullable Player player) {
        if (player != null) {
            resetItemUsage.accept(player);
        }
    }

    @NotNull
    private static ItemUsageReset createItemUsageResetFunction() {
        ServerVersion version = PacketEvents.getAPI().getServerManager().getVersion();
        if (version.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            if (version.isOlderThan(ServerVersion.V_1_19)) {
                return LivingEntity::clearActiveItem;
            }
            Method setLivingEntityFlag = Class.forName(version.isOlderThan(ServerVersion.V_1_20_5) ? "net.minecraft.world.entity.EntityLiving" : "net.minecraft.world.entity.LivingEntity").getDeclaredMethod(version.isOlderThan(ServerVersion.V_1_20_5) ? "c" : "setLivingEntityFlag", Integer.TYPE, Boolean.TYPE);
            Method getHandle = (version.isOlderThan(ServerVersion.V_1_20_5) ? Class.forName("org.bukkit.craftbukkit." + Bukkit.getServer().getClass().getPackageName().split("\\.")[3] + ".entity.CraftPlayer") : Class.forName("org.bukkit.craftbukkit.entity.CraftPlayer")).getMethod("getHandle", new Class[0]);
            setLivingEntityFlag.setAccessible(true);
            return player -> {
                setLivingEntityFlag.invoke(getHandle.invoke((Object)player, new Object[0]), 1, false);
                player.clearActiveItem();
            };
        }
        if (version == ServerVersion.V_1_8_8) {
            Class<?> EntityHuman = Class.forName("net.minecraft.server.v1_8_R3.EntityHuman");
            Method getHandle = Class.forName("org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer").getMethod("getHandle", new Class[0]);
            Method clearActiveItem = EntityHuman.getMethod("bV", new Class[0]);
            Method isUsingItem = EntityHuman.getMethod("bS", new Class[0]);
            return player -> {
                Object handle = getHandle.invoke((Object)player, new Object[0]);
                clearActiveItem.invoke(handle, new Object[0]);
                if (((Boolean)isUsingItem.invoke(handle, new Object[0])).booleanValue()) {
                    player.updateInventory();
                }
            };
        }
        String nmsPackage = Bukkit.getServer().getClass().getPackageName().split("\\.")[3];
        Method getHandle = Class.forName("org.bukkit.craftbukkit." + nmsPackage + ".entity.CraftPlayer").getMethod("getHandle", new Class[0]);
        Class<?> clazz = Class.forName("net.minecraft.server." + nmsPackage + ".EntityLiving");
        Method clearActiveItem = clazz.getMethod(switch (nmsPackage) {
            case "v1_9_R1" -> "cz";
            case "v1_9_R2" -> "cA";
            case "v1_10_R1" -> "cE";
            case "v1_11_R1" -> "cF";
            case "v1_12_R1" -> "cN";
            case "v1_13_R1", "v1_13_R2" -> "da";
            case "v1_14_R1" -> "dp";
            case "v1_15_R1" -> "dH";
            case "v1_16_R1", "v1_16_R2", "v1_16_R3" -> "clearActiveItem";
            default -> throw new IllegalStateException("You are using an unsupported server version! (" + version.getReleaseName() + ")");
        }, new Class[0]);
        return player -> clearActiveItem.invoke(getHandle.invoke((Object)player, new Object[0]), new Object[0]);
    }

    private BukkitNMS() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static interface ItemUsageReset {
        public void accept(@NotNull Player var1) throws Throwable;
    }
}

