/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.nmsutil;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.attribute.Attributes;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.nmsutil.BoundingBoxSize;

public class GetBoundingBox {
    public static SimpleCollisionBox getCollisionBoxForPlayer(GrimPlayer player, double centerX, double centerY, double centerZ) {
        if (player.inVehicle()) {
            return GetBoundingBox.getPacketEntityBoundingBox(player, centerX, centerY, centerZ, player.compensatedEntities.self.getRiding());
        }
        return GetBoundingBox.getPlayerBoundingBox(player, centerX, centerY, centerZ);
    }

    public static SimpleCollisionBox getPacketEntityBoundingBox(GrimPlayer player, double centerX, double minY, double centerZ, PacketEntity entity) {
        float width = BoundingBoxSize.getWidth(player, entity);
        float height = BoundingBoxSize.getHeight(player, entity);
        return GetBoundingBox.getBoundingBoxFromPosAndSize(entity, centerX, minY, centerZ, width, height);
    }

    public static SimpleCollisionBox getPlayerBoundingBox(GrimPlayer player, double centerX, double minY, double centerZ) {
        float width = player.pose.width;
        float height = player.pose.height;
        return GetBoundingBox.getBoundingBoxFromPosAndSize(player, centerX, minY, centerZ, width, height);
    }

    public static SimpleCollisionBox getBoundingBoxFromPosAndSize(GrimPlayer player, double centerX, double minY, double centerZ, float width, float height) {
        return GetBoundingBox.getBoundingBoxFromPosAndSize(player.compensatedEntities.self, centerX, minY, centerZ, width, height);
    }

    public static SimpleCollisionBox getBoundingBoxFromPosAndSize(PacketEntity entity, double centerX, double minY, double centerZ, float width, float height) {
        float scale = (float)entity.getAttributeValue(Attributes.SCALE);
        return GetBoundingBox.getBoundingBoxFromPosAndSizeRaw(centerX, minY, centerZ, width * scale, height * scale);
    }

    public static SimpleCollisionBox getBoundingBoxFromPosAndSizeRaw(double centerX, double minY, double centerZ, float width, float height) {
        double minX = centerX - (double)(width / 2.0f);
        double maxX = centerX + (double)(width / 2.0f);
        double maxY = minY + (double)height;
        double minZ = centerZ - (double)(width / 2.0f);
        double maxZ = centerZ + (double)(width / 2.0f);
        return new SimpleCollisionBox(minX, minY, minZ, maxX, maxY, maxZ, false);
    }

    public static double[] getEntityDimensions(GrimPlayer player, PacketEntity entity) {
        float scale = (float)entity.getAttributeValue(Attributes.SCALE);
        float width = BoundingBoxSize.getWidth(player, entity) * scale;
        float height = BoundingBoxSize.getHeight(player, entity) * scale;
        return new double[]{width, height, width};
    }

    public static void expandBoundingBoxByEntityDimensions(SimpleCollisionBox box, GrimPlayer player, PacketEntity entity) {
        double[] dimensions = GetBoundingBox.getEntityDimensions(player, entity);
        double halfWidth = dimensions[0] / 2.0;
        double height = dimensions[1];
        double halfDepth = dimensions[2] / 2.0;
        box.minX -= halfWidth;
        box.minY -= 0.0;
        box.minZ -= halfDepth;
        box.maxX += halfWidth;
        box.maxY += height;
        box.maxZ += halfDepth;
    }
}

