/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.reflection;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.utils.anticheat.LogUtil;
import ac.grim.grimac.utils.reflection.ReflectionUtils;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class PaperUtils {
    public static final boolean PAPER = ReflectionUtils.hasClass("com.destroystokyo.paper.PaperConfig") || ReflectionUtils.hasClass("io.papermc.paper.configuration.Configuration");
    public static final boolean TICK_END_EVENT = ReflectionUtils.hasClass("com.destroystokyo.paper.event.server.ServerTickEndEvent");
    public static final boolean ASYNC_TELEPORT = ReflectionUtils.hasMethod(Entity.class, "teleportAsync", Location.class);

    public static CompletableFuture<Boolean> teleportAsync(Entity entity, Location location) {
        if (PAPER) {
            return entity.teleportAsync(location);
        }
        return CompletableFuture.completedFuture(entity.teleport(location));
    }

    public static boolean registerTickEndEvent(Listener listener, Runnable runnable) {
        if (TICK_END_EVENT) {
            try {
                Class<?> clazz = ReflectionUtils.getClass("com.destroystokyo.paper.event.server.ServerTickEndEvent");
                if (clazz == null) {
                    return false;
                }
                GrimAPI.INSTANCE.getPlugin().getServer().getPluginManager().registerEvent(clazz, listener, EventPriority.NORMAL, (l, event) -> runnable.run(), (Plugin)GrimAPI.INSTANCE.getPlugin());
                return true;
            }
            catch (Exception e) {
                LogUtil.exception("Failed to register tick end event", e);
            }
        }
        return false;
    }
}

