/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.team;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerTeams;
import ac.grim.grimac.shaded.fastutil.objects.Object2ObjectOpenHashMap;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.team.EntityTeam;
import java.util.Map;
import java.util.UUID;

public class TeamHandler
extends Check
implements PacketCheck {
    private final Map<String, EntityTeam> entityTeams = new Object2ObjectOpenHashMap<String, EntityTeam>();
    private final Map<String, EntityTeam> entityToTeam = new Object2ObjectOpenHashMap<String, EntityTeam>();
    @Nullable
    private EntityTeam playerTeam = null;

    public TeamHandler(GrimPlayer player) {
        super(player);
    }

    public void addEntityToTeam(String entityTeamRepresentation, EntityTeam team) {
        this.entityToTeam.put(entityTeamRepresentation, team);
    }

    public void removeEntityFromTeam(String entityTeamRepresentation) {
        this.entityToTeam.remove(entityTeamRepresentation);
    }

    public EntityTeam getEntityTeam(PacketEntity entity) {
        UUID uuid = entity.getUuid();
        return uuid == null ? null : this.entityToTeam.get(uuid.toString());
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() == PacketType.Play.Server.TEAMS) {
            WrapperPlayServerTeams teams = new WrapperPlayServerTeams(event);
            String teamName = teams.getTeamName();
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                EntityTeam entityTeam;
                switch (teams.getTeamMode()) {
                    case CREATE: {
                        EntityTeam newTeam = new EntityTeam(this.player, teamName);
                        this.entityTeams.put(teamName, newTeam);
                        EntityTeam entityTeam2 = newTeam;
                        break;
                    }
                    case REMOVE: {
                        EntityTeam entityTeam2 = this.entityTeams.remove(teamName);
                        break;
                    }
                    default: {
                        EntityTeam entityTeam2 = entityTeam = this.entityTeams.get(teamName);
                    }
                }
                if (entityTeam != null) {
                    entityTeam.update(teams);
                }
            });
        }
    }

    @Nullable
    public EntityTeam getPlayerTeam() {
        return this.playerTeam;
    }

    public void setPlayerTeam(@Nullable EntityTeam playerTeam) {
        this.playerTeam = playerTeam;
    }
}

