/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.fabric.sender;

import ac.grim.grimac.platform.api.permissions.PermissionDefaultValue;
import ac.grim.grimac.platform.api.sender.Sender;
import ac.grim.grimac.platform.api.sender.SenderFactory;
import ac.grim.grimac.platform.fabric.GrimACFabricLoaderPlugin;
import ac.grim.grimac.platform.fabric.utils.message.IFabricMessageUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.util.TriState;
import net.kyori.adventure.text.Component;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_3222;
import net.minecraft.class_3350;
import org.incendo.cloud.SenderMapper;
import org.jetbrains.annotations.NotNull;

public class FabricSenderFactory
extends SenderFactory<class_2168>
implements SenderMapper<class_2168, Sender> {
    private final Map<String, PermissionDefaultValue> permissionDefaults = new HashMap<String, PermissionDefaultValue>();
    private static final IFabricMessageUtil fabricMessageUtils = GrimACFabricLoaderPlugin.LOADER.getFabricMessageUtils();

    protected UUID getUniqueId(class_2168 commandSource) {
        if (commandSource.method_9228() != null) {
            return commandSource.method_9228().method_5667();
        }
        return Sender.CONSOLE_UUID;
    }

    protected String getName(class_2168 commandSource) {
        String name = commandSource.method_9214();
        if (commandSource.method_9228() != null && name.equals("Server")) {
            return "Console";
        }
        return name;
    }

    protected void sendMessage(class_2168 sender, String message) {
        fabricMessageUtils.sendMessage(sender, fabricMessageUtils.textLiteral(message), false);
    }

    protected void sendMessage(class_2168 sender, Component message) {
        fabricMessageUtils.sendMessage(sender, GrimACFabricLoaderPlugin.LOADER.getFabricConversionUtil().toNativeText(message), false);
    }

    protected boolean hasPermission(class_2168 commandSource, String node) {
        TriState permissionValue = Permissions.getPermissionValue((class_2172)commandSource, (String)node);
        if (permissionValue != TriState.DEFAULT) {
            return permissionValue.get();
        }
        PermissionDefaultValue defaultValue = this.permissionDefaults.get(node);
        if (defaultValue == null) {
            return permissionValue.get();
        }
        return switch (defaultValue) {
            default -> throw new IncompatibleClassChangeError();
            case PermissionDefaultValue.TRUE -> true;
            case PermissionDefaultValue.FALSE -> false;
            case PermissionDefaultValue.OP -> commandSource.method_9259(GrimACFabricLoaderPlugin.FABRIC_SERVER.method_3798());
            case PermissionDefaultValue.NOT_OP -> !commandSource.method_9259(GrimACFabricLoaderPlugin.FABRIC_SERVER.method_3798());
        };
    }

    protected boolean hasPermission(class_2168 commandSource, String node, boolean defaultIfUnset) {
        return Permissions.check((class_2172)commandSource, (String)node, (boolean)defaultIfUnset);
    }

    protected void performCommand(class_2168 sender, String command) {
        throw new UnsupportedOperationException();
    }

    protected boolean isConsole(class_2168 sender) {
        class_2165 output = sender.field_9819;
        return output == sender.method_9211() || output.getClass() == class_3350.class || output == class_2165.field_17395 && sender.method_9214().isEmpty();
    }

    protected boolean isPlayer(class_2168 sender) {
        return sender.method_9228() instanceof class_3222;
    }

    @NotNull
    public Sender map(@NotNull class_2168 base) {
        return this.wrap(base);
    }

    @NotNull
    public class_2168 reverse(@NotNull Sender mapped) {
        return (class_2168)this.unwrap(mapped);
    }

    public void registerPermissionDefault(String permission, PermissionDefaultValue defaultValue) {
        this.permissionDefaults.put(permission, defaultValue);
    }
}

