/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBT;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTLimiter;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTNumber;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTString;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.serializer.SequentialNBTReader;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings.ListDiff;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings.MapDiff;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings.TypesBuilder;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import ac.grim.grimac.shaded.jetbrains.annotations.ApiStatus;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;

@ApiStatus.Internal
public class MappingHelper {
    public static SequentialNBTReader.Compound decompress(String path) {
        try {
            DataInputStream dataInput = new DataInputStream(new GZIPInputStream(new BufferedInputStream(PacketEvents.getAPI().getSettings().getResourceProvider().apply("assets/" + path + ".nbt"))));
            return (SequentialNBTReader.Compound)SequentialNBTReader.INSTANCE.deserializeTag(NBTLimiter.noop(), dataInput);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot find resource file " + path + ".nbt", e);
        }
    }

    public static List<ListDiff<String>> createListDiff(SequentialNBTReader.Compound compound) {
        ArrayList<ListDiff<String>> diffs = new ArrayList<ListDiff<String>>();
        SequentialNBTReader.List removals = (SequentialNBTReader.List)compound.next().getValue();
        for (Object entry : removals) {
            SequentialNBTReader.Compound c = (SequentialNBTReader.Compound)entry;
            diffs.add(new ListDiff.Removal(((NBTNumber)c.next().getValue()).getAsInt(), ((NBTNumber)c.next().getValue()).getAsInt()));
        }
        SequentialNBTReader.List additions = (SequentialNBTReader.List)compound.next().getValue();
        for (NBT entry : additions) {
            SequentialNBTReader.Compound c = (SequentialNBTReader.Compound)entry;
            diffs.add(new ListDiff.Addition(((NBTNumber)c.next().getValue()).getAsInt(), StreamSupport.stream(((SequentialNBTReader.List)c.next().getValue()).spliterator(), false).map(nbt -> ((NBTString)nbt).getValue()).collect(Collectors.toList())));
        }
        SequentialNBTReader.List changes = (SequentialNBTReader.List)compound.next().getValue();
        for (NBT entry : changes) {
            SequentialNBTReader.Compound c = (SequentialNBTReader.Compound)entry;
            diffs.add(new ListDiff.Changed(((NBTNumber)c.next().getValue()).getAsInt(), ((NBTNumber)c.next().getValue()).getAsInt(), StreamSupport.stream(((SequentialNBTReader.List)c.next().getValue()).spliterator(), false).map(nbt -> ((NBTString)nbt).getValue()).collect(Collectors.toList())));
        }
        diffs.sort(Comparator.comparingInt(ListDiff::getIndex));
        return diffs;
    }

    public static List<MapDiff<String, Integer>> createDiff(SequentialNBTReader.Compound compound) {
        ArrayList<MapDiff<String, Integer>> diffs = new ArrayList<MapDiff<String, Integer>>();
        SequentialNBTReader.Compound removal = (SequentialNBTReader.Compound)compound.next().getValue();
        for (Map.Entry<String, NBT> entry : removal) {
            diffs.add(new MapDiff.Removal(entry.getKey()));
        }
        SequentialNBTReader.Compound additions = (SequentialNBTReader.Compound)compound.next().getValue();
        for (Map.Entry<String, NBT> entry : additions) {
            diffs.add(new MapDiff.Addition<String, Integer>(entry.getKey(), ((NBTNumber)entry.getValue()).getAsInt()));
        }
        return diffs;
    }

    public static <T extends MappedEntity> void registerMapping(TypesBuilder builder, Map<String, T> typeMap, Map<Byte, Map<Integer, T>> typeIdMap, TypesBuilderData typeData, T type) {
        typeMap.put(typeData.getName().toString(), type);
        for (ClientVersion version : builder.getVersions()) {
            int index = builder.getDataIndex(version);
            Map idMap = typeIdMap.computeIfAbsent((byte)index, k -> new HashMap());
            idMap.put(typeData.getId(version), type);
        }
    }

    public static int getId(ClientVersion version, TypesBuilder builder, TypesBuilderData data) {
        return data.getData()[builder.getDataIndex(version)];
    }
}

