/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.badpackets;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PostPredictionCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.utils.anticheat.update.PredictionComplete;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.GameMode;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientEntityAction;

@CheckData(name="BadPacketsX", experimental=true)
public class BadPacketsX
extends Check
implements PostPredictionCheck {
    private boolean sprint;
    private boolean sneak;
    private int flags;

    public BadPacketsX(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPredictionComplete(PredictionComplete predictionComplete) {
        if (!this.player.canSkipTicksPreVia()) {
            if (this.flags > 0) {
                this.setbackIfAboveSetbackVL();
            }
            this.flags = 0;
            return;
        }
        if (this.player.isTickingReliablyFor(3)) {
            while (this.flags > 0) {
                this.flagAndAlertWithSetback();
                --this.flags;
            }
        }
        this.flags = 0;
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (this.player.gamemode == GameMode.SPECTATOR || this.isTickPacket(event.getPacketType())) {
            this.sneak = false;
            this.sprint = false;
            return;
        }
        if (event.getPacketType() == PacketType.Play.Client.ENTITY_ACTION) {
            switch (new WrapperPlayClientEntityAction(event).getAction()) {
                case START_SNEAKING: 
                case STOP_SNEAKING: {
                    if (this.sneak && (this.player.canSkipTicksPreVia() || this.flagAndAlert())) {
                        ++this.flags;
                    }
                    this.sneak = true;
                    break;
                }
                case START_SPRINTING: 
                case STOP_SPRINTING: {
                    if (this.player.inVehicle()) {
                        return;
                    }
                    if (this.sprint && (this.player.canSkipTicksPreVia() || this.flagAndAlert())) {
                        ++this.flags;
                    }
                    this.sprint = true;
                }
            }
        }
    }
}

