/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.anticheat.update;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.utils.anticheat.LogUtil;
import ac.grim.grimac.utils.collisions.AxisSelect;
import ac.grim.grimac.utils.collisions.CollisionData;
import ac.grim.grimac.utils.collisions.blocks.DoorHandler;
import ac.grim.grimac.utils.collisions.datatypes.CollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.CollisionFactory;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.HitData;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.latency.CompensatedWorld;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.math.Vector3dm;
import ac.grim.grimac.utils.nmsutil.BoundingBoxSize;
import ac.grim.grimac.utils.nmsutil.GetBoundingBox;
import ac.grim.grimac.utils.nmsutil.Materials;
import ac.grim.grimac.utils.nmsutil.ReachUtils;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.attribute.Attributes;
import com.github.retrooper.packetevents.protocol.item.ItemStack;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.InteractionHand;
import com.github.retrooper.packetevents.protocol.world.BlockFace;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.protocol.world.states.defaulttags.BlockTags;
import com.github.retrooper.packetevents.protocol.world.states.enums.East;
import com.github.retrooper.packetevents.protocol.world.states.enums.Half;
import com.github.retrooper.packetevents.protocol.world.states.enums.North;
import com.github.retrooper.packetevents.protocol.world.states.enums.South;
import com.github.retrooper.packetevents.protocol.world.states.enums.Type;
import com.github.retrooper.packetevents.protocol.world.states.enums.West;
import com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import com.github.retrooper.packetevents.protocol.world.states.type.StateValue;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.util.Vector3f;
import com.github.retrooper.packetevents.util.Vector3i;
import java.lang.invoke.StringConcatFactory;
import java.util.Arrays;
import java.util.List;

public class BlockPlace {
    private static final BlockFace[] BY_3D = new BlockFace[]{BlockFace.DOWN, BlockFace.UP, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST, BlockFace.EAST};
    public static final BlockFace[] BY_2D = new BlockFace[]{BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST};
    public final boolean isBlock;
    private final SimpleCollisionBox[] collisions = new SimpleCollisionBox[15];
    public Vector3i position;
    public final InteractionHand hand;
    public boolean replaceClicked;
    private boolean isCancelled;
    private final GrimPlayer player;
    public final ItemStack itemStack;
    public final StateType material;
    @Nullable
    public final HitData hitData;
    private int faceId;
    private BlockFace face;
    public boolean isInside;
    public Vector3f cursor;
    public final int sequence;

    public BlockPlace(GrimPlayer player, InteractionHand hand, Vector3i position, int faceId, BlockFace face, ItemStack itemStack, @Nullable HitData hitData, int sequence) {
        this.player = player;
        this.hand = hand;
        this.position = position;
        this.faceId = faceId;
        this.face = face;
        this.itemStack = itemStack;
        if (itemStack.getType().getPlacedType() == null) {
            this.material = StateTypes.FIRE;
            this.isBlock = false;
        } else {
            this.material = itemStack.getType().getPlacedType();
            this.isBlock = true;
        }
        this.hitData = hitData;
        WrappedBlockState state = player.compensatedWorld.getBlock(position);
        this.replaceClicked = this.canBeReplaced(this.material, state, face);
        this.sequence = sequence;
    }

    public WrappedBlockState getExistingBlockData() {
        return this.player.compensatedWorld.getBlock(this.getPlacedBlockPos());
    }

    public StateType getPlacedAgainstMaterial() {
        return this.player.compensatedWorld.getBlock(this.position).getType();
    }

    public WrappedBlockState getBelowState() {
        Vector3i pos = this.getPlacedBlockPos();
        pos = pos.withY(pos.getY() - 1);
        return this.player.compensatedWorld.getBlock(pos);
    }

    public WrappedBlockState getAboveState() {
        Vector3i pos = this.getPlacedBlockPos();
        pos = pos.withY(pos.getY() + 1);
        return this.player.compensatedWorld.getBlock(pos);
    }

    public WrappedBlockState getDirectionalState(BlockFace facing) {
        Vector3i pos = this.getPlacedBlockPos();
        pos = pos.add(facing.getModX(), facing.getModY(), facing.getModZ());
        return this.player.compensatedWorld.getBlock(pos);
    }

    public boolean isSolidBlocking(BlockFace relative) {
        WrappedBlockState state = this.getDirectionalState(relative);
        return state.getType().isBlocking();
    }

    private boolean canBeReplaced(StateType heldItem, WrappedBlockState state, BlockFace face) {
        boolean baseReplaceable;
        boolean bl = baseReplaceable = state.getType() != heldItem && state.getType().isReplaceable();
        if (BlockTags.CANDLES.contains(state.getType())) {
            return heldItem == state.getType() && state.getCandles() < 4 && !this.isSecondaryUse();
        }
        if (state.getType() == StateTypes.SEA_PICKLE) {
            return heldItem == state.getType() && state.getPickles() < 4 && !this.isSecondaryUse();
        }
        if (state.getType() == StateTypes.TURTLE_EGG) {
            return heldItem == state.getType() && state.getEggs() < 4 && !this.isSecondaryUse();
        }
        if (state.getType() == StateTypes.GLOW_LICHEN) {
            if (heldItem != StateTypes.GLOW_LICHEN) {
                return true;
            }
            if (!state.isUp()) {
                return true;
            }
            if (!state.isDown()) {
                return true;
            }
            if (state.getNorth() == North.FALSE) {
                return true;
            }
            if (state.getSouth() == South.FALSE) {
                return true;
            }
            if (state.getEast() == East.FALSE) {
                return true;
            }
            return state.getWest() == West.FALSE;
        }
        if (state.getType() == StateTypes.SCAFFOLDING) {
            return heldItem == StateTypes.SCAFFOLDING;
        }
        if (BlockTags.SLABS.contains(state.getType())) {
            if (state.getTypeData() == Type.DOUBLE || state.getType() != heldItem) {
                return false;
            }
            boolean flag = this.getClickedLocation().getY() > 0.5;
            BlockFace clickedFace = this.getFace();
            if (state.getTypeData() == Type.BOTTOM) {
                return clickedFace == BlockFace.UP || flag && this.isFaceHorizontal();
            }
            return clickedFace == BlockFace.DOWN || !flag && this.isFaceHorizontal();
        }
        if (state.getType() == StateTypes.SNOW) {
            int layers = state.getLayers();
            if (heldItem == state.getType() && layers < 8) {
                return face == BlockFace.UP;
            }
            return layers == 1;
        }
        if (state.getType() == StateTypes.VINE) {
            if (baseReplaceable) {
                return true;
            }
            if (heldItem != state.getType()) {
                return false;
            }
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_13) && !state.isUp()) {
                return true;
            }
            if (state.getNorth() == North.FALSE) {
                return true;
            }
            if (state.getSouth() == South.FALSE) {
                return true;
            }
            if (state.getEast() == East.FALSE) {
                return true;
            }
            return state.getWest() == West.FALSE;
        }
        if (state.getType() == StateTypes.LADDER && this.player.getClientVersion().isOlderThan(ClientVersion.V_1_13)) {
            return true;
        }
        return baseReplaceable;
    }

    public boolean isFaceFullCenter(BlockFace facing) {
        WrappedBlockState data = this.getDirectionalState(facing);
        CollisionBox box = CollisionData.getData(data.getType()).getMovementCollisionBox(this.player, this.player.getClientVersion(), data);
        if (box.isNull()) {
            return false;
        }
        if (this.isFullFace(facing)) {
            return true;
        }
        if (BlockTags.LEAVES.contains(data.getType())) {
            return false;
        }
        if (BlockTags.FENCE_GATES.contains(data.getType())) {
            return false;
        }
        int size = box.downCast(this.collisions);
        AxisSelect axis = AxisSelect.byFace(facing.getOppositeFace());
        for (int i = 0; i < size; ++i) {
            SimpleCollisionBox simpleBox = this.collisions[i];
            simpleBox = axis.modify(simpleBox);
            if (!(simpleBox.minX <= 0.4375) || !(simpleBox.maxX >= 0.4375) || !(simpleBox.minY <= 0.0) || !(simpleBox.maxY >= 0.625) || !(simpleBox.minZ <= 0.4375) || !(simpleBox.maxZ >= 0.5625)) continue;
            return true;
        }
        return false;
    }

    public boolean isFaceRigid(BlockFace facing) {
        WrappedBlockState data = this.getDirectionalState(facing);
        CollisionBox box = CollisionData.getData(data.getType()).getMovementCollisionBox(this.player, this.player.getClientVersion(), data);
        if (box.isNull()) {
            return false;
        }
        if (this.isFullFace(facing)) {
            return true;
        }
        if (BlockTags.LEAVES.contains(data.getType())) {
            return false;
        }
        int size = box.downCast(this.collisions);
        AxisSelect axis = AxisSelect.byFace(facing.getOppositeFace());
        for (int i = 0; i < size; ++i) {
            SimpleCollisionBox simpleBox = this.collisions[i];
            simpleBox = axis.modify(simpleBox);
            if (!(simpleBox.minX <= 0.125) || !(simpleBox.maxX >= 0.875) || !(simpleBox.minY <= 0.0) || !(simpleBox.maxY >= 1.0) || !(simpleBox.minZ <= 0.125) || !(simpleBox.maxZ >= 0.875)) continue;
            return true;
        }
        return false;
    }

    public boolean isFullFace(BlockFace relative) {
        WrappedBlockState state = this.getDirectionalState(relative);
        BlockFace face = relative.getOppositeFace();
        BlockFace bukkitFace = BlockFace.valueOf((String)face.name());
        AxisSelect axis = AxisSelect.byFace(face);
        CollisionBox box = CollisionData.getData(state.getType()).getMovementCollisionBox(this.player, this.player.getClientVersion(), state);
        StateType blockMaterial = state.getType();
        if (BlockTags.LEAVES.contains(blockMaterial)) {
            return false;
        }
        if (blockMaterial == StateTypes.SNOW) {
            return state.getLayers() == 8 || face == BlockFace.DOWN;
        }
        if (BlockTags.STAIRS.contains(blockMaterial)) {
            if (face == BlockFace.UP) {
                return state.getHalf() == Half.TOP;
            }
            if (face == BlockFace.DOWN) {
                return state.getHalf() == Half.BOTTOM;
            }
            return state.getFacing() == bukkitFace;
        }
        if (blockMaterial == StateTypes.COMPOSTER) {
            return face != BlockFace.UP;
        }
        if (blockMaterial == StateTypes.SOUL_SAND) {
            return true;
        }
        if (blockMaterial == StateTypes.LADDER) {
            return state.getFacing().getOppositeFace() == bukkitFace;
        }
        if (BlockTags.TRAPDOORS.contains(blockMaterial)) {
            return state.getFacing().getOppositeFace() == bukkitFace && state.isOpen() || state.getHalf() == Half.TOP && !state.isOpen() && bukkitFace == BlockFace.UP || state.getHalf() == Half.BOTTOM && !state.isOpen() && bukkitFace == BlockFace.DOWN;
        }
        if (BlockTags.DOORS.contains(blockMaterial)) {
            CollisionData data = CollisionData.getData(blockMaterial);
            CollisionFactory collisionFactory = data.dynamic;
            if (collisionFactory instanceof DoorHandler) {
                DoorHandler doorHandler = (DoorHandler)collisionFactory;
                return doorHandler.fetchDirection(this.player, this.player.getClientVersion(), state, this.position.x, this.position.y, this.position.z).getOppositeFace() == bukkitFace;
            }
        }
        int size = box.downCast(this.collisions);
        for (int i = 0; i < size; ++i) {
            SimpleCollisionBox simpleBox = this.collisions[i];
            if (!axis.modify(simpleBox).isFullBlockNoCache()) continue;
            return true;
        }
        return false;
    }

    public boolean isBlockFaceOpen(BlockFace facing) {
        Vector3i pos = this.getPlacedBlockPos();
        if ((pos = pos.add(facing.getModX(), facing.getModY(), facing.getModZ())).getY() >= this.player.compensatedWorld.getMaxHeight()) {
            return false;
        }
        return this.player.compensatedWorld.getBlock(pos).getType().isReplaceable();
    }

    public boolean isFaceEmpty(BlockFace facing) {
        WrappedBlockState data = this.getDirectionalState(facing);
        CollisionBox box = CollisionData.getData(data.getType()).getMovementCollisionBox(this.player, this.player.getClientVersion(), data);
        if (box.isNull()) {
            return false;
        }
        if (this.isFullFace(facing)) {
            return true;
        }
        if (BlockTags.LEAVES.contains(data.getType())) {
            return false;
        }
        int size = box.downCast(this.collisions);
        AxisSelect axis = AxisSelect.byFace(facing.getOppositeFace());
        block8: for (int i = 0; i < size; ++i) {
            SimpleCollisionBox simpleBox = this.collisions[i];
            simpleBox = axis.modify(simpleBox);
            switch (facing) {
                case NORTH: {
                    if (simpleBox.minZ != 0.0) continue block8;
                    return false;
                }
                case SOUTH: {
                    if (simpleBox.maxZ != 1.0) continue block8;
                    return false;
                }
                case EAST: {
                    if (simpleBox.maxX != 1.0) continue block8;
                    return false;
                }
                case WEST: {
                    if (simpleBox.minX != 0.0) continue block8;
                    return false;
                }
                case UP: {
                    if (simpleBox.maxY != 1.0) continue block8;
                    return false;
                }
                case DOWN: {
                    if (simpleBox.minY != 0.0) continue block8;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isLava(BlockFace facing) {
        Vector3i pos = this.getPlacedBlockPos();
        return this.player.compensatedWorld.getBlock(pos = pos.add(facing.getModX(), facing.getModY(), facing.getModZ())).getType() == StateTypes.LAVA;
    }

    public boolean isSecondaryUse() {
        return this.player.isSneaking;
    }

    public boolean isInWater() {
        Vector3i pos = this.getPlacedBlockPos();
        return this.player.compensatedWorld.isWaterSourceBlock(pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean isInLiquid() {
        Vector3i pos = this.getPlacedBlockPos();
        WrappedBlockState data = this.player.compensatedWorld.getBlock(pos);
        return Materials.isWater(this.player.getClientVersion(), data) || data.getType() == StateTypes.LAVA;
    }

    public StateType getBelowMaterial() {
        return this.getBelowState().getType();
    }

    public boolean isOn(StateType ... mat) {
        StateType lookingFor = this.getBelowMaterial();
        return Arrays.stream(mat).anyMatch(m -> m == lookingFor);
    }

    public boolean isOnDirt() {
        return this.isOn(StateTypes.DIRT, StateTypes.GRASS_BLOCK, StateTypes.PODZOL, StateTypes.COARSE_DIRT, StateTypes.MYCELIUM, StateTypes.ROOTED_DIRT, StateTypes.MOSS_BLOCK);
    }

    public boolean isBlockPlacedPowered() {
        Vector3i placed = this.getPlacedBlockPos();
        for (BlockFace face : BY_3D) {
            boolean isByDefaultConductive;
            Vector3i modified = placed.add(face.getModX(), face.getModY(), face.getModZ());
            if (this.player.compensatedWorld.getRawPowerAtState(face, modified.getX(), modified.getY(), modified.getZ()) > 0) {
                return true;
            }
            WrappedBlockState state = this.player.compensatedWorld.getBlock(modified);
            boolean bl = isByDefaultConductive = !Materials.isSolidBlockingBlacklist(state.getType(), this.player.getClientVersion()) && CollisionData.getData(state.getType()).getMovementCollisionBox(this.player, this.player.getClientVersion(), state).isFullBlock();
            if (state.getType() != StateTypes.SOUL_SAND && BlockTags.GLASS_BLOCKS.contains(state.getType()) || state.getType() == StateTypes.MOVING_PISTON || state.getType() == StateTypes.BEACON || state.getType() == StateTypes.REDSTONE_BLOCK || state.getType() == StateTypes.OBSERVER || !isByDefaultConductive) continue;
            for (BlockFace recursive : BY_3D) {
                Vector3i poweredRecursive = placed.add(recursive.getModX(), recursive.getModY(), recursive.getModZ());
                if (this.player.compensatedWorld.getDirectSignalAtState(recursive, poweredRecursive.getX(), poweredRecursive.getY(), poweredRecursive.getZ()) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public void setFace(BlockFace face) {
        this.face = face;
        this.faceId = face.getFaceValue();
    }

    public void setFaceId(int face) {
        this.faceId = face;
        this.face = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9) ? BlockFace.getBlockFaceByValue((int)this.faceId) : BlockFace.getLegacyBlockFaceByValue((int)this.faceId);
    }

    private List<BlockFace> getNearestLookingDirections() {
        BlockFace direction2;
        float f = this.player.yRot * ((float)Math.PI / 180);
        float f1 = -this.player.xRot * ((float)Math.PI / 180);
        float f2 = this.player.trigHandler.sin(f);
        float f3 = this.player.trigHandler.cos(f);
        float f4 = this.player.trigHandler.sin(f1);
        float f5 = this.player.trigHandler.cos(f1);
        boolean flag = f4 > 0.0f;
        boolean flag1 = f2 < 0.0f;
        boolean flag2 = f5 > 0.0f;
        float f6 = flag ? f4 : -f4;
        float f7 = flag1 ? -f2 : f2;
        float f8 = flag2 ? f5 : -f5;
        float f9 = f6 * f3;
        float f10 = f8 * f3;
        BlockFace direction = flag ? BlockFace.EAST : BlockFace.WEST;
        BlockFace direction1 = flag1 ? BlockFace.UP : BlockFace.DOWN;
        BlockFace blockFace = direction2 = flag2 ? BlockFace.SOUTH : BlockFace.NORTH;
        if (f6 > f8) {
            if (f7 > f9) {
                return this.makeDirList(direction1, direction, direction2);
            }
            return f10 > f7 ? this.makeDirList(direction, direction2, direction1) : this.makeDirList(direction, direction1, direction2);
        }
        if (f7 > f10) {
            return this.makeDirList(direction1, direction2, direction);
        }
        return f9 > f7 ? this.makeDirList(direction2, direction, direction1) : this.makeDirList(direction2, direction1, direction);
    }

    private List<BlockFace> makeDirList(BlockFace one, BlockFace two, BlockFace three) {
        return Arrays.asList(one, two, three, three.getOppositeFace(), two.getOppositeFace(), one.getOppositeFace());
    }

    public BlockFace getNearestVerticalDirection() {
        return this.player.yRot < 0.0f ? BlockFace.UP : BlockFace.DOWN;
    }

    public List<BlockFace> getNearestPlacingDirections() {
        BlockFace[] faces = this.getNearestLookingDirections().toArray(new BlockFace[0]);
        if (!this.replaceClicked) {
            int i;
            BlockFace direction = this.getFace();
            for (i = 0; i < faces.length && faces[i] != direction.getOppositeFace(); ++i) {
            }
            if (i > 0) {
                System.arraycopy(faces, 0, faces, 1, i);
                faces[0] = direction.getOppositeFace();
            }
        }
        return Arrays.asList(faces);
    }

    public boolean isFaceVertical() {
        return !this.isFaceHorizontal();
    }

    public boolean isFaceHorizontal() {
        BlockFace face = this.getFace();
        return face == BlockFace.NORTH || face == BlockFace.EAST || face == BlockFace.SOUTH || face == BlockFace.WEST;
    }

    public boolean isXAxis() {
        BlockFace face = this.getFace();
        return face == BlockFace.WEST || face == BlockFace.EAST;
    }

    public Vector3i getPlacedBlockPos() {
        if (this.replaceClicked) {
            return this.position;
        }
        int x = this.position.getX() + this.getNormalBlockFace().getX();
        int y = this.position.getY() + this.getNormalBlockFace().getY();
        int z = this.position.getZ() + this.getNormalBlockFace().getZ();
        return new Vector3i(x, y, z);
    }

    public Vector3i getNormalBlockFace() {
        return switch (this.face) {
            case BlockFace.DOWN -> new Vector3i(0, -1, 0);
            case BlockFace.SOUTH -> new Vector3i(0, 0, 1);
            case BlockFace.NORTH -> new Vector3i(0, 0, -1);
            case BlockFace.WEST -> new Vector3i(-1, 0, 0);
            case BlockFace.EAST -> new Vector3i(1, 0, 0);
            default -> new Vector3i(0, 1, 0);
        };
    }

    public void set(StateType material) {
        this.set(material.createBlockState(CompensatedWorld.blockVersion));
    }

    public void set(BlockFace face, WrappedBlockState state) {
        Vector3i blockPos = this.getPlacedBlockPos().add(face.getModX(), face.getModY(), face.getModZ());
        this.set(blockPos, state);
    }

    public void set(Vector3i position, WrappedBlockState state) {
        CollisionBox box = CollisionData.getData(state.getType()).getMovementCollisionBox(this.player, this.player.getClientVersion(), state, position.getX(), position.getY(), position.getZ());
        if (state.getType() != StateTypes.SCAFFOLDING) {
            if (box.isIntersected(this.player.boundingBox)) {
                return;
            }
            if (this.player.getClientVersion().isNewerThan(ClientVersion.V_1_8)) {
                for (PacketEntity entity : this.player.compensatedEntities.entityMap.values()) {
                    SimpleCollisionBox interpBox = entity.getPossibleCollisionBoxes();
                    double scale = entity.getAttributeValue(Attributes.SCALE);
                    double width = (double)BoundingBoxSize.getWidth(this.player, entity) * scale;
                    double height = (double)BoundingBoxSize.getHeight(this.player, entity) * scale;
                    double interpWidth = Math.max(interpBox.maxX - interpBox.minX, interpBox.maxZ - interpBox.minZ);
                    double interpHeight = interpBox.maxY - interpBox.minY;
                    if (interpWidth - width > 0.05 || interpHeight - height > 0.05) {
                        Vector3d entityPos = entity.trackedServerPosition.getPos();
                        interpBox = GetBoundingBox.getPacketEntityBoundingBox(this.player, entityPos.getX(), entityPos.getY(), entityPos.getZ(), entity);
                    }
                    if (!box.isIntersected(interpBox)) continue;
                    return;
                }
            }
        }
        WrappedBlockState existingState = this.player.compensatedWorld.getBlock(position);
        if (!this.replaceClicked && !this.canBeReplaced(this.material, existingState, this.face)) {
            return;
        }
        if (this.player.compensatedWorld.getMaxHeight() <= position.getY() || position.getY() < this.player.compensatedWorld.getMinHeight()) {
            return;
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_13) && state.getInternalData().containsKey(StateValue.WATERLOGGED)) {
            state.setWaterlogged(existingState.getType() == StateTypes.WATER && existingState.getLevel() == 0);
        }
        this.player.getInventory().onBlockPlace(this);
        this.player.compensatedWorld.updateBlock(position.getX(), position.getY(), position.getZ(), state.getGlobalId());
    }

    public boolean isZAxis() {
        BlockFace face = this.getFace();
        return face == BlockFace.NORTH || face == BlockFace.SOUTH;
    }

    public void tryCascadeBlockUpdates(Vector3i pos) {
        if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_12_2)) {
            return;
        }
        this.cascadeBlockUpdates(pos);
    }

    private void cascadeBlockUpdates(Vector3i pos) {
    }

    public void set(WrappedBlockState state) {
        this.set(this.getPlacedBlockPos(), state);
    }

    public void resync() {
        this.isCancelled = true;
    }

    public Vector3dm getClickedLocation() {
        Vector3dm endReachPos;
        SimpleCollisionBox box = new SimpleCollisionBox(this.position);
        Vector3dm look = ReachUtils.getLook(this.player, this.player.xRot, this.player.yRot);
        double distance = this.player.compensatedEntities.self.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + 3.0;
        Vector3dm eyePos = new Vector3dm(this.player.x, this.player.y + this.player.getEyeHeight(), this.player.z);
        Vector3dm intercept = ReachUtils.calculateIntercept(box, eyePos, endReachPos = eyePos.clone().add(new Vector3dm(look.getX() * distance, look.getY() * distance, look.getZ() * distance))).first();
        if (intercept == null) {
            return new Vector3dm();
        }
        intercept.setX(intercept.getX() - box.minX);
        intercept.setY(intercept.getY() - box.minY);
        intercept.setZ(intercept.getZ() - box.minZ);
        return intercept;
    }

    public BlockFace getPlayerFacing() {
        return BY_2D[GrimMath.floor((double)this.player.xRot / 90.0 + 0.5) & 3];
    }

    public void set() {
        if (this.material == null) {
            LogUtil.warn((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Material null has no placed type!"})));
            return;
        }
        this.set(this.material);
    }

    public void setAbove() {
        Vector3i placed = this.getPlacedBlockPos();
        placed = placed.add(0, 1, 0);
        this.set(placed, this.material.createBlockState(CompensatedWorld.blockVersion));
    }

    public void setAbove(WrappedBlockState toReplaceWith) {
        Vector3i placed = this.getPlacedBlockPos();
        placed = placed.add(0, 1, 0);
        this.set(placed, toReplaceWith);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public int getFaceId() {
        return this.faceId;
    }

    public BlockFace getFace() {
        return this.face;
    }
}

