/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.latency;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.utils.anticheat.update.BlockPlace;
import ac.grim.grimac.utils.inventory.EquipmentType;
import ac.grim.grimac.utils.inventory.Inventory;
import ac.grim.grimac.utils.inventory.inventory.AbstractContainerMenu;
import ac.grim.grimac.utils.inventory.inventory.MenuType;
import ac.grim.grimac.utils.inventory.inventory.NotImplementedMenu;
import ac.grim.grimac.utils.lists.CorrectingPlayerInventoryStorage;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.item.ItemStack;
import com.github.retrooper.packetevents.protocol.item.type.ItemType;
import com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.DiggingAction;
import com.github.retrooper.packetevents.protocol.player.GameMode;
import com.github.retrooper.packetevents.protocol.player.InteractionHand;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientClickWindow;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientCreativeInventoryAction;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientHeldItemChange;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientUseItem;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerOpenHorseWindow;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerOpenWindow;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetSlot;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWindowItems;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public class CompensatedInventory
extends Check
implements PacketCheck {
    private static final int PLAYER_INVENTORY_CASE = -1;
    private static final int UNSUPPORTED_INVENTORY_CASE = -2;
    public Inventory inventory;
    public AbstractContainerMenu menu;
    public boolean isPacketInventoryActive = true;
    public boolean needResend = false;
    public int stateID = 0;
    private int openWindowID = 0;
    private int packetSendingInventorySize = -1;

    public CompensatedInventory(GrimPlayer playerData) {
        super(playerData);
        CorrectingPlayerInventoryStorage storage = new CorrectingPlayerInventoryStorage(this.player, 46);
        this.inventory = new Inventory(playerData, storage);
        this.menu = this.inventory;
    }

    public int getBukkitSlot(int packetSlot) {
        if (packetSlot <= 4) {
            return -1;
        }
        if (packetSlot <= 8) {
            return 7 - packetSlot + 36;
        }
        if (packetSlot <= 35) {
            return packetSlot;
        }
        if (packetSlot <= 44) {
            return packetSlot - 36;
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9) && packetSlot == 45) {
            return 40;
        }
        return -1;
    }

    private void markPlayerSlotAsChanged(int clicked) {
        if (this.openWindowID == 0) {
            this.inventory.getInventoryStorage().handleClientClaimedSlotSet(clicked);
            return;
        }
        if (this.menu instanceof NotImplementedMenu) {
            return;
        }
        int nonPlayerInvSize = this.menu.getSlots().size() - 36 + 9;
        int playerInvSlotclicked = clicked - nonPlayerInvSize;
        this.inventory.getInventoryStorage().handleClientClaimedSlotSet(playerInvSlotclicked);
    }

    public ItemStack getItemInHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? this.getHeldItem() : this.getOffHand();
    }

    private void markServerForChangingSlot(int clicked, int windowID) {
        if (this.packetSendingInventorySize == -2) {
            return;
        }
        if (this.packetSendingInventorySize == -1 || windowID == 0) {
            this.inventory.getInventoryStorage().handleServerCorrectSlot(clicked);
            return;
        }
        int nonPlayerInvSize = this.menu.getSlots().size() - 36 + 9;
        int playerInvSlotclicked = clicked - nonPlayerInvSize;
        this.inventory.getInventoryStorage().handleServerCorrectSlot(playerInvSlotclicked);
    }

    public ItemStack getHeldItem() {
        ItemStack item = this.isPacketInventoryActive || this.player.platformPlayer == null ? this.inventory.getHeldItem() : this.player.platformPlayer.getInventory().getItemInHand();
        return item == null ? ItemStack.EMPTY : item;
    }

    public ItemStack getOffHand() {
        if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_9)) {
            return ItemStack.EMPTY;
        }
        ItemStack item = this.isPacketInventoryActive || this.player.platformPlayer == null ? this.inventory.getOffhand() : this.player.platformPlayer.getInventory().getItemInOffHand();
        return item == null ? ItemStack.EMPTY : item;
    }

    public ItemStack getHelmet() {
        ItemStack item = this.isPacketInventoryActive || this.player.platformPlayer == null ? this.inventory.getHelmet() : this.player.platformPlayer.getInventory().getHelmet();
        return item == null ? ItemStack.EMPTY : item;
    }

    public ItemStack getChestplate() {
        ItemStack item = this.isPacketInventoryActive || this.player.platformPlayer == null ? this.inventory.getChestplate() : this.player.platformPlayer.getInventory().getChestplate();
        return item == null ? ItemStack.EMPTY : item;
    }

    public ItemStack getLeggings() {
        ItemStack item = this.isPacketInventoryActive || this.player.platformPlayer == null ? this.inventory.getLeggings() : this.player.platformPlayer.getInventory().getLeggings();
        return item == null ? ItemStack.EMPTY : item;
    }

    public ItemStack getBoots() {
        ItemStack item = this.isPacketInventoryActive || this.player.platformPlayer == null ? this.inventory.getBoots() : this.player.platformPlayer.getInventory().getBoots();
        return item == null ? ItemStack.EMPTY : item;
    }

    private ItemStack getByEquipmentType(EquipmentType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentType.HEAD -> this.getHelmet();
            case EquipmentType.CHEST -> this.getChestplate();
            case EquipmentType.LEGS -> this.getLeggings();
            case EquipmentType.FEET -> this.getBoots();
            case EquipmentType.OFFHAND -> this.getOffHand();
            case EquipmentType.MAINHAND -> this.getHeldItem();
        };
    }

    public boolean hasItemType(ItemType type) {
        if (this.isPacketInventoryActive || this.player.platformPlayer == null) {
            return this.inventory.hasItemType(type);
        }
        for (ItemStack itemStack : this.player.platformPlayer.getInventory().getContents()) {
            if (itemStack == null || itemStack.getType() != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        int slot;
        WrapperPlayClientUseItem item;
        ItemStack use;
        EquipmentType equipmentType;
        if (event.getPacketType() == PacketType.Play.Client.USE_ITEM && (equipmentType = EquipmentType.getEquipmentSlotForItem(use = (item = new WrapperPlayClientUseItem(event)).getHand() == InteractionHand.MAIN_HAND ? this.player.getInventory().getHeldItem() : this.player.getInventory().getOffHand())) != null) {
            switch (equipmentType) {
                case HEAD: {
                    slot = 4;
                    break;
                }
                case CHEST: {
                    slot = 5;
                    break;
                }
                case LEGS: {
                    slot = 6;
                    break;
                }
                case FEET: {
                    slot = 7;
                    break;
                }
                default: {
                    return;
                }
            }
            ItemStack currentEquippedItem = this.getByEquipmentType(equipmentType);
            if (this.player.getClientVersion().isOlderThan(ClientVersion.V_1_19_4) && !currentEquippedItem.isEmpty()) {
                return;
            }
            int swapItemSlot = item.getHand() == InteractionHand.MAIN_HAND ? this.inventory.selected + 36 : 45;
            this.inventory.getInventoryStorage().handleClientClaimedSlotSet(swapItemSlot);
            this.inventory.getInventoryStorage().setItem(swapItemSlot, currentEquippedItem);
            this.inventory.getInventoryStorage().handleClientClaimedSlotSet(slot);
            this.inventory.getInventoryStorage().setItem(slot, use);
        }
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_DIGGING) {
            WrapperPlayClientPlayerDigging dig = new WrapperPlayClientPlayerDigging(event);
            if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_8)) {
                return;
            }
            if (dig.getAction() == DiggingAction.DROP_ITEM) {
                ItemStack heldItem = this.getHeldItem();
                if (heldItem != null) {
                    heldItem.setAmount(heldItem.getAmount() - 1);
                    if (heldItem.getAmount() <= 0) {
                        heldItem = null;
                    }
                }
                this.inventory.setHeldItem(heldItem);
                this.inventory.getInventoryStorage().handleClientClaimedSlotSet(36 + this.player.packetStateData.lastSlotSelected);
            }
            if (dig.getAction() == DiggingAction.DROP_ITEM_STACK) {
                this.inventory.setHeldItem(null);
                this.inventory.getInventoryStorage().handleClientClaimedSlotSet(36 + this.player.packetStateData.lastSlotSelected);
            }
        }
        if (event.getPacketType() == PacketType.Play.Client.HELD_ITEM_CHANGE) {
            int slot2 = new WrapperPlayClientHeldItemChange(event).getSlot();
            if (slot2 > 8 || slot2 < 0) {
                return;
            }
            this.inventory.selected = slot2;
        }
        if (event.getPacketType() == PacketType.Play.Client.CREATIVE_INVENTORY_ACTION) {
            boolean valid;
            WrapperPlayClientCreativeInventoryAction action = new WrapperPlayClientCreativeInventoryAction(event);
            if (this.player.gamemode != GameMode.CREATIVE) {
                return;
            }
            boolean bl = action.getSlot() >= 1 && (PacketEvents.getAPI().getServerManager().getVersion().isNewerThan(ServerVersion.V_1_8) ? action.getSlot() <= 45 : action.getSlot() < 45) ? true : (valid = false);
            if (valid) {
                this.player.getInventory().inventory.getSlot(action.getSlot()).set(action.getItemStack());
                this.inventory.getInventoryStorage().handleClientClaimedSlotSet(action.getSlot());
            }
        }
        if (event.getPacketType() == PacketType.Play.Client.CLICK_WINDOW && !event.isCancelled()) {
            WrapperPlayClientClickWindow click = new WrapperPlayClientClickWindow(event);
            if (click.getWindowId() != this.openWindowID) {
                return;
            }
            if (this.menu instanceof NotImplementedMenu) {
                return;
            }
            Optional slots = click.getSlots();
            slots.ifPresent(integerItemStackMap -> integerItemStackMap.keySet().forEach(this::markPlayerSlotAsChanged));
            int button = click.getButton();
            slot = click.getSlot();
            WrapperPlayClientClickWindow.WindowClickType clickType = click.getWindowClickType();
            if (slot == -1 || slot == -999 || slot < this.menu.getSlots().size()) {
                this.menu.doClick(button, slot, clickType);
            }
        }
        if (event.getPacketType() == PacketType.Play.Client.CLOSE_WINDOW) {
            this.closeActiveInventory();
        }
    }

    public void markSlotAsResyncing(BlockPlace place) {
        if (place.hand == InteractionHand.MAIN_HAND) {
            this.inventory.getInventoryStorage().handleClientClaimedSlotSet(36 + this.player.packetStateData.lastSlotSelected);
        } else {
            this.inventory.getInventoryStorage().handleServerCorrectSlot(45);
        }
    }

    public void onBlockPlace(BlockPlace place) {
        if (this.player.gamemode != GameMode.CREATIVE && place.itemStack.getType() != ItemTypes.POWDER_SNOW_BUCKET) {
            this.markSlotAsResyncing(place);
            place.itemStack.setAmount(place.itemStack.getAmount() - 1);
        }
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        WrapperPlayServerOpenWindow open;
        if (event.getPacketType() == PacketType.Play.Server.OPEN_WINDOW) {
            open = new WrapperPlayServerOpenWindow(event);
            MenuType menuType = MenuType.getMenuType(open.getType());
            AbstractContainerMenu newMenu = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_14) ? MenuType.getMenuFromID(this.player, this.inventory, menuType) : MenuType.getMenuFromString(this.player, this.inventory, open.getLegacyType(), open.getLegacySlots(), open.getHorseId());
            this.packetSendingInventorySize = newMenu instanceof NotImplementedMenu ? -2 : newMenu.getSlots().size();
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                this.openWindowID = open.getContainerId();
                this.menu = newMenu;
                this.isPacketInventoryActive = !(newMenu instanceof NotImplementedMenu);
                this.needResend = newMenu instanceof NotImplementedMenu;
            });
        }
        if (event.getPacketType() == PacketType.Play.Server.OPEN_HORSE_WINDOW) {
            open = new WrapperPlayServerOpenHorseWindow(event);
            this.packetSendingInventorySize = -2;
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> this.lambda$onPacketSend$2((WrapperPlayServerOpenHorseWindow)open));
        }
        if (event.getPacketType() == PacketType.Play.Server.CLOSE_WINDOW) {
            this.packetSendingInventorySize = -1;
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), this::closeActiveInventory);
        }
        if (event.getPacketType() == PacketType.Play.Server.WINDOW_ITEMS) {
            WrapperPlayServerWindowItems items = new WrapperPlayServerWindowItems(event);
            this.stateID = items.getStateId();
            List slots = items.getItems();
            for (int i = 0; i < slots.size(); ++i) {
                this.markServerForChangingSlot(i, items.getWindowId());
            }
            int cachedPacketInvSize = this.packetSendingInventorySize;
            AtomicBoolean updatedValue = new AtomicBoolean();
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                if (slots.size() == cachedPacketInvSize || items.getWindowId() == 0) {
                    this.isPacketInventoryActive = true;
                    updatedValue.set(true);
                }
            });
            if (items.getWindowId() == 0) {
                this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                    if (!this.isPacketInventoryActive) {
                        return;
                    }
                    for (int i = 0; i < slots.size(); ++i) {
                        this.inventory.getSlot(i).set((ItemStack)slots.get(i));
                    }
                    if (items.getCarriedItem().isPresent()) {
                        this.inventory.setCarried((ItemStack)items.getCarriedItem().get());
                    }
                });
            } else {
                this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                    if (!this.isPacketInventoryActive) {
                        return;
                    }
                    if (items.getWindowId() == this.openWindowID) {
                        for (int i = 0; i < slots.size(); ++i) {
                            this.menu.getSlot(i).set((ItemStack)slots.get(i));
                        }
                    }
                    if (items.getCarriedItem().isPresent()) {
                        this.inventory.setCarried((ItemStack)items.getCarriedItem().get());
                    }
                });
            }
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                if (updatedValue.get() && !this.menu.equals(this.inventory)) {
                    this.isPacketInventoryActive = false;
                }
            });
        }
        if (event.getPacketType() == PacketType.Play.Server.SET_SLOT) {
            WrapperPlayServerSetSlot slot = new WrapperPlayServerSetSlot(event);
            if (slot.getWindowId() == -2) {
                this.inventory.getInventoryStorage().handleServerCorrectSlot(slot.getSlot());
            } else if (slot.getWindowId() == 0) {
                this.inventory.getInventoryStorage().handleServerCorrectSlot(slot.getSlot());
            } else {
                this.markServerForChangingSlot(slot.getSlot(), slot.getWindowId());
            }
            this.stateID = slot.getStateId();
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                if (!this.isPacketInventoryActive) {
                    return;
                }
                if (slot.getWindowId() == -1) {
                    this.inventory.setCarried(slot.getItem());
                } else if (slot.getWindowId() == -2) {
                    if (this.inventory.getInventoryStorage().getSize() > slot.getSlot() && slot.getSlot() >= 0) {
                        this.inventory.getInventoryStorage().setItem(slot.getSlot(), slot.getItem());
                    }
                } else if (slot.getWindowId() == 0) {
                    if (slot.getSlot() >= 0 && slot.getSlot() <= 45) {
                        this.inventory.getSlot(slot.getSlot()).set(slot.getItem());
                    }
                } else if (slot.getWindowId() == this.openWindowID) {
                    this.menu.getSlot(slot.getSlot()).set(slot.getItem());
                }
            });
        }
    }

    private void closeActiveInventory() {
        this.openWindowID = 0;
        this.menu = this.inventory;
        this.menu.setCarried(ItemStack.EMPTY);
    }

    private /* synthetic */ void lambda$onPacketSend$2(WrapperPlayServerOpenHorseWindow open) {
        this.isPacketInventoryActive = false;
        this.needResend = true;
        this.openWindowID = open.getWindowId();
    }
}

