/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.incendo.cloud.processors.requirements;

import ac.grim.grimac.shaded.incendo.cloud.processors.requirements.Requirement;
import ac.grim.grimac.shaded.incendo.cloud.processors.requirements.RequirementsImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE, since="1.0.0")
public interface Requirements<C, R extends Requirement<C, R>>
extends Iterable<R> {
    private static <C, R extends Requirement<C, R>> @NonNull List<@NonNull R> extractRequirements(@NonNull List<@NonNull R> requirements) {
        Objects.requireNonNull(requirements, "requirements");
        ArrayList<Requirement> extractedRequirements = new ArrayList<Requirement>();
        for (Requirement requirement : requirements) {
            Objects.requireNonNull(requirement, "requirement");
            for (Requirement parentRequirement : Requirements.extractRequirements(requirement.parents())) {
                if (extractedRequirements.contains(parentRequirement)) continue;
                extractedRequirements.add(parentRequirement);
            }
            if (extractedRequirements.contains(requirement)) continue;
            extractedRequirements.add(requirement);
        }
        return List.copyOf(extractedRequirements);
    }

    public static <C, R extends Requirement<C, R>> @NonNull Requirements<C, R> empty() {
        return new RequirementsImpl(List.of());
    }

    public static <C, R extends Requirement<C, R>> @NonNull Requirements<C, R> of(@NonNull List<@NonNull R> requirements) {
        return new RequirementsImpl(Requirements.extractRequirements(requirements));
    }

    @SafeVarargs
    public static <C, R extends Requirement<C, R>> @NonNull Requirements<C, R> of(R ... requirements) {
        return Requirements.of(Arrays.asList(requirements));
    }

    default public @NonNull Requirements<C, R> with(@NonNull R requirement) {
        ArrayList<@NonNull R> requirements = new ArrayList<R>(this.requirements());
        requirements.add(requirement);
        return Requirements.of(requirements);
    }

    public @NonNull List<@NonNull R> requirements();

    @Override
    default public @NonNull Iterator<@NonNull R> iterator() {
        return this.requirements().iterator();
    }
}

