/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.math;

import ac.grim.grimac.shaded.jetbrains.annotations.Contract;
import lombok.Generated;

public final class OptifineFastMath {
    private static final float[] SIN_TABLE_FAST = new float[4096];
    private static final float radToIndex = OptifineFastMath.roundToFloat(651.8986469044033);

    @Contract(pure=true)
    public static float sin(float value) {
        return SIN_TABLE_FAST[(int)(value * radToIndex) & 0xFFF];
    }

    @Contract(pure=true)
    public static float cos(float value) {
        return SIN_TABLE_FAST[(int)(value * radToIndex + 1024.0f) & 0xFFF];
    }

    @Contract(pure=true)
    public static float roundToFloat(double value) {
        return (float)((double)Math.round(value * 1.0E8) / 1.0E8);
    }

    @Generated
    private OptifineFastMath() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (int j = 0; j < SIN_TABLE_FAST.length; ++j) {
            OptifineFastMath.SIN_TABLE_FAST[j] = OptifineFastMath.roundToFloat(StrictMath.sin((double)j * Math.PI * 2.0 / 4096.0));
        }
    }
}

