/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.fabric.player;

import ac.grim.grimac.platform.api.entity.GrimEntity;
import ac.grim.grimac.platform.api.player.AbstractPlatformPlayerFactory;
import ac.grim.grimac.platform.api.player.OfflinePlatformPlayer;
import ac.grim.grimac.platform.api.player.PlatformPlayer;
import ac.grim.grimac.platform.fabric.GrimACFabricLoaderPlugin;
import ac.grim.grimac.platform.fabric.player.AbstractFabricPlatformInventory;
import ac.grim.grimac.platform.fabric.player.AbstractFabricPlatformPlayer;
import ac.grim.grimac.platform.fabric.player.FabricOfflinePlatformPlayer;
import com.mojang.authlib.GameProfile;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class FabricPlatformPlayerFactory
extends AbstractPlatformPlayerFactory<class_3222> {
    private final Map<UUID, OfflinePlatformPlayer> offlinePlatformPlayerCache = new HashMap<UUID, OfflinePlatformPlayer>();
    private final Function<class_3222, AbstractFabricPlatformPlayer> getPlayerFunction;
    private final Function<class_1297, GrimEntity> getEntityFunction;
    private final Function<class_3222, AbstractFabricPlatformInventory> getPlayerInventoryFunction;

    protected class_3222 getNativePlayer(@NotNull UUID uuid) {
        return GrimACFabricLoaderPlugin.FABRIC_SERVER.method_3760().method_14602(uuid);
    }

    protected class_3222 getNativePlayer(@NotNull String name) {
        return GrimACFabricLoaderPlugin.FABRIC_SERVER.method_3760().method_14566(name);
    }

    protected AbstractFabricPlatformPlayer createPlatformPlayer(@NotNull class_3222 nativePlayer) {
        return this.getPlayerFunction.apply(nativePlayer);
    }

    protected UUID getPlayerUUID(@NotNull class_3222 nativePlayer) {
        return nativePlayer.method_5667();
    }

    protected Collection<class_3222> getNativeOnlinePlayers() {
        return GrimACFabricLoaderPlugin.FABRIC_SERVER.method_3760().method_14571();
    }

    public OfflinePlatformPlayer getOfflineFromUUID(@NotNull UUID uuid) {
        return null;
    }

    public OfflinePlatformPlayer getOfflineFromName(@NotNull String name) {
        PlatformPlayer result = this.getFromName(name);
        if (result == null) {
            GameProfile profile = null;
            if (GrimACFabricLoaderPlugin.FABRIC_SERVER.method_3828()) {
                profile = GrimACFabricLoaderPlugin.LOADER.getPlatformServer().getProfileByName(name);
            }
            result = this.getOfflinePlayer(profile != null ? profile : new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8)), name));
        } else {
            this.offlinePlatformPlayerCache.remove(result.getUniqueId());
        }
        return result;
    }

    public OfflinePlatformPlayer getOfflinePlayer(GameProfile profile) {
        FabricOfflinePlatformPlayer player = new FabricOfflinePlatformPlayer(profile.getId(), profile.getName());
        this.offlinePlatformPlayerCache.put(profile.getId(), player);
        return player;
    }

    public void replaceNativePlayer(@NotNull UUID uuid, @NotNull class_3222 serverPlayerEntity) {
        this.cache.getPlayer(uuid).replaceNativePlayer((Object)serverPlayerEntity);
    }

    public AbstractFabricPlatformInventory getPlatformInventory(class_3222 serverPlayerEntity) {
        return this.getPlayerInventoryFunction.apply(serverPlayerEntity);
    }

    public GrimEntity getPlatformEntity(class_1297 entity) {
        return this.getEntityFunction.apply(entity);
    }

    @Generated
    public FabricPlatformPlayerFactory(Function<class_3222, AbstractFabricPlatformPlayer> getPlayerFunction, Function<class_1297, GrimEntity> getEntityFunction, Function<class_3222, AbstractFabricPlatformInventory> getPlayerInventoryFunction) {
        this.getPlayerFunction = getPlayerFunction;
        this.getEntityFunction = getEntityFunction;
        this.getPlayerInventoryFunction = getPlayerInventoryFunction;
    }
}

