/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.fabric.scheduler;

import ac.grim.grimac.api.plugin.GrimPlugin;
import ac.grim.grimac.platform.api.scheduler.GlobalRegionScheduler;
import ac.grim.grimac.platform.api.scheduler.TaskHandle;
import ac.grim.grimac.platform.fabric.GrimACFabricLoaderPlugin;
import ac.grim.grimac.platform.fabric.scheduler.FabricPlatformScheduler;
import ac.grim.grimac.platform.fabric.scheduler.FabricTaskHandle;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class FabricGlobalRegionScheduler
implements GlobalRegionScheduler {
    private final Map<FabricPlatformScheduler.ScheduledTask, Runnable> taskMap = new ConcurrentHashMap<FabricPlatformScheduler.ScheduledTask, Runnable>();
    private final GrimPlugin plugin;

    public FabricGlobalRegionScheduler(GrimPlugin plugin) {
        this.plugin = plugin;
        ServerTickEvents.END_SERVER_TICK.register(this::handleTasks);
    }

    private void handleTasks(MinecraftServer server) {
        FabricPlatformScheduler.handleSyncTasks(this.taskMap, server, this.plugin);
    }

    public void execute(@NotNull GrimPlugin plugin, @NotNull Runnable run) {
        this.run(plugin, run);
    }

    public TaskHandle run(@NotNull GrimPlugin plugin, @NotNull Runnable task) {
        return this.runDelayed(plugin, task, 0L);
    }

    public TaskHandle runDelayed(@NotNull GrimPlugin plugin, @NotNull Runnable task, long delay) {
        FabricPlatformScheduler.ScheduledTask scheduledTask = new FabricPlatformScheduler.ScheduledTask(task, (long)GrimACFabricLoaderPlugin.FABRIC_SERVER.method_3780() + delay, 0L, false, plugin);
        Runnable cancellationTask = () -> this.taskMap.remove(scheduledTask);
        this.taskMap.put(scheduledTask, cancellationTask);
        return new FabricTaskHandle(cancellationTask, true);
    }

    public TaskHandle runAtFixedRate(@NotNull GrimPlugin plugin, @NotNull Runnable task, long initialDelayTicks, long periodTicks) {
        FabricPlatformScheduler.ScheduledTask scheduledTask = new FabricPlatformScheduler.ScheduledTask(task, (long)GrimACFabricLoaderPlugin.FABRIC_SERVER.method_3780() + initialDelayTicks, periodTicks, true, plugin);
        Runnable cancellationTask = () -> this.taskMap.remove(scheduledTask);
        this.taskMap.put(scheduledTask, cancellationTask);
        return new FabricTaskHandle(cancellationTask, true);
    }

    public void cancel(@NotNull GrimPlugin plugin) {
        FabricPlatformScheduler.cancelPluginTasks(this.taskMap, plugin);
    }

    public void cancelAll() {
        FabricPlatformScheduler.cancelAllTasks(this.taskMap);
    }
}

