/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.util;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.MathUtil;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import ac.grim.grimac.shaded.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.Internal
public final class LpVector3d {
    private static final double ABS_MAX_VALUE = Double.longBitsToDouble(4760304806130089984L);
    private static final double ABS_MIN_VALUE = Double.longBitsToDouble(4539628699284145152L);

    private LpVector3d() {
    }

    public static Vector3d read(PacketWrapper<?> wrapper) {
        short b0 = wrapper.readUnsignedByte();
        if (b0 == 0) {
            return Vector3d.zero();
        }
        long bits = (long)b0 | (long)wrapper.readUnsignedByte() << 8 | wrapper.readUnsignedInt() << 16;
        long max = (long)b0 & 3L;
        if (((long)b0 & 4L) != 0L) {
            max |= ((long)wrapper.readVarInt() & 0xFFFFFFFFL) << 2;
        }
        return new Vector3d(LpVector3d.unpack(bits >> 3) * (double)max, LpVector3d.unpack(bits >> 18) * (double)max, LpVector3d.unpack(bits >> 33) * (double)max);
    }

    public static void write(PacketWrapper<?> wrapper, Vector3d vector) {
        double z;
        double y;
        double x = LpVector3d.sanitize(vector.x);
        double max = MathUtil.absMax(x, MathUtil.absMax(y = LpVector3d.sanitize(vector.y), z = LpVector3d.sanitize(vector.z)));
        if (max < ABS_MIN_VALUE) {
            wrapper.writeByte(0);
            return;
        }
        long maxLong = MathUtil.ceilLong(max);
        boolean large = (maxLong & 3L) != maxLong;
        long mul = large ? maxLong % 3L | 4L : maxLong;
        long packedX = LpVector3d.pack(x / (double)maxLong) << 3;
        long packedY = LpVector3d.pack(y / (double)maxLong) << 18;
        long packedZ = LpVector3d.pack(z / (double)maxLong) << 33;
        long bits = mul | packedX | packedY | packedZ;
        wrapper.writeShortLE((short)bits);
        wrapper.writeInt((int)(bits >> 16));
        if (large) {
            wrapper.writeVarInt((int)(maxLong >> 2));
        }
    }

    private static double sanitize(double comp) {
        if (!Double.isNaN(comp)) {
            return MathUtil.clamp(comp, -ABS_MAX_VALUE, ABS_MAX_VALUE);
        }
        return 0.0;
    }

    private static long pack(double comp) {
        return Math.round((comp * 0.5 + 0.5) * 32766.0);
    }

    private static double unpack(long bits) {
        return Math.min((double)(bits & 0x7FFFL), 32766.0) * 2.0 / 32766.0 - 1.0;
    }
}

