/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.maps.weak;

import ac.grim.grimac.shaded.maps.LiteJoiner;
import ac.grim.grimac.shaded.maps.weak.Dynamic;
import ac.grim.grimac.shaded.maps.weak.DynamicChildLogic;
import ac.grim.grimac.shaded.maps.weak.DynamicCollection;
import ac.grim.grimac.shaded.maps.weak.DynamicList;
import ac.grim.grimac.shaded.maps.weak.DynamicMap;
import ac.grim.grimac.shaded.maps.weak.DynamicSomething;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

interface DynamicChild
extends Dynamic {
    public static final String ARROW = "->";

    public static DynamicChild from(Dynamic parent, Object key, Object val) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(key);
        Objects.requireNonNull(val);
        if (val instanceof Map) {
            return new DynamicMap.Child(parent, key, (Map)val);
        }
        if (val instanceof List) {
            return new DynamicList.Child(parent, key, (List)val);
        }
        if (val instanceof Collection) {
            return new DynamicCollection.Child(parent, key, (Collection)val);
        }
        return new DynamicSomething.Child(parent, key, val);
    }

    public static DynamicChild key(Dynamic parent, Object key) {
        return DynamicChild.from(parent, key, key);
    }

    public Dynamic parent();

    @Override
    default public <T> T as(Class<T> type) {
        try {
            return type.cast(this.asObject());
        }
        catch (ClassCastException ex) {
            LinkedList<Object> ascendingKeyChain = DynamicChildLogic.using(this).getAscendingKeyChainWithRoot();
            Object thisKey = ascendingKeyChain.pollLast();
            ascendingKeyChain.add(String.format("*%s*", thisKey));
            throw new ClassCastException(String.format("'%s' miscast in path %s: %s. Avoid by checking `if (aDynamic.is(%s.class)) ...` or using `aDynamic.maybe().as(%<s.class)`", thisKey, LiteJoiner.on(ARROW).join(ascendingKeyChain), ex.getMessage(), type.getSimpleName()));
        }
    }
}

